// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DuoModifyCollectionReader is a Reader for the DuoModifyCollection structure.
type DuoModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DuoModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDuoModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDuoModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDuoModifyCollectionOK creates a DuoModifyCollectionOK with default headers values
func NewDuoModifyCollectionOK() *DuoModifyCollectionOK {
	return &DuoModifyCollectionOK{}
}

/*
DuoModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type DuoModifyCollectionOK struct {
}

// IsSuccess returns true when this duo modify collection o k response has a 2xx status code
func (o *DuoModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this duo modify collection o k response has a 3xx status code
func (o *DuoModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this duo modify collection o k response has a 4xx status code
func (o *DuoModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this duo modify collection o k response has a 5xx status code
func (o *DuoModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this duo modify collection o k response a status code equal to that given
func (o *DuoModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the duo modify collection o k response
func (o *DuoModifyCollectionOK) Code() int {
	return 200
}

func (o *DuoModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /security/authentication/duo/profiles][%d] duoModifyCollectionOK", 200)
}

func (o *DuoModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /security/authentication/duo/profiles][%d] duoModifyCollectionOK", 200)
}

func (o *DuoModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDuoModifyCollectionDefault creates a DuoModifyCollectionDefault with default headers values
func NewDuoModifyCollectionDefault(code int) *DuoModifyCollectionDefault {
	return &DuoModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
DuoModifyCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type DuoModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this duo modify collection default response has a 2xx status code
func (o *DuoModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this duo modify collection default response has a 3xx status code
func (o *DuoModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this duo modify collection default response has a 4xx status code
func (o *DuoModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this duo modify collection default response has a 5xx status code
func (o *DuoModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this duo modify collection default response a status code equal to that given
func (o *DuoModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the duo modify collection default response
func (o *DuoModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *DuoModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/authentication/duo/profiles][%d] duo_modify_collection default %s", o._statusCode, payload)
}

func (o *DuoModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/authentication/duo/profiles][%d] duo_modify_collection default %s", o._statusCode, payload)
}

func (o *DuoModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DuoModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
DuoModifyCollectionBody duo modify collection body
swagger:model DuoModifyCollectionBody
*/
type DuoModifyCollectionBody struct {

	// links
	Links *models.DuoInlineLinks `json:"_links,omitempty"`

	// The URL at which the Duo API is hosted.
	// Example: api-****.duo.com
	APIHost *string `json:"api_host,omitempty"`

	// Automatically sends a push notification for authentication when using Duo.
	// Example: true
	AutoPush *bool `json:"auto_push,omitempty"`

	// Comment for the Duo profile.
	Comment *string `json:"comment,omitempty"`

	// duo response inline records
	DuoResponseInlineRecords []*models.Duo `json:"records,omitempty"`

	// Determines the behavior of the system when it cannot communicate with the Duo service.
	// Example: safe
	// Enum: ["safe","secure"]
	FailMode *string `json:"fail_mode,omitempty"`

	// The SHA fingerprint corresponding to the Duo secret key.
	// Read Only: true
	Fingerprint *string `json:"fingerprint,omitempty"`

	// Specifies the HTTP proxy server to be used when connecting to the Duo service.
	// Example: IPaddress:port
	HTTPProxy *string `json:"http_proxy,omitempty"`

	// The Integration Key associated with the Duo profile.
	IntegrationKey *string `json:"integration_key,omitempty"`

	// Indicates whether the Duo authentication feature is active or inactive.
	// Example: true
	IsEnabled *bool `json:"is_enabled,omitempty"`

	// The maximum number of authentication attempts allowed for a user before the process is terminated.
	// Example: 1
	// Maximum: 3
	// Minimum: 1
	MaxPrompts *int64 `json:"max_prompts,omitempty"`

	// owner
	Owner *models.DuoInlineOwner `json:"owner,omitempty"`

	// Additional information sent along with the push notification for Duo authentication.
	// Example: true
	PushInfo *bool `json:"push_info,omitempty"`

	// The Secret Key associated with the Duo profile.
	SecretKey *string `json:"secret_key,omitempty"`

	// Information on the reachability status of Duo.
	// Example: OK
	// Read Only: true
	Status *string `json:"status,omitempty"`
}

// Validate validates this duo modify collection body
func (o *DuoModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDuoResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFailMode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxPrompts(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOwner(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DuoModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *DuoModifyCollectionBody) validateDuoResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.DuoResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.DuoResponseInlineRecords); i++ {
		if swag.IsZero(o.DuoResponseInlineRecords[i]) { // not required
			continue
		}

		if o.DuoResponseInlineRecords[i] != nil {
			if err := o.DuoResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var duoModifyCollectionBodyTypeFailModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["safe","secure"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		duoModifyCollectionBodyTypeFailModePropEnum = append(duoModifyCollectionBodyTypeFailModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// DuoModifyCollectionBody
	// DuoModifyCollectionBody
	// fail_mode
	// FailMode
	// safe
	// END DEBUGGING
	// DuoModifyCollectionBodyFailModeSafe captures enum value "safe"
	DuoModifyCollectionBodyFailModeSafe string = "safe"

	// BEGIN DEBUGGING
	// DuoModifyCollectionBody
	// DuoModifyCollectionBody
	// fail_mode
	// FailMode
	// secure
	// END DEBUGGING
	// DuoModifyCollectionBodyFailModeSecure captures enum value "secure"
	DuoModifyCollectionBodyFailModeSecure string = "secure"
)

// prop value enum
func (o *DuoModifyCollectionBody) validateFailModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, duoModifyCollectionBodyTypeFailModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *DuoModifyCollectionBody) validateFailMode(formats strfmt.Registry) error {
	if swag.IsZero(o.FailMode) { // not required
		return nil
	}

	// value enum
	if err := o.validateFailModeEnum("info"+"."+"fail_mode", "body", *o.FailMode); err != nil {
		return err
	}

	return nil
}

func (o *DuoModifyCollectionBody) validateMaxPrompts(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxPrompts) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"max_prompts", "body", *o.MaxPrompts, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"max_prompts", "body", *o.MaxPrompts, 3, false); err != nil {
		return err
	}

	return nil
}

func (o *DuoModifyCollectionBody) validateOwner(formats strfmt.Registry) error {
	if swag.IsZero(o.Owner) { // not required
		return nil
	}

	if o.Owner != nil {
		if err := o.Owner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this duo modify collection body based on the context it is used
func (o *DuoModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDuoResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFingerprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DuoModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *DuoModifyCollectionBody) contextValidateDuoResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DuoResponseInlineRecords); i++ {

		if o.DuoResponseInlineRecords[i] != nil {
			if err := o.DuoResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DuoModifyCollectionBody) contextValidateFingerprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"fingerprint", "body", o.Fingerprint); err != nil {
		return err
	}

	return nil
}

func (o *DuoModifyCollectionBody) contextValidateOwner(ctx context.Context, formats strfmt.Registry) error {

	if o.Owner != nil {
		if err := o.Owner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner")
			}
			return err
		}
	}

	return nil
}

func (o *DuoModifyCollectionBody) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DuoModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DuoModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res DuoModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DuoInlineLinks duo inline links
swagger:model duo_inline__links
*/
type DuoInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this duo inline links
func (o *DuoInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DuoInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this duo inline links based on the context it is used
func (o *DuoInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DuoInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DuoInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DuoInlineLinks) UnmarshalBinary(b []byte) error {
	var res DuoInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DuoInlineOwner SVM name and UUID for which the Duo profile is configured.
swagger:model duo_inline_owner
*/
type DuoInlineOwner struct {

	// links
	Links *models.DuoInlineOwnerInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this duo inline owner
func (o *DuoInlineOwner) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DuoInlineOwner) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this duo inline owner based on the context it is used
func (o *DuoInlineOwner) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DuoInlineOwner) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DuoInlineOwner) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DuoInlineOwner) UnmarshalBinary(b []byte) error {
	var res DuoInlineOwner
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DuoInlineOwnerInlineLinks duo inline owner inline links
swagger:model duo_inline_owner_inline__links
*/
type DuoInlineOwnerInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this duo inline owner inline links
func (o *DuoInlineOwnerInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DuoInlineOwnerInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this duo inline owner inline links based on the context it is used
func (o *DuoInlineOwnerInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DuoInlineOwnerInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DuoInlineOwnerInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DuoInlineOwnerInlineLinks) UnmarshalBinary(b []byte) error {
	var res DuoInlineOwnerInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
