// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewDuoModifyParams creates a new DuoModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDuoModifyParams() *DuoModifyParams {
	return &DuoModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDuoModifyParamsWithTimeout creates a new DuoModifyParams object
// with the ability to set a timeout on a request.
func NewDuoModifyParamsWithTimeout(timeout time.Duration) *DuoModifyParams {
	return &DuoModifyParams{
		timeout: timeout,
	}
}

// NewDuoModifyParamsWithContext creates a new DuoModifyParams object
// with the ability to set a context for a request.
func NewDuoModifyParamsWithContext(ctx context.Context) *DuoModifyParams {
	return &DuoModifyParams{
		Context: ctx,
	}
}

// NewDuoModifyParamsWithHTTPClient creates a new DuoModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewDuoModifyParamsWithHTTPClient(client *http.Client) *DuoModifyParams {
	return &DuoModifyParams{
		HTTPClient: client,
	}
}

/*
DuoModifyParams contains all the parameters to send to the API endpoint

	for the duo modify operation.

	Typically these are written to a http.Request.
*/
type DuoModifyParams struct {

	/* Info.

	   Duo modification details.
	*/
	Info *models.Duo

	/* OwnerUUID.

	   Account owner UUID
	*/
	OwnerUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the duo modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DuoModifyParams) WithDefaults() *DuoModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the duo modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DuoModifyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the duo modify params
func (o *DuoModifyParams) WithTimeout(timeout time.Duration) *DuoModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the duo modify params
func (o *DuoModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the duo modify params
func (o *DuoModifyParams) WithContext(ctx context.Context) *DuoModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the duo modify params
func (o *DuoModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the duo modify params
func (o *DuoModifyParams) WithHTTPClient(client *http.Client) *DuoModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the duo modify params
func (o *DuoModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the duo modify params
func (o *DuoModifyParams) WithInfo(info *models.Duo) *DuoModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the duo modify params
func (o *DuoModifyParams) SetInfo(info *models.Duo) {
	o.Info = info
}

// WithOwnerUUID adds the ownerUUID to the duo modify params
func (o *DuoModifyParams) WithOwnerUUID(ownerUUID string) *DuoModifyParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the duo modify params
func (o *DuoModifyParams) SetOwnerUUID(ownerUUID string) {
	o.OwnerUUID = ownerUUID
}

// WriteToRequest writes these params to a swagger request
func (o *DuoModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param owner.uuid
	if err := r.SetPathParam("owner.uuid", o.OwnerUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
