// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DuoModifyReader is a Reader for the DuoModify structure.
type DuoModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DuoModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDuoModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDuoModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDuoModifyOK creates a DuoModifyOK with default headers values
func NewDuoModifyOK() *DuoModifyOK {
	return &DuoModifyOK{}
}

/*
DuoModifyOK describes a response with status code 200, with default header values.

OK
*/
type DuoModifyOK struct {
}

// IsSuccess returns true when this duo modify o k response has a 2xx status code
func (o *DuoModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this duo modify o k response has a 3xx status code
func (o *DuoModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this duo modify o k response has a 4xx status code
func (o *DuoModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this duo modify o k response has a 5xx status code
func (o *DuoModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this duo modify o k response a status code equal to that given
func (o *DuoModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the duo modify o k response
func (o *DuoModifyOK) Code() int {
	return 200
}

func (o *DuoModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /security/authentication/duo/profiles/{owner.uuid}][%d] duoModifyOK", 200)
}

func (o *DuoModifyOK) String() string {
	return fmt.Sprintf("[PATCH /security/authentication/duo/profiles/{owner.uuid}][%d] duoModifyOK", 200)
}

func (o *DuoModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDuoModifyDefault creates a DuoModifyDefault with default headers values
func NewDuoModifyDefault(code int) *DuoModifyDefault {
	return &DuoModifyDefault{
		_statusCode: code,
	}
}

/*
DuoModifyDefault describes a response with status code -1, with default header values.

Error
*/
type DuoModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this duo modify default response has a 2xx status code
func (o *DuoModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this duo modify default response has a 3xx status code
func (o *DuoModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this duo modify default response has a 4xx status code
func (o *DuoModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this duo modify default response has a 5xx status code
func (o *DuoModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this duo modify default response a status code equal to that given
func (o *DuoModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the duo modify default response
func (o *DuoModifyDefault) Code() int {
	return o._statusCode
}

func (o *DuoModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/authentication/duo/profiles/{owner.uuid}][%d] duo_modify default %s", o._statusCode, payload)
}

func (o *DuoModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/authentication/duo/profiles/{owner.uuid}][%d] duo_modify default %s", o._statusCode, payload)
}

func (o *DuoModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DuoModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
