// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewDuogroupCreateParams creates a new DuogroupCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDuogroupCreateParams() *DuogroupCreateParams {
	return &DuogroupCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDuogroupCreateParamsWithTimeout creates a new DuogroupCreateParams object
// with the ability to set a timeout on a request.
func NewDuogroupCreateParamsWithTimeout(timeout time.Duration) *DuogroupCreateParams {
	return &DuogroupCreateParams{
		timeout: timeout,
	}
}

// NewDuogroupCreateParamsWithContext creates a new DuogroupCreateParams object
// with the ability to set a context for a request.
func NewDuogroupCreateParamsWithContext(ctx context.Context) *DuogroupCreateParams {
	return &DuogroupCreateParams{
		Context: ctx,
	}
}

// NewDuogroupCreateParamsWithHTTPClient creates a new DuogroupCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewDuogroupCreateParamsWithHTTPClient(client *http.Client) *DuogroupCreateParams {
	return &DuogroupCreateParams{
		HTTPClient: client,
	}
}

/*
DuogroupCreateParams contains all the parameters to send to the API endpoint

	for the duogroup create operation.

	Typically these are written to a http.Request.
*/
type DuogroupCreateParams struct {

	/* Info.

	   Duo group details.
	*/
	Info *models.Duogroup

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the duogroup create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DuogroupCreateParams) WithDefaults() *DuogroupCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the duogroup create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DuogroupCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := DuogroupCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the duogroup create params
func (o *DuogroupCreateParams) WithTimeout(timeout time.Duration) *DuogroupCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the duogroup create params
func (o *DuogroupCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the duogroup create params
func (o *DuogroupCreateParams) WithContext(ctx context.Context) *DuogroupCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the duogroup create params
func (o *DuogroupCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the duogroup create params
func (o *DuogroupCreateParams) WithHTTPClient(client *http.Client) *DuogroupCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the duogroup create params
func (o *DuogroupCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the duogroup create params
func (o *DuogroupCreateParams) WithInfo(info *models.Duogroup) *DuogroupCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the duogroup create params
func (o *DuogroupCreateParams) SetInfo(info *models.Duogroup) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the duogroup create params
func (o *DuogroupCreateParams) WithReturnRecords(returnRecords *bool) *DuogroupCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the duogroup create params
func (o *DuogroupCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *DuogroupCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
