// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DuogroupModifyCollectionReader is a Reader for the DuogroupModifyCollection structure.
type DuogroupModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DuogroupModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDuogroupModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDuogroupModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDuogroupModifyCollectionOK creates a DuogroupModifyCollectionOK with default headers values
func NewDuogroupModifyCollectionOK() *DuogroupModifyCollectionOK {
	return &DuogroupModifyCollectionOK{}
}

/*
DuogroupModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type DuogroupModifyCollectionOK struct {
}

// IsSuccess returns true when this duogroup modify collection o k response has a 2xx status code
func (o *DuogroupModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this duogroup modify collection o k response has a 3xx status code
func (o *DuogroupModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this duogroup modify collection o k response has a 4xx status code
func (o *DuogroupModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this duogroup modify collection o k response has a 5xx status code
func (o *DuogroupModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this duogroup modify collection o k response a status code equal to that given
func (o *DuogroupModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the duogroup modify collection o k response
func (o *DuogroupModifyCollectionOK) Code() int {
	return 200
}

func (o *DuogroupModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /security/authentication/duo/groups][%d] duogroupModifyCollectionOK", 200)
}

func (o *DuogroupModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /security/authentication/duo/groups][%d] duogroupModifyCollectionOK", 200)
}

func (o *DuogroupModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDuogroupModifyCollectionDefault creates a DuogroupModifyCollectionDefault with default headers values
func NewDuogroupModifyCollectionDefault(code int) *DuogroupModifyCollectionDefault {
	return &DuogroupModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
DuogroupModifyCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type DuogroupModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this duogroup modify collection default response has a 2xx status code
func (o *DuogroupModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this duogroup modify collection default response has a 3xx status code
func (o *DuogroupModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this duogroup modify collection default response has a 4xx status code
func (o *DuogroupModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this duogroup modify collection default response has a 5xx status code
func (o *DuogroupModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this duogroup modify collection default response a status code equal to that given
func (o *DuogroupModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the duogroup modify collection default response
func (o *DuogroupModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *DuogroupModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/authentication/duo/groups][%d] duogroup_modify_collection default %s", o._statusCode, payload)
}

func (o *DuogroupModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/authentication/duo/groups][%d] duogroup_modify_collection default %s", o._statusCode, payload)
}

func (o *DuogroupModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DuogroupModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
DuogroupModifyCollectionBody duogroup modify collection body
swagger:model DuogroupModifyCollectionBody
*/
type DuogroupModifyCollectionBody struct {

	// links
	Links *models.DuogroupInlineLinks `json:"_links,omitempty"`

	// Comment for the Duo group.
	Comment *string `json:"comment,omitempty"`

	// List of excluded users.
	// Example: ["user1","user2"]
	DuogroupInlineExcludedUsers []*string `json:"excluded_users,omitempty"`

	// duogroup response inline records
	DuogroupResponseInlineRecords []*models.Duogroup `json:"records,omitempty"`

	// Name of the group to be included in Duo authentication.
	// Example: AD_Group
	Name *string `json:"name,omitempty"`

	// owner
	Owner *models.DuogroupInlineOwner `json:"owner,omitempty"`
}

// Validate validates this duogroup modify collection body
func (o *DuogroupModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDuogroupResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOwner(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DuogroupModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *DuogroupModifyCollectionBody) validateDuogroupResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.DuogroupResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.DuogroupResponseInlineRecords); i++ {
		if swag.IsZero(o.DuogroupResponseInlineRecords[i]) { // not required
			continue
		}

		if o.DuogroupResponseInlineRecords[i] != nil {
			if err := o.DuogroupResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DuogroupModifyCollectionBody) validateOwner(formats strfmt.Registry) error {
	if swag.IsZero(o.Owner) { // not required
		return nil
	}

	if o.Owner != nil {
		if err := o.Owner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this duogroup modify collection body based on the context it is used
func (o *DuogroupModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDuogroupResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DuogroupModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *DuogroupModifyCollectionBody) contextValidateDuogroupResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.DuogroupResponseInlineRecords); i++ {

		if o.DuogroupResponseInlineRecords[i] != nil {
			if err := o.DuogroupResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *DuogroupModifyCollectionBody) contextValidateOwner(ctx context.Context, formats strfmt.Registry) error {

	if o.Owner != nil {
		if err := o.Owner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DuogroupModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DuogroupModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res DuogroupModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DuogroupInlineLinks duogroup inline links
swagger:model duogroup_inline__links
*/
type DuogroupInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this duogroup inline links
func (o *DuogroupInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DuogroupInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this duogroup inline links based on the context it is used
func (o *DuogroupInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DuogroupInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DuogroupInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DuogroupInlineLinks) UnmarshalBinary(b []byte) error {
	var res DuogroupInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DuogroupInlineOwner SVM name and UUID for which the Duo group profile is configured.
swagger:model duogroup_inline_owner
*/
type DuogroupInlineOwner struct {

	// links
	Links *models.DuogroupInlineOwnerInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this duogroup inline owner
func (o *DuogroupInlineOwner) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DuogroupInlineOwner) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this duogroup inline owner based on the context it is used
func (o *DuogroupInlineOwner) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DuogroupInlineOwner) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DuogroupInlineOwner) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DuogroupInlineOwner) UnmarshalBinary(b []byte) error {
	var res DuogroupInlineOwner
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
DuogroupInlineOwnerInlineLinks duogroup inline owner inline links
swagger:model duogroup_inline_owner_inline__links
*/
type DuogroupInlineOwnerInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this duogroup inline owner inline links
func (o *DuogroupInlineOwnerInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DuogroupInlineOwnerInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this duogroup inline owner inline links based on the context it is used
func (o *DuogroupInlineOwnerInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *DuogroupInlineOwnerInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *DuogroupInlineOwnerInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DuogroupInlineOwnerInlineLinks) UnmarshalBinary(b []byte) error {
	var res DuogroupInlineOwnerInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
