// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewGcpKmsCreateParams creates a new GcpKmsCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGcpKmsCreateParams() *GcpKmsCreateParams {
	return &GcpKmsCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGcpKmsCreateParamsWithTimeout creates a new GcpKmsCreateParams object
// with the ability to set a timeout on a request.
func NewGcpKmsCreateParamsWithTimeout(timeout time.Duration) *GcpKmsCreateParams {
	return &GcpKmsCreateParams{
		timeout: timeout,
	}
}

// NewGcpKmsCreateParamsWithContext creates a new GcpKmsCreateParams object
// with the ability to set a context for a request.
func NewGcpKmsCreateParamsWithContext(ctx context.Context) *GcpKmsCreateParams {
	return &GcpKmsCreateParams{
		Context: ctx,
	}
}

// NewGcpKmsCreateParamsWithHTTPClient creates a new GcpKmsCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewGcpKmsCreateParamsWithHTTPClient(client *http.Client) *GcpKmsCreateParams {
	return &GcpKmsCreateParams{
		HTTPClient: client,
	}
}

/*
GcpKmsCreateParams contains all the parameters to send to the API endpoint

	for the gcp kms create operation.

	Typically these are written to a http.Request.
*/
type GcpKmsCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.GcpKms

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the gcp kms create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GcpKmsCreateParams) WithDefaults() *GcpKmsCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the gcp kms create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GcpKmsCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)

		returnTimeoutDefault = int64(0)
	)

	val := GcpKmsCreateParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the gcp kms create params
func (o *GcpKmsCreateParams) WithTimeout(timeout time.Duration) *GcpKmsCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the gcp kms create params
func (o *GcpKmsCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the gcp kms create params
func (o *GcpKmsCreateParams) WithContext(ctx context.Context) *GcpKmsCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the gcp kms create params
func (o *GcpKmsCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the gcp kms create params
func (o *GcpKmsCreateParams) WithHTTPClient(client *http.Client) *GcpKmsCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the gcp kms create params
func (o *GcpKmsCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the gcp kms create params
func (o *GcpKmsCreateParams) WithInfo(info *models.GcpKms) *GcpKmsCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the gcp kms create params
func (o *GcpKmsCreateParams) SetInfo(info *models.GcpKms) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the gcp kms create params
func (o *GcpKmsCreateParams) WithReturnRecords(returnRecords *bool) *GcpKmsCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the gcp kms create params
func (o *GcpKmsCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the gcp kms create params
func (o *GcpKmsCreateParams) WithReturnTimeout(returnTimeout *int64) *GcpKmsCreateParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the gcp kms create params
func (o *GcpKmsCreateParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *GcpKmsCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
