// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGcpKmsDeleteCollectionParams creates a new GcpKmsDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGcpKmsDeleteCollectionParams() *GcpKmsDeleteCollectionParams {
	return &GcpKmsDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGcpKmsDeleteCollectionParamsWithTimeout creates a new GcpKmsDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewGcpKmsDeleteCollectionParamsWithTimeout(timeout time.Duration) *GcpKmsDeleteCollectionParams {
	return &GcpKmsDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewGcpKmsDeleteCollectionParamsWithContext creates a new GcpKmsDeleteCollectionParams object
// with the ability to set a context for a request.
func NewGcpKmsDeleteCollectionParamsWithContext(ctx context.Context) *GcpKmsDeleteCollectionParams {
	return &GcpKmsDeleteCollectionParams{
		Context: ctx,
	}
}

// NewGcpKmsDeleteCollectionParamsWithHTTPClient creates a new GcpKmsDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewGcpKmsDeleteCollectionParamsWithHTTPClient(client *http.Client) *GcpKmsDeleteCollectionParams {
	return &GcpKmsDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
GcpKmsDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the gcp kms delete collection operation.

	Typically these are written to a http.Request.
*/
type GcpKmsDeleteCollectionParams struct {

	/* AuthenticationMethod.

	   Filter by authentication_method
	*/
	AuthenticationMethod *string

	/* CallerAccount.

	   Filter by caller_account
	*/
	CallerAccount *string

	/* CloudkmsHost.

	   Filter by cloudkms_host
	*/
	CloudkmsHost *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* EkmipReachabilityCode.

	   Filter by ekmip_reachability.code
	*/
	EkmipReachabilityCode *string

	/* EkmipReachabilityMessage.

	   Filter by ekmip_reachability.message
	*/
	EkmipReachabilityMessage *string

	/* EkmipReachabilityNodeName.

	   Filter by ekmip_reachability.node.name
	*/
	EkmipReachabilityNodeName *string

	/* EkmipReachabilityNodeUUID.

	   Filter by ekmip_reachability.node.uuid
	*/
	EkmipReachabilityNodeUUID *string

	/* EkmipReachabilityReachable.

	   Filter by ekmip_reachability.reachable
	*/
	EkmipReachabilityReachable *bool

	/* GceMetadataServer.

	   Filter by gce_metadata_server
	*/
	GceMetadataServer *string

	/* GoogleReachabilityCode.

	   Filter by google_reachability.code
	*/
	GoogleReachabilityCode *string

	/* GoogleReachabilityMessage.

	   Filter by google_reachability.message
	*/
	GoogleReachabilityMessage *string

	/* GoogleReachabilityReachable.

	   Filter by google_reachability.reachable
	*/
	GoogleReachabilityReachable *bool

	/* Info.

	   Info specification
	*/
	Info GcpKmsDeleteCollectionBody

	/* KeyName.

	   Filter by key_name
	*/
	KeyName *string

	/* KeyRingLocation.

	   Filter by key_ring_location
	*/
	KeyRingLocation *string

	/* KeyRingName.

	   Filter by key_ring_name
	*/
	KeyRingName *string

	/* OauthHost.

	   Filter by oauth_host
	*/
	OauthHost *string

	/* OauthURL.

	   Filter by oauth_url
	*/
	OauthURL *string

	/* Port.

	   Filter by port
	*/
	Port *int64

	/* PrivilegedAccount.

	   Filter by privileged_account
	*/
	PrivilegedAccount *string

	/* ProjectID.

	   Filter by project_id
	*/
	ProjectID *string

	/* ProxyHost.

	   Filter by proxy_host
	*/
	ProxyHost *string

	/* ProxyPort.

	   Filter by proxy_port
	*/
	ProxyPort *int64

	/* ProxyType.

	   Filter by proxy_type
	*/
	ProxyType *string

	/* ProxyUsername.

	   Filter by proxy_username
	*/
	ProxyUsername *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* StateClusterState.

	   Filter by state.cluster_state
	*/
	StateClusterState *bool

	/* StateCode.

	   Filter by state.code
	*/
	StateCode *string

	/* StateMessage.

	   Filter by state.message
	*/
	StateMessage *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* VerifyHost.

	   Filter by verify_host
	*/
	VerifyHost *bool

	/* VerifyIP.

	   Filter by verify_ip
	*/
	VerifyIP *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the gcp kms delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GcpKmsDeleteCollectionParams) WithDefaults() *GcpKmsDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the gcp kms delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GcpKmsDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := GcpKmsDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithTimeout(timeout time.Duration) *GcpKmsDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithContext(ctx context.Context) *GcpKmsDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithHTTPClient(client *http.Client) *GcpKmsDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAuthenticationMethod adds the authenticationMethod to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithAuthenticationMethod(authenticationMethod *string) *GcpKmsDeleteCollectionParams {
	o.SetAuthenticationMethod(authenticationMethod)
	return o
}

// SetAuthenticationMethod adds the authenticationMethod to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetAuthenticationMethod(authenticationMethod *string) {
	o.AuthenticationMethod = authenticationMethod
}

// WithCallerAccount adds the callerAccount to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithCallerAccount(callerAccount *string) *GcpKmsDeleteCollectionParams {
	o.SetCallerAccount(callerAccount)
	return o
}

// SetCallerAccount adds the callerAccount to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetCallerAccount(callerAccount *string) {
	o.CallerAccount = callerAccount
}

// WithCloudkmsHost adds the cloudkmsHost to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithCloudkmsHost(cloudkmsHost *string) *GcpKmsDeleteCollectionParams {
	o.SetCloudkmsHost(cloudkmsHost)
	return o
}

// SetCloudkmsHost adds the cloudkmsHost to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetCloudkmsHost(cloudkmsHost *string) {
	o.CloudkmsHost = cloudkmsHost
}

// WithContinueOnFailure adds the continueOnFailure to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *GcpKmsDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithEkmipReachabilityCode adds the ekmipReachabilityCode to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithEkmipReachabilityCode(ekmipReachabilityCode *string) *GcpKmsDeleteCollectionParams {
	o.SetEkmipReachabilityCode(ekmipReachabilityCode)
	return o
}

// SetEkmipReachabilityCode adds the ekmipReachabilityCode to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetEkmipReachabilityCode(ekmipReachabilityCode *string) {
	o.EkmipReachabilityCode = ekmipReachabilityCode
}

// WithEkmipReachabilityMessage adds the ekmipReachabilityMessage to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithEkmipReachabilityMessage(ekmipReachabilityMessage *string) *GcpKmsDeleteCollectionParams {
	o.SetEkmipReachabilityMessage(ekmipReachabilityMessage)
	return o
}

// SetEkmipReachabilityMessage adds the ekmipReachabilityMessage to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetEkmipReachabilityMessage(ekmipReachabilityMessage *string) {
	o.EkmipReachabilityMessage = ekmipReachabilityMessage
}

// WithEkmipReachabilityNodeName adds the ekmipReachabilityNodeName to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithEkmipReachabilityNodeName(ekmipReachabilityNodeName *string) *GcpKmsDeleteCollectionParams {
	o.SetEkmipReachabilityNodeName(ekmipReachabilityNodeName)
	return o
}

// SetEkmipReachabilityNodeName adds the ekmipReachabilityNodeName to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetEkmipReachabilityNodeName(ekmipReachabilityNodeName *string) {
	o.EkmipReachabilityNodeName = ekmipReachabilityNodeName
}

// WithEkmipReachabilityNodeUUID adds the ekmipReachabilityNodeUUID to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithEkmipReachabilityNodeUUID(ekmipReachabilityNodeUUID *string) *GcpKmsDeleteCollectionParams {
	o.SetEkmipReachabilityNodeUUID(ekmipReachabilityNodeUUID)
	return o
}

// SetEkmipReachabilityNodeUUID adds the ekmipReachabilityNodeUuid to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetEkmipReachabilityNodeUUID(ekmipReachabilityNodeUUID *string) {
	o.EkmipReachabilityNodeUUID = ekmipReachabilityNodeUUID
}

// WithEkmipReachabilityReachable adds the ekmipReachabilityReachable to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithEkmipReachabilityReachable(ekmipReachabilityReachable *bool) *GcpKmsDeleteCollectionParams {
	o.SetEkmipReachabilityReachable(ekmipReachabilityReachable)
	return o
}

// SetEkmipReachabilityReachable adds the ekmipReachabilityReachable to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetEkmipReachabilityReachable(ekmipReachabilityReachable *bool) {
	o.EkmipReachabilityReachable = ekmipReachabilityReachable
}

// WithGceMetadataServer adds the gceMetadataServer to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithGceMetadataServer(gceMetadataServer *string) *GcpKmsDeleteCollectionParams {
	o.SetGceMetadataServer(gceMetadataServer)
	return o
}

// SetGceMetadataServer adds the gceMetadataServer to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetGceMetadataServer(gceMetadataServer *string) {
	o.GceMetadataServer = gceMetadataServer
}

// WithGoogleReachabilityCode adds the googleReachabilityCode to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithGoogleReachabilityCode(googleReachabilityCode *string) *GcpKmsDeleteCollectionParams {
	o.SetGoogleReachabilityCode(googleReachabilityCode)
	return o
}

// SetGoogleReachabilityCode adds the googleReachabilityCode to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetGoogleReachabilityCode(googleReachabilityCode *string) {
	o.GoogleReachabilityCode = googleReachabilityCode
}

// WithGoogleReachabilityMessage adds the googleReachabilityMessage to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithGoogleReachabilityMessage(googleReachabilityMessage *string) *GcpKmsDeleteCollectionParams {
	o.SetGoogleReachabilityMessage(googleReachabilityMessage)
	return o
}

// SetGoogleReachabilityMessage adds the googleReachabilityMessage to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetGoogleReachabilityMessage(googleReachabilityMessage *string) {
	o.GoogleReachabilityMessage = googleReachabilityMessage
}

// WithGoogleReachabilityReachable adds the googleReachabilityReachable to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithGoogleReachabilityReachable(googleReachabilityReachable *bool) *GcpKmsDeleteCollectionParams {
	o.SetGoogleReachabilityReachable(googleReachabilityReachable)
	return o
}

// SetGoogleReachabilityReachable adds the googleReachabilityReachable to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetGoogleReachabilityReachable(googleReachabilityReachable *bool) {
	o.GoogleReachabilityReachable = googleReachabilityReachable
}

// WithInfo adds the info to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithInfo(info GcpKmsDeleteCollectionBody) *GcpKmsDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetInfo(info GcpKmsDeleteCollectionBody) {
	o.Info = info
}

// WithKeyName adds the keyName to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithKeyName(keyName *string) *GcpKmsDeleteCollectionParams {
	o.SetKeyName(keyName)
	return o
}

// SetKeyName adds the keyName to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetKeyName(keyName *string) {
	o.KeyName = keyName
}

// WithKeyRingLocation adds the keyRingLocation to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithKeyRingLocation(keyRingLocation *string) *GcpKmsDeleteCollectionParams {
	o.SetKeyRingLocation(keyRingLocation)
	return o
}

// SetKeyRingLocation adds the keyRingLocation to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetKeyRingLocation(keyRingLocation *string) {
	o.KeyRingLocation = keyRingLocation
}

// WithKeyRingName adds the keyRingName to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithKeyRingName(keyRingName *string) *GcpKmsDeleteCollectionParams {
	o.SetKeyRingName(keyRingName)
	return o
}

// SetKeyRingName adds the keyRingName to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetKeyRingName(keyRingName *string) {
	o.KeyRingName = keyRingName
}

// WithOauthHost adds the oauthHost to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithOauthHost(oauthHost *string) *GcpKmsDeleteCollectionParams {
	o.SetOauthHost(oauthHost)
	return o
}

// SetOauthHost adds the oauthHost to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetOauthHost(oauthHost *string) {
	o.OauthHost = oauthHost
}

// WithOauthURL adds the oauthURL to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithOauthURL(oauthURL *string) *GcpKmsDeleteCollectionParams {
	o.SetOauthURL(oauthURL)
	return o
}

// SetOauthURL adds the oauthUrl to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetOauthURL(oauthURL *string) {
	o.OauthURL = oauthURL
}

// WithPort adds the port to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithPort(port *int64) *GcpKmsDeleteCollectionParams {
	o.SetPort(port)
	return o
}

// SetPort adds the port to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetPort(port *int64) {
	o.Port = port
}

// WithPrivilegedAccount adds the privilegedAccount to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithPrivilegedAccount(privilegedAccount *string) *GcpKmsDeleteCollectionParams {
	o.SetPrivilegedAccount(privilegedAccount)
	return o
}

// SetPrivilegedAccount adds the privilegedAccount to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetPrivilegedAccount(privilegedAccount *string) {
	o.PrivilegedAccount = privilegedAccount
}

// WithProjectID adds the projectID to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithProjectID(projectID *string) *GcpKmsDeleteCollectionParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetProjectID(projectID *string) {
	o.ProjectID = projectID
}

// WithProxyHost adds the proxyHost to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithProxyHost(proxyHost *string) *GcpKmsDeleteCollectionParams {
	o.SetProxyHost(proxyHost)
	return o
}

// SetProxyHost adds the proxyHost to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetProxyHost(proxyHost *string) {
	o.ProxyHost = proxyHost
}

// WithProxyPort adds the proxyPort to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithProxyPort(proxyPort *int64) *GcpKmsDeleteCollectionParams {
	o.SetProxyPort(proxyPort)
	return o
}

// SetProxyPort adds the proxyPort to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetProxyPort(proxyPort *int64) {
	o.ProxyPort = proxyPort
}

// WithProxyType adds the proxyType to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithProxyType(proxyType *string) *GcpKmsDeleteCollectionParams {
	o.SetProxyType(proxyType)
	return o
}

// SetProxyType adds the proxyType to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetProxyType(proxyType *string) {
	o.ProxyType = proxyType
}

// WithProxyUsername adds the proxyUsername to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithProxyUsername(proxyUsername *string) *GcpKmsDeleteCollectionParams {
	o.SetProxyUsername(proxyUsername)
	return o
}

// SetProxyUsername adds the proxyUsername to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetProxyUsername(proxyUsername *string) {
	o.ProxyUsername = proxyUsername
}

// WithReturnRecords adds the returnRecords to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *GcpKmsDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *GcpKmsDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithScope(scope *string) *GcpKmsDeleteCollectionParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSerialRecords adds the serialRecords to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *GcpKmsDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithStateClusterState adds the stateClusterState to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithStateClusterState(stateClusterState *bool) *GcpKmsDeleteCollectionParams {
	o.SetStateClusterState(stateClusterState)
	return o
}

// SetStateClusterState adds the stateClusterState to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetStateClusterState(stateClusterState *bool) {
	o.StateClusterState = stateClusterState
}

// WithStateCode adds the stateCode to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithStateCode(stateCode *string) *GcpKmsDeleteCollectionParams {
	o.SetStateCode(stateCode)
	return o
}

// SetStateCode adds the stateCode to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetStateCode(stateCode *string) {
	o.StateCode = stateCode
}

// WithStateMessage adds the stateMessage to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithStateMessage(stateMessage *string) *GcpKmsDeleteCollectionParams {
	o.SetStateMessage(stateMessage)
	return o
}

// SetStateMessage adds the stateMessage to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetStateMessage(stateMessage *string) {
	o.StateMessage = stateMessage
}

// WithSvmName adds the svmName to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithSvmName(svmName *string) *GcpKmsDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithSvmUUID(svmUUID *string) *GcpKmsDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithUUID(uuid *string) *GcpKmsDeleteCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithVerifyHost adds the verifyHost to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithVerifyHost(verifyHost *bool) *GcpKmsDeleteCollectionParams {
	o.SetVerifyHost(verifyHost)
	return o
}

// SetVerifyHost adds the verifyHost to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetVerifyHost(verifyHost *bool) {
	o.VerifyHost = verifyHost
}

// WithVerifyIP adds the verifyIP to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) WithVerifyIP(verifyIP *bool) *GcpKmsDeleteCollectionParams {
	o.SetVerifyIP(verifyIP)
	return o
}

// SetVerifyIP adds the verifyIp to the gcp kms delete collection params
func (o *GcpKmsDeleteCollectionParams) SetVerifyIP(verifyIP *bool) {
	o.VerifyIP = verifyIP
}

// WriteToRequest writes these params to a swagger request
func (o *GcpKmsDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AuthenticationMethod != nil {

		// query param authentication_method
		var qrAuthenticationMethod string

		if o.AuthenticationMethod != nil {
			qrAuthenticationMethod = *o.AuthenticationMethod
		}
		qAuthenticationMethod := qrAuthenticationMethod
		if qAuthenticationMethod != "" {

			if err := r.SetQueryParam("authentication_method", qAuthenticationMethod); err != nil {
				return err
			}
		}
	}

	if o.CallerAccount != nil {

		// query param caller_account
		var qrCallerAccount string

		if o.CallerAccount != nil {
			qrCallerAccount = *o.CallerAccount
		}
		qCallerAccount := qrCallerAccount
		if qCallerAccount != "" {

			if err := r.SetQueryParam("caller_account", qCallerAccount); err != nil {
				return err
			}
		}
	}

	if o.CloudkmsHost != nil {

		// query param cloudkms_host
		var qrCloudkmsHost string

		if o.CloudkmsHost != nil {
			qrCloudkmsHost = *o.CloudkmsHost
		}
		qCloudkmsHost := qrCloudkmsHost
		if qCloudkmsHost != "" {

			if err := r.SetQueryParam("cloudkms_host", qCloudkmsHost); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.EkmipReachabilityCode != nil {

		// query param ekmip_reachability.code
		var qrEkmipReachabilityCode string

		if o.EkmipReachabilityCode != nil {
			qrEkmipReachabilityCode = *o.EkmipReachabilityCode
		}
		qEkmipReachabilityCode := qrEkmipReachabilityCode
		if qEkmipReachabilityCode != "" {

			if err := r.SetQueryParam("ekmip_reachability.code", qEkmipReachabilityCode); err != nil {
				return err
			}
		}
	}

	if o.EkmipReachabilityMessage != nil {

		// query param ekmip_reachability.message
		var qrEkmipReachabilityMessage string

		if o.EkmipReachabilityMessage != nil {
			qrEkmipReachabilityMessage = *o.EkmipReachabilityMessage
		}
		qEkmipReachabilityMessage := qrEkmipReachabilityMessage
		if qEkmipReachabilityMessage != "" {

			if err := r.SetQueryParam("ekmip_reachability.message", qEkmipReachabilityMessage); err != nil {
				return err
			}
		}
	}

	if o.EkmipReachabilityNodeName != nil {

		// query param ekmip_reachability.node.name
		var qrEkmipReachabilityNodeName string

		if o.EkmipReachabilityNodeName != nil {
			qrEkmipReachabilityNodeName = *o.EkmipReachabilityNodeName
		}
		qEkmipReachabilityNodeName := qrEkmipReachabilityNodeName
		if qEkmipReachabilityNodeName != "" {

			if err := r.SetQueryParam("ekmip_reachability.node.name", qEkmipReachabilityNodeName); err != nil {
				return err
			}
		}
	}

	if o.EkmipReachabilityNodeUUID != nil {

		// query param ekmip_reachability.node.uuid
		var qrEkmipReachabilityNodeUUID string

		if o.EkmipReachabilityNodeUUID != nil {
			qrEkmipReachabilityNodeUUID = *o.EkmipReachabilityNodeUUID
		}
		qEkmipReachabilityNodeUUID := qrEkmipReachabilityNodeUUID
		if qEkmipReachabilityNodeUUID != "" {

			if err := r.SetQueryParam("ekmip_reachability.node.uuid", qEkmipReachabilityNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.EkmipReachabilityReachable != nil {

		// query param ekmip_reachability.reachable
		var qrEkmipReachabilityReachable bool

		if o.EkmipReachabilityReachable != nil {
			qrEkmipReachabilityReachable = *o.EkmipReachabilityReachable
		}
		qEkmipReachabilityReachable := swag.FormatBool(qrEkmipReachabilityReachable)
		if qEkmipReachabilityReachable != "" {

			if err := r.SetQueryParam("ekmip_reachability.reachable", qEkmipReachabilityReachable); err != nil {
				return err
			}
		}
	}

	if o.GceMetadataServer != nil {

		// query param gce_metadata_server
		var qrGceMetadataServer string

		if o.GceMetadataServer != nil {
			qrGceMetadataServer = *o.GceMetadataServer
		}
		qGceMetadataServer := qrGceMetadataServer
		if qGceMetadataServer != "" {

			if err := r.SetQueryParam("gce_metadata_server", qGceMetadataServer); err != nil {
				return err
			}
		}
	}

	if o.GoogleReachabilityCode != nil {

		// query param google_reachability.code
		var qrGoogleReachabilityCode string

		if o.GoogleReachabilityCode != nil {
			qrGoogleReachabilityCode = *o.GoogleReachabilityCode
		}
		qGoogleReachabilityCode := qrGoogleReachabilityCode
		if qGoogleReachabilityCode != "" {

			if err := r.SetQueryParam("google_reachability.code", qGoogleReachabilityCode); err != nil {
				return err
			}
		}
	}

	if o.GoogleReachabilityMessage != nil {

		// query param google_reachability.message
		var qrGoogleReachabilityMessage string

		if o.GoogleReachabilityMessage != nil {
			qrGoogleReachabilityMessage = *o.GoogleReachabilityMessage
		}
		qGoogleReachabilityMessage := qrGoogleReachabilityMessage
		if qGoogleReachabilityMessage != "" {

			if err := r.SetQueryParam("google_reachability.message", qGoogleReachabilityMessage); err != nil {
				return err
			}
		}
	}

	if o.GoogleReachabilityReachable != nil {

		// query param google_reachability.reachable
		var qrGoogleReachabilityReachable bool

		if o.GoogleReachabilityReachable != nil {
			qrGoogleReachabilityReachable = *o.GoogleReachabilityReachable
		}
		qGoogleReachabilityReachable := swag.FormatBool(qrGoogleReachabilityReachable)
		if qGoogleReachabilityReachable != "" {

			if err := r.SetQueryParam("google_reachability.reachable", qGoogleReachabilityReachable); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.KeyName != nil {

		// query param key_name
		var qrKeyName string

		if o.KeyName != nil {
			qrKeyName = *o.KeyName
		}
		qKeyName := qrKeyName
		if qKeyName != "" {

			if err := r.SetQueryParam("key_name", qKeyName); err != nil {
				return err
			}
		}
	}

	if o.KeyRingLocation != nil {

		// query param key_ring_location
		var qrKeyRingLocation string

		if o.KeyRingLocation != nil {
			qrKeyRingLocation = *o.KeyRingLocation
		}
		qKeyRingLocation := qrKeyRingLocation
		if qKeyRingLocation != "" {

			if err := r.SetQueryParam("key_ring_location", qKeyRingLocation); err != nil {
				return err
			}
		}
	}

	if o.KeyRingName != nil {

		// query param key_ring_name
		var qrKeyRingName string

		if o.KeyRingName != nil {
			qrKeyRingName = *o.KeyRingName
		}
		qKeyRingName := qrKeyRingName
		if qKeyRingName != "" {

			if err := r.SetQueryParam("key_ring_name", qKeyRingName); err != nil {
				return err
			}
		}
	}

	if o.OauthHost != nil {

		// query param oauth_host
		var qrOauthHost string

		if o.OauthHost != nil {
			qrOauthHost = *o.OauthHost
		}
		qOauthHost := qrOauthHost
		if qOauthHost != "" {

			if err := r.SetQueryParam("oauth_host", qOauthHost); err != nil {
				return err
			}
		}
	}

	if o.OauthURL != nil {

		// query param oauth_url
		var qrOauthURL string

		if o.OauthURL != nil {
			qrOauthURL = *o.OauthURL
		}
		qOauthURL := qrOauthURL
		if qOauthURL != "" {

			if err := r.SetQueryParam("oauth_url", qOauthURL); err != nil {
				return err
			}
		}
	}

	if o.Port != nil {

		// query param port
		var qrPort int64

		if o.Port != nil {
			qrPort = *o.Port
		}
		qPort := swag.FormatInt64(qrPort)
		if qPort != "" {

			if err := r.SetQueryParam("port", qPort); err != nil {
				return err
			}
		}
	}

	if o.PrivilegedAccount != nil {

		// query param privileged_account
		var qrPrivilegedAccount string

		if o.PrivilegedAccount != nil {
			qrPrivilegedAccount = *o.PrivilegedAccount
		}
		qPrivilegedAccount := qrPrivilegedAccount
		if qPrivilegedAccount != "" {

			if err := r.SetQueryParam("privileged_account", qPrivilegedAccount); err != nil {
				return err
			}
		}
	}

	if o.ProjectID != nil {

		// query param project_id
		var qrProjectID string

		if o.ProjectID != nil {
			qrProjectID = *o.ProjectID
		}
		qProjectID := qrProjectID
		if qProjectID != "" {

			if err := r.SetQueryParam("project_id", qProjectID); err != nil {
				return err
			}
		}
	}

	if o.ProxyHost != nil {

		// query param proxy_host
		var qrProxyHost string

		if o.ProxyHost != nil {
			qrProxyHost = *o.ProxyHost
		}
		qProxyHost := qrProxyHost
		if qProxyHost != "" {

			if err := r.SetQueryParam("proxy_host", qProxyHost); err != nil {
				return err
			}
		}
	}

	if o.ProxyPort != nil {

		// query param proxy_port
		var qrProxyPort int64

		if o.ProxyPort != nil {
			qrProxyPort = *o.ProxyPort
		}
		qProxyPort := swag.FormatInt64(qrProxyPort)
		if qProxyPort != "" {

			if err := r.SetQueryParam("proxy_port", qProxyPort); err != nil {
				return err
			}
		}
	}

	if o.ProxyType != nil {

		// query param proxy_type
		var qrProxyType string

		if o.ProxyType != nil {
			qrProxyType = *o.ProxyType
		}
		qProxyType := qrProxyType
		if qProxyType != "" {

			if err := r.SetQueryParam("proxy_type", qProxyType); err != nil {
				return err
			}
		}
	}

	if o.ProxyUsername != nil {

		// query param proxy_username
		var qrProxyUsername string

		if o.ProxyUsername != nil {
			qrProxyUsername = *o.ProxyUsername
		}
		qProxyUsername := qrProxyUsername
		if qProxyUsername != "" {

			if err := r.SetQueryParam("proxy_username", qProxyUsername); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.StateClusterState != nil {

		// query param state.cluster_state
		var qrStateClusterState bool

		if o.StateClusterState != nil {
			qrStateClusterState = *o.StateClusterState
		}
		qStateClusterState := swag.FormatBool(qrStateClusterState)
		if qStateClusterState != "" {

			if err := r.SetQueryParam("state.cluster_state", qStateClusterState); err != nil {
				return err
			}
		}
	}

	if o.StateCode != nil {

		// query param state.code
		var qrStateCode string

		if o.StateCode != nil {
			qrStateCode = *o.StateCode
		}
		qStateCode := qrStateCode
		if qStateCode != "" {

			if err := r.SetQueryParam("state.code", qStateCode); err != nil {
				return err
			}
		}
	}

	if o.StateMessage != nil {

		// query param state.message
		var qrStateMessage string

		if o.StateMessage != nil {
			qrStateMessage = *o.StateMessage
		}
		qStateMessage := qrStateMessage
		if qStateMessage != "" {

			if err := r.SetQueryParam("state.message", qStateMessage); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.VerifyHost != nil {

		// query param verify_host
		var qrVerifyHost bool

		if o.VerifyHost != nil {
			qrVerifyHost = *o.VerifyHost
		}
		qVerifyHost := swag.FormatBool(qrVerifyHost)
		if qVerifyHost != "" {

			if err := r.SetQueryParam("verify_host", qVerifyHost); err != nil {
				return err
			}
		}
	}

	if o.VerifyIP != nil {

		// query param verify_ip
		var qrVerifyIP bool

		if o.VerifyIP != nil {
			qrVerifyIP = *o.VerifyIP
		}
		qVerifyIP := swag.FormatBool(qrVerifyIP)
		if qVerifyIP != "" {

			if err := r.SetQueryParam("verify_ip", qVerifyIP); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
