// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGcpKmsGetParams creates a new GcpKmsGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGcpKmsGetParams() *GcpKmsGetParams {
	return &GcpKmsGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGcpKmsGetParamsWithTimeout creates a new GcpKmsGetParams object
// with the ability to set a timeout on a request.
func NewGcpKmsGetParamsWithTimeout(timeout time.Duration) *GcpKmsGetParams {
	return &GcpKmsGetParams{
		timeout: timeout,
	}
}

// NewGcpKmsGetParamsWithContext creates a new GcpKmsGetParams object
// with the ability to set a context for a request.
func NewGcpKmsGetParamsWithContext(ctx context.Context) *GcpKmsGetParams {
	return &GcpKmsGetParams{
		Context: ctx,
	}
}

// NewGcpKmsGetParamsWithHTTPClient creates a new GcpKmsGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewGcpKmsGetParamsWithHTTPClient(client *http.Client) *GcpKmsGetParams {
	return &GcpKmsGetParams{
		HTTPClient: client,
	}
}

/*
GcpKmsGetParams contains all the parameters to send to the API endpoint

	for the gcp kms get operation.

	Typically these are written to a http.Request.
*/
type GcpKmsGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* UUID.

	   Google Cloud KMS UUID
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the gcp kms get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GcpKmsGetParams) WithDefaults() *GcpKmsGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the gcp kms get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GcpKmsGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the gcp kms get params
func (o *GcpKmsGetParams) WithTimeout(timeout time.Duration) *GcpKmsGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the gcp kms get params
func (o *GcpKmsGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the gcp kms get params
func (o *GcpKmsGetParams) WithContext(ctx context.Context) *GcpKmsGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the gcp kms get params
func (o *GcpKmsGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the gcp kms get params
func (o *GcpKmsGetParams) WithHTTPClient(client *http.Client) *GcpKmsGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the gcp kms get params
func (o *GcpKmsGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the gcp kms get params
func (o *GcpKmsGetParams) WithFields(fields []string) *GcpKmsGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the gcp kms get params
func (o *GcpKmsGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithUUID adds the uuid to the gcp kms get params
func (o *GcpKmsGetParams) WithUUID(uuid string) *GcpKmsGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the gcp kms get params
func (o *GcpKmsGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *GcpKmsGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGcpKmsGet binds the parameter fields
func (o *GcpKmsGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
