// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// GcpKmsModifyCollectionReader is a Reader for the GcpKmsModifyCollection structure.
type GcpKmsModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GcpKmsModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGcpKmsModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewGcpKmsModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGcpKmsModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGcpKmsModifyCollectionOK creates a GcpKmsModifyCollectionOK with default headers values
func NewGcpKmsModifyCollectionOK() *GcpKmsModifyCollectionOK {
	return &GcpKmsModifyCollectionOK{}
}

/*
GcpKmsModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type GcpKmsModifyCollectionOK struct {
}

// IsSuccess returns true when this gcp kms modify collection o k response has a 2xx status code
func (o *GcpKmsModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this gcp kms modify collection o k response has a 3xx status code
func (o *GcpKmsModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this gcp kms modify collection o k response has a 4xx status code
func (o *GcpKmsModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this gcp kms modify collection o k response has a 5xx status code
func (o *GcpKmsModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this gcp kms modify collection o k response a status code equal to that given
func (o *GcpKmsModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the gcp kms modify collection o k response
func (o *GcpKmsModifyCollectionOK) Code() int {
	return 200
}

func (o *GcpKmsModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /security/gcp-kms][%d] gcpKmsModifyCollectionOK", 200)
}

func (o *GcpKmsModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /security/gcp-kms][%d] gcpKmsModifyCollectionOK", 200)
}

func (o *GcpKmsModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGcpKmsModifyCollectionAccepted creates a GcpKmsModifyCollectionAccepted with default headers values
func NewGcpKmsModifyCollectionAccepted() *GcpKmsModifyCollectionAccepted {
	return &GcpKmsModifyCollectionAccepted{}
}

/*
GcpKmsModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type GcpKmsModifyCollectionAccepted struct {
	Payload *models.GcpKmsJobLinkResponse
}

// IsSuccess returns true when this gcp kms modify collection accepted response has a 2xx status code
func (o *GcpKmsModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this gcp kms modify collection accepted response has a 3xx status code
func (o *GcpKmsModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this gcp kms modify collection accepted response has a 4xx status code
func (o *GcpKmsModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this gcp kms modify collection accepted response has a 5xx status code
func (o *GcpKmsModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this gcp kms modify collection accepted response a status code equal to that given
func (o *GcpKmsModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the gcp kms modify collection accepted response
func (o *GcpKmsModifyCollectionAccepted) Code() int {
	return 202
}

func (o *GcpKmsModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/gcp-kms][%d] gcpKmsModifyCollectionAccepted %s", 202, payload)
}

func (o *GcpKmsModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/gcp-kms][%d] gcpKmsModifyCollectionAccepted %s", 202, payload)
}

func (o *GcpKmsModifyCollectionAccepted) GetPayload() *models.GcpKmsJobLinkResponse {
	return o.Payload
}

func (o *GcpKmsModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GcpKmsJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGcpKmsModifyCollectionDefault creates a GcpKmsModifyCollectionDefault with default headers values
func NewGcpKmsModifyCollectionDefault(code int) *GcpKmsModifyCollectionDefault {
	return &GcpKmsModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	GcpKmsModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 65537541 | No inputs were provided for the patch request. |
| 65537547 | One or more volume encryption keys for encrypted volumes of this data SVM are stored in the key manager configured for the admin SVM. Use the REST API POST method to migrate this data SVM's keys from the admin SVM's key manager to this data SVM's key manager before running the rekey operation. |
| 65537605 | Failed to establish connectivity with the cloud key management service. |
| 65537713 | Internal Error. Failed to store the application credentials. |
| 65537714 | The \"application_credentials\" field must be specified. |
| 65537721 | The Google Cloud Key Management Service is not configured for the SVM. |
| 65537724 | Failed to update the Google Cloud Key Management Service because invalid application credentials were provided. |
| 65537757 | The \"key_name\", \"project_id\", \"key_ring_name\" and \"key_ring_location\" fields cannot be modified directly. Use the REST API POST method \"/api/security/gcp-kms/{uuid}/rekey-external\" to modify these fields. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type GcpKmsModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this gcp kms modify collection default response has a 2xx status code
func (o *GcpKmsModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this gcp kms modify collection default response has a 3xx status code
func (o *GcpKmsModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this gcp kms modify collection default response has a 4xx status code
func (o *GcpKmsModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this gcp kms modify collection default response has a 5xx status code
func (o *GcpKmsModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this gcp kms modify collection default response a status code equal to that given
func (o *GcpKmsModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the gcp kms modify collection default response
func (o *GcpKmsModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *GcpKmsModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/gcp-kms][%d] gcp_kms_modify_collection default %s", o._statusCode, payload)
}

func (o *GcpKmsModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/gcp-kms][%d] gcp_kms_modify_collection default %s", o._statusCode, payload)
}

func (o *GcpKmsModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GcpKmsModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
GcpKmsModifyCollectionBody gcp kms modify collection body
swagger:model GcpKmsModifyCollectionBody
*/
type GcpKmsModifyCollectionBody struct {

	// links
	Links *models.GcpKmsInlineLinks `json:"_links,omitempty"`

	// The Google Cloud application's service account credentials required to access the specified KMS. The client_email and private_key fields of the service account holder are required. The credentials are required if the `authentication_method` is set to `application_credentials_key`.
	// Example: {\"private_key\":\"ValidPrivateKey\",\"client_email\":\"my@account.email.com\"}
	// Format: password
	ApplicationCredentials *strfmt.Password `json:"application_credentials,omitempty"`

	// Google Cloud KMS authentication method.
	// Example: application_credentials_key
	// Enum: ["application_credentials_key","sa_credentials_attachment"]
	AuthenticationMethod *string `json:"authentication_method,omitempty"`

	// Google Cloud KMS caller account email
	// Example: myaccount@myproject.com
	// Read Only: true
	CallerAccount *string `json:"caller_account,omitempty"`

	// Google Cloud KMS host subdomain.
	// Example: cloudkms.googleapis.com
	CloudkmsHost *string `json:"cloudkms_host,omitempty"`

	// A custom metadata server URL used for retrieving short lived authentication tokens if the default service account is not used. This is only applicable when the `authentication_method` is set to `sa_credentials_attachment`.
	// Example: http://169.254.169.254/computeMetadata/v1/instance/service-accounts/default/token
	// Format: uri
	GceMetadataServer *strfmt.URI `json:"gce_metadata_server,omitempty"`

	// gcp kms inline ekmip reachability
	// Read Only: true
	GcpKmsInlineEkmipReachability []*models.GcpKmsInlineEkmipReachabilityInlineArrayItem `json:"ekmip_reachability,omitempty"`

	// gcp kms response inline records
	GcpKmsResponseInlineRecords []*models.GcpKms `json:"records,omitempty"`

	// google reachability
	GoogleReachability *models.GcpKmsInlineGoogleReachability `json:"google_reachability,omitempty"`

	// Key Identifier of Google Cloud KMS key encryption key.
	// Example: cryptokey1
	KeyName *string `json:"key_name,omitempty"`

	// Google Cloud KMS key ring location.
	// Example: global
	KeyRingLocation *string `json:"key_ring_location,omitempty"`

	// Google Cloud KMS key ring name of the deployed Google Cloud application.
	// Example: gcpapp1-keyring
	KeyRingName *string `json:"key_ring_name,omitempty"`

	// Open authorization server host name.
	// Example: oauth2.googleapis.com
	OauthHost *string `json:"oauth_host,omitempty"`

	// Open authorization URL for the access token.
	// Example: https://oauth2.googleapis.com/token
	OauthURL *string `json:"oauth_url,omitempty"`

	// Authorization server and Google Cloud KMS port number.
	// Example: 443
	Port *int64 `json:"port,omitempty"`

	// Google Cloud KMS account to impersonate.
	// Example: myserviceaccount@myproject.iam.gserviceaccount.com
	PrivilegedAccount *string `json:"privileged_account,omitempty"`

	// Google Cloud project (application) ID of the deployed Google Cloud application that has appropriate access to the Google Cloud KMS.
	// Example: gcpapp1
	ProjectID *string `json:"project_id,omitempty"`

	// Proxy host name.
	// Example: proxy.eng.com
	ProxyHost *string `json:"proxy_host,omitempty"`

	// Proxy password. Password is not audited.
	// Example: proxypassword
	ProxyPassword *string `json:"proxy_password,omitempty"`

	// Proxy port number.
	// Example: 1234
	ProxyPort *int64 `json:"proxy_port,omitempty"`

	// Type of proxy.
	// Example: http
	// Enum: ["http","https"]
	ProxyType *string `json:"proxy_type,omitempty"`

	// Proxy username.
	// Example: proxyuser
	ProxyUsername *string `json:"proxy_username,omitempty"`

	// Set to "svm" for interfaces owned by an SVM. Otherwise, set to "cluster".
	// Read Only: true
	// Enum: ["svm","cluster"]
	Scope *string `json:"scope,omitempty"`

	// state
	State *models.GcpKmsInlineState `json:"state,omitempty"`

	// svm
	Svm *models.GcpKmsInlineSvm `json:"svm,omitempty"`

	// A unique identifier for the Google Cloud KMS.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// Verify the identity of the Google Cloud KMS host name.
	VerifyHost *bool `json:"verify_host,omitempty"`

	// Verify the identity of the Google Cloud KMS IP address.
	VerifyIP *bool `json:"verify_ip,omitempty"`
}

// Validate validates this gcp kms modify collection body
func (o *GcpKmsModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateApplicationCredentials(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAuthenticationMethod(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateGceMetadataServer(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateGcpKmsInlineEkmipReachability(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateGcpKmsResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateGoogleReachability(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProxyType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GcpKmsModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *GcpKmsModifyCollectionBody) validateApplicationCredentials(formats strfmt.Registry) error {
	if swag.IsZero(o.ApplicationCredentials) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"application_credentials", "body", "password", o.ApplicationCredentials.String(), formats); err != nil {
		return err
	}

	return nil
}

var gcpKmsModifyCollectionBodyTypeAuthenticationMethodPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["application_credentials_key","sa_credentials_attachment"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		gcpKmsModifyCollectionBodyTypeAuthenticationMethodPropEnum = append(gcpKmsModifyCollectionBodyTypeAuthenticationMethodPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// GcpKmsModifyCollectionBody
	// GcpKmsModifyCollectionBody
	// authentication_method
	// AuthenticationMethod
	// application_credentials_key
	// END DEBUGGING
	// GcpKmsModifyCollectionBodyAuthenticationMethodApplicationCredentialsKey captures enum value "application_credentials_key"
	GcpKmsModifyCollectionBodyAuthenticationMethodApplicationCredentialsKey string = "application_credentials_key"

	// BEGIN DEBUGGING
	// GcpKmsModifyCollectionBody
	// GcpKmsModifyCollectionBody
	// authentication_method
	// AuthenticationMethod
	// sa_credentials_attachment
	// END DEBUGGING
	// GcpKmsModifyCollectionBodyAuthenticationMethodSaCredentialsAttachment captures enum value "sa_credentials_attachment"
	GcpKmsModifyCollectionBodyAuthenticationMethodSaCredentialsAttachment string = "sa_credentials_attachment"
)

// prop value enum
func (o *GcpKmsModifyCollectionBody) validateAuthenticationMethodEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, gcpKmsModifyCollectionBodyTypeAuthenticationMethodPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *GcpKmsModifyCollectionBody) validateAuthenticationMethod(formats strfmt.Registry) error {
	if swag.IsZero(o.AuthenticationMethod) { // not required
		return nil
	}

	// value enum
	if err := o.validateAuthenticationMethodEnum("info"+"."+"authentication_method", "body", *o.AuthenticationMethod); err != nil {
		return err
	}

	return nil
}

func (o *GcpKmsModifyCollectionBody) validateGceMetadataServer(formats strfmt.Registry) error {
	if swag.IsZero(o.GceMetadataServer) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"gce_metadata_server", "body", "uri", o.GceMetadataServer.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *GcpKmsModifyCollectionBody) validateGcpKmsInlineEkmipReachability(formats strfmt.Registry) error {
	if swag.IsZero(o.GcpKmsInlineEkmipReachability) { // not required
		return nil
	}

	for i := 0; i < len(o.GcpKmsInlineEkmipReachability); i++ {
		if swag.IsZero(o.GcpKmsInlineEkmipReachability[i]) { // not required
			continue
		}

		if o.GcpKmsInlineEkmipReachability[i] != nil {
			if err := o.GcpKmsInlineEkmipReachability[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "ekmip_reachability" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *GcpKmsModifyCollectionBody) validateGcpKmsResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.GcpKmsResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.GcpKmsResponseInlineRecords); i++ {
		if swag.IsZero(o.GcpKmsResponseInlineRecords[i]) { // not required
			continue
		}

		if o.GcpKmsResponseInlineRecords[i] != nil {
			if err := o.GcpKmsResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *GcpKmsModifyCollectionBody) validateGoogleReachability(formats strfmt.Registry) error {
	if swag.IsZero(o.GoogleReachability) { // not required
		return nil
	}

	if o.GoogleReachability != nil {
		if err := o.GoogleReachability.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "google_reachability")
			}
			return err
		}
	}

	return nil
}

var gcpKmsModifyCollectionBodyTypeProxyTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["http","https"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		gcpKmsModifyCollectionBodyTypeProxyTypePropEnum = append(gcpKmsModifyCollectionBodyTypeProxyTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// GcpKmsModifyCollectionBody
	// GcpKmsModifyCollectionBody
	// proxy_type
	// ProxyType
	// http
	// END DEBUGGING
	// GcpKmsModifyCollectionBodyProxyTypeHTTP captures enum value "http"
	GcpKmsModifyCollectionBodyProxyTypeHTTP string = "http"

	// BEGIN DEBUGGING
	// GcpKmsModifyCollectionBody
	// GcpKmsModifyCollectionBody
	// proxy_type
	// ProxyType
	// https
	// END DEBUGGING
	// GcpKmsModifyCollectionBodyProxyTypeHTTPS captures enum value "https"
	GcpKmsModifyCollectionBodyProxyTypeHTTPS string = "https"
)

// prop value enum
func (o *GcpKmsModifyCollectionBody) validateProxyTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, gcpKmsModifyCollectionBodyTypeProxyTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *GcpKmsModifyCollectionBody) validateProxyType(formats strfmt.Registry) error {
	if swag.IsZero(o.ProxyType) { // not required
		return nil
	}

	// value enum
	if err := o.validateProxyTypeEnum("info"+"."+"proxy_type", "body", *o.ProxyType); err != nil {
		return err
	}

	return nil
}

var gcpKmsModifyCollectionBodyTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["svm","cluster"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		gcpKmsModifyCollectionBodyTypeScopePropEnum = append(gcpKmsModifyCollectionBodyTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// GcpKmsModifyCollectionBody
	// GcpKmsModifyCollectionBody
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// GcpKmsModifyCollectionBodyScopeSvm captures enum value "svm"
	GcpKmsModifyCollectionBodyScopeSvm string = "svm"

	// BEGIN DEBUGGING
	// GcpKmsModifyCollectionBody
	// GcpKmsModifyCollectionBody
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// GcpKmsModifyCollectionBodyScopeCluster captures enum value "cluster"
	GcpKmsModifyCollectionBodyScopeCluster string = "cluster"
)

// prop value enum
func (o *GcpKmsModifyCollectionBody) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, gcpKmsModifyCollectionBodyTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *GcpKmsModifyCollectionBody) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(o.Scope) { // not required
		return nil
	}

	// value enum
	if err := o.validateScopeEnum("info"+"."+"scope", "body", *o.Scope); err != nil {
		return err
	}

	return nil
}

func (o *GcpKmsModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	if o.State != nil {
		if err := o.State.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "state")
			}
			return err
		}
	}

	return nil
}

func (o *GcpKmsModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this gcp kms modify collection body based on the context it is used
func (o *GcpKmsModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCallerAccount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateGcpKmsInlineEkmipReachability(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateGcpKmsResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateGoogleReachability(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GcpKmsModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *GcpKmsModifyCollectionBody) contextValidateCallerAccount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"caller_account", "body", o.CallerAccount); err != nil {
		return err
	}

	return nil
}

func (o *GcpKmsModifyCollectionBody) contextValidateGcpKmsInlineEkmipReachability(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"ekmip_reachability", "body", []*models.GcpKmsInlineEkmipReachabilityInlineArrayItem(o.GcpKmsInlineEkmipReachability)); err != nil {
		return err
	}

	for i := 0; i < len(o.GcpKmsInlineEkmipReachability); i++ {

		if o.GcpKmsInlineEkmipReachability[i] != nil {
			if err := o.GcpKmsInlineEkmipReachability[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "ekmip_reachability" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *GcpKmsModifyCollectionBody) contextValidateGcpKmsResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.GcpKmsResponseInlineRecords); i++ {

		if o.GcpKmsResponseInlineRecords[i] != nil {
			if err := o.GcpKmsResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *GcpKmsModifyCollectionBody) contextValidateGoogleReachability(ctx context.Context, formats strfmt.Registry) error {

	if o.GoogleReachability != nil {
		if err := o.GoogleReachability.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "google_reachability")
			}
			return err
		}
	}

	return nil
}

func (o *GcpKmsModifyCollectionBody) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"scope", "body", o.Scope); err != nil {
		return err
	}

	return nil
}

func (o *GcpKmsModifyCollectionBody) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if o.State != nil {
		if err := o.State.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "state")
			}
			return err
		}
	}

	return nil
}

func (o *GcpKmsModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *GcpKmsModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *GcpKmsModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GcpKmsModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res GcpKmsModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
GcpKmsInlineLinks gcp kms inline links
swagger:model gcp_kms_inline__links
*/
type GcpKmsInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this gcp kms inline links
func (o *GcpKmsInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GcpKmsInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this gcp kms inline links based on the context it is used
func (o *GcpKmsInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GcpKmsInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *GcpKmsInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GcpKmsInlineLinks) UnmarshalBinary(b []byte) error {
	var res GcpKmsInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
GcpKmsInlineEkmipReachabilityInlineArrayItem Provides the connectivity status for the given SVM on the given node to all EKMIP servers configured on all nodes of the cluster.
// This is an advanced property; there is an added computational cost to retrieving its value. The property is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter or GET for all advanced properties is enabled.
//
swagger:model gcp_kms_inline_ekmip_reachability_inline_array_item
*/
type GcpKmsInlineEkmipReachabilityInlineArrayItem struct {

	// Code corresponding to the error message. Returns a 0 if a given SVM is able to communicate to the EKMIP servers of all of the nodes in the cluster.
	// Example: 346758
	Code *string `json:"code,omitempty"`

	// Error message set when cluster-wide EKMIP server availability from the given SVM and node is false.
	// Example: embedded KMIP server status unavailable on node.
	Message *string `json:"message,omitempty"`

	// node
	Node *models.GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNode `json:"node,omitempty"`

	// Set to true if the given SVM on the given node is able to communicate to all EKMIP servers configured on all nodes in the cluster.
	Reachable *bool `json:"reachable,omitempty"`
}

// Validate validates this gcp kms inline ekmip reachability inline array item
func (o *GcpKmsInlineEkmipReachabilityInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GcpKmsInlineEkmipReachabilityInlineArrayItem) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this gcp kms inline ekmip reachability inline array item based on the context it is used
func (o *GcpKmsInlineEkmipReachabilityInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GcpKmsInlineEkmipReachabilityInlineArrayItem) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *GcpKmsInlineEkmipReachabilityInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GcpKmsInlineEkmipReachabilityInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res GcpKmsInlineEkmipReachabilityInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNode gcp kms inline ekmip reachability inline array item inline node
swagger:model gcp_kms_inline_ekmip_reachability_inline_array_item_inline_node
*/
type GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNode struct {

	// links
	Links *models.GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this gcp kms inline ekmip reachability inline array item inline node
func (o *GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this gcp kms inline ekmip reachability inline array item inline node based on the context it is used
func (o *GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNode) UnmarshalBinary(b []byte) error {
	var res GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks gcp kms inline ekmip reachability inline array item inline node inline links
swagger:model gcp_kms_inline_ekmip_reachability_inline_array_item_inline_node_inline__links
*/
type GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this gcp kms inline ekmip reachability inline array item inline node inline links
func (o *GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this gcp kms inline ekmip reachability inline array item inline node inline links based on the context it is used
func (o *GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res GcpKmsInlineEkmipReachabilityInlineArrayItemInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
GcpKmsInlineGoogleReachability Indicates whether or not the Google Cloud KMS is reachable from all nodes in the cluster.
// This is an advanced property; there is an added computational cost to retrieving its value. The property is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter or GET for all advanced properties is enabled.
//
swagger:model gcp_kms_inline_google_reachability
*/
type GcpKmsInlineGoogleReachability struct {

	// Code corresponding to the error message. Returns a 0 if Google Cloud KMS is reachable from all nodes in the cluster.
	// Example: 346758
	Code *string `json:"code,omitempty"`

	// Set to the error message when 'reachable' is false.
	// Example: Google Cloud KMS is not reachable from all nodes - \u003creason\u003e.
	Message *string `json:"message,omitempty"`

	// Set to true if the Google Cloud KMS is reachable from all nodes of the cluster.
	Reachable *bool `json:"reachable,omitempty"`
}

// Validate validates this gcp kms inline google reachability
func (o *GcpKmsInlineGoogleReachability) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this gcp kms inline google reachability based on the context it is used
func (o *GcpKmsInlineGoogleReachability) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *GcpKmsInlineGoogleReachability) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GcpKmsInlineGoogleReachability) UnmarshalBinary(b []byte) error {
	var res GcpKmsInlineGoogleReachability
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
GcpKmsInlineState Google Cloud Key Management Services is a cloud key management service (KMS) that provides a secure store for encryption keys. This object indicates whether or not the Google Cloud KMS key protection is available on all nodes in the cluster.
// This is an advanced property; there is an added computational cost to retrieving its value. The property is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter or GET for all advanced properties is enabled.
//
swagger:model gcp_kms_inline_state
*/
type GcpKmsInlineState struct {

	// Set to true when Google Cloud KMS key protection is available on all nodes of the cluster.
	ClusterState *bool `json:"cluster_state,omitempty"`

	// Error code corresponding to the status message. Returns 0 if Google Cloud KMS key protection is available in all nodes of the cluster.
	// Example: 346758
	Code *string `json:"code,omitempty"`

	// Error message set when top-level internal key protection key (KEK) availability on cluster is false.
	// Example: Top-level internal key protection key (KEK) is unavailable on the following nodes with the associated reasons: Node: node1. Reason: No volumes created yet for the SVM. Wrapped KEK status will be available after creating encrypted volumes.
	Message *string `json:"message,omitempty"`
}

// Validate validates this gcp kms inline state
func (o *GcpKmsInlineState) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this gcp kms inline state based on the context it is used
func (o *GcpKmsInlineState) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *GcpKmsInlineState) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GcpKmsInlineState) UnmarshalBinary(b []byte) error {
	var res GcpKmsInlineState
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
GcpKmsInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model gcp_kms_inline_svm
*/
type GcpKmsInlineSvm struct {

	// links
	Links *models.GcpKmsInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this gcp kms inline svm
func (o *GcpKmsInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GcpKmsInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this gcp kms inline svm based on the context it is used
func (o *GcpKmsInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GcpKmsInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *GcpKmsInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GcpKmsInlineSvm) UnmarshalBinary(b []byte) error {
	var res GcpKmsInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
GcpKmsInlineSvmInlineLinks gcp kms inline svm inline links
swagger:model gcp_kms_inline_svm_inline__links
*/
type GcpKmsInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this gcp kms inline svm inline links
func (o *GcpKmsInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GcpKmsInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this gcp kms inline svm inline links based on the context it is used
func (o *GcpKmsInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GcpKmsInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *GcpKmsInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GcpKmsInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res GcpKmsInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
