// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// GcpKmsModifyReader is a Reader for the GcpKmsModify structure.
type GcpKmsModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GcpKmsModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGcpKmsModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewGcpKmsModifyAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGcpKmsModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGcpKmsModifyOK creates a GcpKmsModifyOK with default headers values
func NewGcpKmsModifyOK() *GcpKmsModifyOK {
	return &GcpKmsModifyOK{}
}

/*
GcpKmsModifyOK describes a response with status code 200, with default header values.

OK
*/
type GcpKmsModifyOK struct {
}

// IsSuccess returns true when this gcp kms modify o k response has a 2xx status code
func (o *GcpKmsModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this gcp kms modify o k response has a 3xx status code
func (o *GcpKmsModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this gcp kms modify o k response has a 4xx status code
func (o *GcpKmsModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this gcp kms modify o k response has a 5xx status code
func (o *GcpKmsModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this gcp kms modify o k response a status code equal to that given
func (o *GcpKmsModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the gcp kms modify o k response
func (o *GcpKmsModifyOK) Code() int {
	return 200
}

func (o *GcpKmsModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /security/gcp-kms/{uuid}][%d] gcpKmsModifyOK", 200)
}

func (o *GcpKmsModifyOK) String() string {
	return fmt.Sprintf("[PATCH /security/gcp-kms/{uuid}][%d] gcpKmsModifyOK", 200)
}

func (o *GcpKmsModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGcpKmsModifyAccepted creates a GcpKmsModifyAccepted with default headers values
func NewGcpKmsModifyAccepted() *GcpKmsModifyAccepted {
	return &GcpKmsModifyAccepted{}
}

/*
GcpKmsModifyAccepted describes a response with status code 202, with default header values.

Accepted
*/
type GcpKmsModifyAccepted struct {
	Payload *models.GcpKmsJobLinkResponse
}

// IsSuccess returns true when this gcp kms modify accepted response has a 2xx status code
func (o *GcpKmsModifyAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this gcp kms modify accepted response has a 3xx status code
func (o *GcpKmsModifyAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this gcp kms modify accepted response has a 4xx status code
func (o *GcpKmsModifyAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this gcp kms modify accepted response has a 5xx status code
func (o *GcpKmsModifyAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this gcp kms modify accepted response a status code equal to that given
func (o *GcpKmsModifyAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the gcp kms modify accepted response
func (o *GcpKmsModifyAccepted) Code() int {
	return 202
}

func (o *GcpKmsModifyAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/gcp-kms/{uuid}][%d] gcpKmsModifyAccepted %s", 202, payload)
}

func (o *GcpKmsModifyAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/gcp-kms/{uuid}][%d] gcpKmsModifyAccepted %s", 202, payload)
}

func (o *GcpKmsModifyAccepted) GetPayload() *models.GcpKmsJobLinkResponse {
	return o.Payload
}

func (o *GcpKmsModifyAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GcpKmsJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGcpKmsModifyDefault creates a GcpKmsModifyDefault with default headers values
func NewGcpKmsModifyDefault(code int) *GcpKmsModifyDefault {
	return &GcpKmsModifyDefault{
		_statusCode: code,
	}
}

/*
	GcpKmsModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 65537541 | No inputs were provided for the patch request. |
| 65537547 | One or more volume encryption keys for encrypted volumes of this data SVM are stored in the key manager configured for the admin SVM. Use the REST API POST method to migrate this data SVM's keys from the admin SVM's key manager to this data SVM's key manager before running the rekey operation. |
| 65537605 | Failed to establish connectivity with the cloud key management service. |
| 65537713 | Internal Error. Failed to store the application credentials. |
| 65537714 | The \"application_credentials\" field must be specified. |
| 65537721 | The Google Cloud Key Management Service is not configured for the SVM. |
| 65537724 | Failed to update the Google Cloud Key Management Service because invalid application credentials were provided. |
| 65537757 | The \"key_name\", \"project_id\", \"key_ring_name\" and \"key_ring_location\" fields cannot be modified directly. Use the REST API POST method \"/api/security/gcp-kms/{uuid}/rekey-external\" to modify these fields. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type GcpKmsModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this gcp kms modify default response has a 2xx status code
func (o *GcpKmsModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this gcp kms modify default response has a 3xx status code
func (o *GcpKmsModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this gcp kms modify default response has a 4xx status code
func (o *GcpKmsModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this gcp kms modify default response has a 5xx status code
func (o *GcpKmsModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this gcp kms modify default response a status code equal to that given
func (o *GcpKmsModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the gcp kms modify default response
func (o *GcpKmsModifyDefault) Code() int {
	return o._statusCode
}

func (o *GcpKmsModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/gcp-kms/{uuid}][%d] gcp_kms_modify default %s", o._statusCode, payload)
}

func (o *GcpKmsModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/gcp-kms/{uuid}][%d] gcp_kms_modify default %s", o._statusCode, payload)
}

func (o *GcpKmsModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GcpKmsModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
