// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGroupRoleMappingsCollectionGetParams creates a new GroupRoleMappingsCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGroupRoleMappingsCollectionGetParams() *GroupRoleMappingsCollectionGetParams {
	return &GroupRoleMappingsCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGroupRoleMappingsCollectionGetParamsWithTimeout creates a new GroupRoleMappingsCollectionGetParams object
// with the ability to set a timeout on a request.
func NewGroupRoleMappingsCollectionGetParamsWithTimeout(timeout time.Duration) *GroupRoleMappingsCollectionGetParams {
	return &GroupRoleMappingsCollectionGetParams{
		timeout: timeout,
	}
}

// NewGroupRoleMappingsCollectionGetParamsWithContext creates a new GroupRoleMappingsCollectionGetParams object
// with the ability to set a context for a request.
func NewGroupRoleMappingsCollectionGetParamsWithContext(ctx context.Context) *GroupRoleMappingsCollectionGetParams {
	return &GroupRoleMappingsCollectionGetParams{
		Context: ctx,
	}
}

// NewGroupRoleMappingsCollectionGetParamsWithHTTPClient creates a new GroupRoleMappingsCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewGroupRoleMappingsCollectionGetParamsWithHTTPClient(client *http.Client) *GroupRoleMappingsCollectionGetParams {
	return &GroupRoleMappingsCollectionGetParams{
		HTTPClient: client,
	}
}

/*
GroupRoleMappingsCollectionGetParams contains all the parameters to send to the API endpoint

	for the group role mappings collection get operation.

	Typically these are written to a http.Request.
*/
type GroupRoleMappingsCollectionGetParams struct {

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* GroupID.

	   Filter by group_id
	*/
	GroupID *int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OntapRoleName.

	   Filter by ontap_role.name
	*/
	OntapRoleName *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the group role mappings collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GroupRoleMappingsCollectionGetParams) WithDefaults() *GroupRoleMappingsCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the group role mappings collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GroupRoleMappingsCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := GroupRoleMappingsCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the group role mappings collection get params
func (o *GroupRoleMappingsCollectionGetParams) WithTimeout(timeout time.Duration) *GroupRoleMappingsCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the group role mappings collection get params
func (o *GroupRoleMappingsCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the group role mappings collection get params
func (o *GroupRoleMappingsCollectionGetParams) WithContext(ctx context.Context) *GroupRoleMappingsCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the group role mappings collection get params
func (o *GroupRoleMappingsCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the group role mappings collection get params
func (o *GroupRoleMappingsCollectionGetParams) WithHTTPClient(client *http.Client) *GroupRoleMappingsCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the group role mappings collection get params
func (o *GroupRoleMappingsCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithComment adds the comment to the group role mappings collection get params
func (o *GroupRoleMappingsCollectionGetParams) WithComment(comment *string) *GroupRoleMappingsCollectionGetParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the group role mappings collection get params
func (o *GroupRoleMappingsCollectionGetParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithFields adds the fields to the group role mappings collection get params
func (o *GroupRoleMappingsCollectionGetParams) WithFields(fields []string) *GroupRoleMappingsCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the group role mappings collection get params
func (o *GroupRoleMappingsCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithGroupID adds the groupID to the group role mappings collection get params
func (o *GroupRoleMappingsCollectionGetParams) WithGroupID(groupID *int64) *GroupRoleMappingsCollectionGetParams {
	o.SetGroupID(groupID)
	return o
}

// SetGroupID adds the groupId to the group role mappings collection get params
func (o *GroupRoleMappingsCollectionGetParams) SetGroupID(groupID *int64) {
	o.GroupID = groupID
}

// WithMaxRecords adds the maxRecords to the group role mappings collection get params
func (o *GroupRoleMappingsCollectionGetParams) WithMaxRecords(maxRecords *int64) *GroupRoleMappingsCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the group role mappings collection get params
func (o *GroupRoleMappingsCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOntapRoleName adds the ontapRoleName to the group role mappings collection get params
func (o *GroupRoleMappingsCollectionGetParams) WithOntapRoleName(ontapRoleName *string) *GroupRoleMappingsCollectionGetParams {
	o.SetOntapRoleName(ontapRoleName)
	return o
}

// SetOntapRoleName adds the ontapRoleName to the group role mappings collection get params
func (o *GroupRoleMappingsCollectionGetParams) SetOntapRoleName(ontapRoleName *string) {
	o.OntapRoleName = ontapRoleName
}

// WithOrderBy adds the orderBy to the group role mappings collection get params
func (o *GroupRoleMappingsCollectionGetParams) WithOrderBy(orderBy []string) *GroupRoleMappingsCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the group role mappings collection get params
func (o *GroupRoleMappingsCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the group role mappings collection get params
func (o *GroupRoleMappingsCollectionGetParams) WithReturnRecords(returnRecords *bool) *GroupRoleMappingsCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the group role mappings collection get params
func (o *GroupRoleMappingsCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the group role mappings collection get params
func (o *GroupRoleMappingsCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *GroupRoleMappingsCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the group role mappings collection get params
func (o *GroupRoleMappingsCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the group role mappings collection get params
func (o *GroupRoleMappingsCollectionGetParams) WithScope(scope *string) *GroupRoleMappingsCollectionGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the group role mappings collection get params
func (o *GroupRoleMappingsCollectionGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WriteToRequest writes these params to a swagger request
func (o *GroupRoleMappingsCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.GroupID != nil {

		// query param group_id
		var qrGroupID int64

		if o.GroupID != nil {
			qrGroupID = *o.GroupID
		}
		qGroupID := swag.FormatInt64(qrGroupID)
		if qGroupID != "" {

			if err := r.SetQueryParam("group_id", qGroupID); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OntapRoleName != nil {

		// query param ontap_role.name
		var qrOntapRoleName string

		if o.OntapRoleName != nil {
			qrOntapRoleName = *o.OntapRoleName
		}
		qOntapRoleName := qrOntapRoleName
		if qOntapRoleName != "" {

			if err := r.SetQueryParam("ontap_role.name", qOntapRoleName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGroupRoleMappingsCollectionGet binds the parameter fields
func (o *GroupRoleMappingsCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamGroupRoleMappingsCollectionGet binds the parameter order_by
func (o *GroupRoleMappingsCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
