// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// GroupRoleMappingsCreateReader is a Reader for the GroupRoleMappingsCreate structure.
type GroupRoleMappingsCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GroupRoleMappingsCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewGroupRoleMappingsCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGroupRoleMappingsCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGroupRoleMappingsCreateCreated creates a GroupRoleMappingsCreateCreated with default headers values
func NewGroupRoleMappingsCreateCreated() *GroupRoleMappingsCreateCreated {
	return &GroupRoleMappingsCreateCreated{}
}

/*
GroupRoleMappingsCreateCreated describes a response with status code 201, with default header values.

Created
*/
type GroupRoleMappingsCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.GroupRoleMappingsResponse
}

// IsSuccess returns true when this group role mappings create created response has a 2xx status code
func (o *GroupRoleMappingsCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this group role mappings create created response has a 3xx status code
func (o *GroupRoleMappingsCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this group role mappings create created response has a 4xx status code
func (o *GroupRoleMappingsCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this group role mappings create created response has a 5xx status code
func (o *GroupRoleMappingsCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this group role mappings create created response a status code equal to that given
func (o *GroupRoleMappingsCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the group role mappings create created response
func (o *GroupRoleMappingsCreateCreated) Code() int {
	return 201
}

func (o *GroupRoleMappingsCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/group/role-mappings][%d] groupRoleMappingsCreateCreated %s", 201, payload)
}

func (o *GroupRoleMappingsCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/group/role-mappings][%d] groupRoleMappingsCreateCreated %s", 201, payload)
}

func (o *GroupRoleMappingsCreateCreated) GetPayload() *models.GroupRoleMappingsResponse {
	return o.Payload
}

func (o *GroupRoleMappingsCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.GroupRoleMappingsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGroupRoleMappingsCreateDefault creates a GroupRoleMappingsCreateDefault with default headers values
func NewGroupRoleMappingsCreateDefault(code int) *GroupRoleMappingsCreateDefault {
	return &GroupRoleMappingsCreateDefault{
		_statusCode: code,
	}
}

/*
	GroupRoleMappingsCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5636242 | The configured group ID does not exist in the group configuration. |
| 5636243 | The configured role name does not exist in the SVM where the group ID is configured. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type GroupRoleMappingsCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this group role mappings create default response has a 2xx status code
func (o *GroupRoleMappingsCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this group role mappings create default response has a 3xx status code
func (o *GroupRoleMappingsCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this group role mappings create default response has a 4xx status code
func (o *GroupRoleMappingsCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this group role mappings create default response has a 5xx status code
func (o *GroupRoleMappingsCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this group role mappings create default response a status code equal to that given
func (o *GroupRoleMappingsCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the group role mappings create default response
func (o *GroupRoleMappingsCreateDefault) Code() int {
	return o._statusCode
}

func (o *GroupRoleMappingsCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/group/role-mappings][%d] group_role_mappings_create default %s", o._statusCode, payload)
}

func (o *GroupRoleMappingsCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/group/role-mappings][%d] group_role_mappings_create default %s", o._statusCode, payload)
}

func (o *GroupRoleMappingsCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GroupRoleMappingsCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
