// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// GroupRoleMappingsDeleteCollectionReader is a Reader for the GroupRoleMappingsDeleteCollection structure.
type GroupRoleMappingsDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GroupRoleMappingsDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGroupRoleMappingsDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGroupRoleMappingsDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGroupRoleMappingsDeleteCollectionOK creates a GroupRoleMappingsDeleteCollectionOK with default headers values
func NewGroupRoleMappingsDeleteCollectionOK() *GroupRoleMappingsDeleteCollectionOK {
	return &GroupRoleMappingsDeleteCollectionOK{}
}

/*
GroupRoleMappingsDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type GroupRoleMappingsDeleteCollectionOK struct {
}

// IsSuccess returns true when this group role mappings delete collection o k response has a 2xx status code
func (o *GroupRoleMappingsDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this group role mappings delete collection o k response has a 3xx status code
func (o *GroupRoleMappingsDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this group role mappings delete collection o k response has a 4xx status code
func (o *GroupRoleMappingsDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this group role mappings delete collection o k response has a 5xx status code
func (o *GroupRoleMappingsDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this group role mappings delete collection o k response a status code equal to that given
func (o *GroupRoleMappingsDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the group role mappings delete collection o k response
func (o *GroupRoleMappingsDeleteCollectionOK) Code() int {
	return 200
}

func (o *GroupRoleMappingsDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /security/group/role-mappings][%d] groupRoleMappingsDeleteCollectionOK", 200)
}

func (o *GroupRoleMappingsDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /security/group/role-mappings][%d] groupRoleMappingsDeleteCollectionOK", 200)
}

func (o *GroupRoleMappingsDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGroupRoleMappingsDeleteCollectionDefault creates a GroupRoleMappingsDeleteCollectionDefault with default headers values
func NewGroupRoleMappingsDeleteCollectionDefault(code int) *GroupRoleMappingsDeleteCollectionDefault {
	return &GroupRoleMappingsDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
GroupRoleMappingsDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type GroupRoleMappingsDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this group role mappings delete collection default response has a 2xx status code
func (o *GroupRoleMappingsDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this group role mappings delete collection default response has a 3xx status code
func (o *GroupRoleMappingsDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this group role mappings delete collection default response has a 4xx status code
func (o *GroupRoleMappingsDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this group role mappings delete collection default response has a 5xx status code
func (o *GroupRoleMappingsDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this group role mappings delete collection default response a status code equal to that given
func (o *GroupRoleMappingsDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the group role mappings delete collection default response
func (o *GroupRoleMappingsDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *GroupRoleMappingsDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/group/role-mappings][%d] group_role_mappings_delete_collection default %s", o._statusCode, payload)
}

func (o *GroupRoleMappingsDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/group/role-mappings][%d] group_role_mappings_delete_collection default %s", o._statusCode, payload)
}

func (o *GroupRoleMappingsDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GroupRoleMappingsDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
GroupRoleMappingsDeleteCollectionBody group role mappings delete collection body
swagger:model GroupRoleMappingsDeleteCollectionBody
*/
type GroupRoleMappingsDeleteCollectionBody struct {

	// group role mappings response inline records
	GroupRoleMappingsResponseInlineRecords []*models.GroupRoleMappings `json:"records,omitempty"`
}

// Validate validates this group role mappings delete collection body
func (o *GroupRoleMappingsDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateGroupRoleMappingsResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GroupRoleMappingsDeleteCollectionBody) validateGroupRoleMappingsResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.GroupRoleMappingsResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.GroupRoleMappingsResponseInlineRecords); i++ {
		if swag.IsZero(o.GroupRoleMappingsResponseInlineRecords[i]) { // not required
			continue
		}

		if o.GroupRoleMappingsResponseInlineRecords[i] != nil {
			if err := o.GroupRoleMappingsResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this group role mappings delete collection body based on the context it is used
func (o *GroupRoleMappingsDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateGroupRoleMappingsResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GroupRoleMappingsDeleteCollectionBody) contextValidateGroupRoleMappingsResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.GroupRoleMappingsResponseInlineRecords); i++ {

		if o.GroupRoleMappingsResponseInlineRecords[i] != nil {
			if err := o.GroupRoleMappingsResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *GroupRoleMappingsDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GroupRoleMappingsDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res GroupRoleMappingsDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
