// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// GroupRoleMappingsGetReader is a Reader for the GroupRoleMappingsGet structure.
type GroupRoleMappingsGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GroupRoleMappingsGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGroupRoleMappingsGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGroupRoleMappingsGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGroupRoleMappingsGetOK creates a GroupRoleMappingsGetOK with default headers values
func NewGroupRoleMappingsGetOK() *GroupRoleMappingsGetOK {
	return &GroupRoleMappingsGetOK{}
}

/*
GroupRoleMappingsGetOK describes a response with status code 200, with default header values.

OK
*/
type GroupRoleMappingsGetOK struct {
	Payload *models.GroupRoleMappings
}

// IsSuccess returns true when this group role mappings get o k response has a 2xx status code
func (o *GroupRoleMappingsGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this group role mappings get o k response has a 3xx status code
func (o *GroupRoleMappingsGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this group role mappings get o k response has a 4xx status code
func (o *GroupRoleMappingsGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this group role mappings get o k response has a 5xx status code
func (o *GroupRoleMappingsGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this group role mappings get o k response a status code equal to that given
func (o *GroupRoleMappingsGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the group role mappings get o k response
func (o *GroupRoleMappingsGetOK) Code() int {
	return 200
}

func (o *GroupRoleMappingsGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/group/role-mappings/{group_id}/{ontap_role.name}][%d] groupRoleMappingsGetOK %s", 200, payload)
}

func (o *GroupRoleMappingsGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/group/role-mappings/{group_id}/{ontap_role.name}][%d] groupRoleMappingsGetOK %s", 200, payload)
}

func (o *GroupRoleMappingsGetOK) GetPayload() *models.GroupRoleMappings {
	return o.Payload
}

func (o *GroupRoleMappingsGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GroupRoleMappings)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGroupRoleMappingsGetDefault creates a GroupRoleMappingsGetDefault with default headers values
func NewGroupRoleMappingsGetDefault(code int) *GroupRoleMappingsGetDefault {
	return &GroupRoleMappingsGetDefault{
		_statusCode: code,
	}
}

/*
GroupRoleMappingsGetDefault describes a response with status code -1, with default header values.

Error
*/
type GroupRoleMappingsGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this group role mappings get default response has a 2xx status code
func (o *GroupRoleMappingsGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this group role mappings get default response has a 3xx status code
func (o *GroupRoleMappingsGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this group role mappings get default response has a 4xx status code
func (o *GroupRoleMappingsGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this group role mappings get default response has a 5xx status code
func (o *GroupRoleMappingsGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this group role mappings get default response a status code equal to that given
func (o *GroupRoleMappingsGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the group role mappings get default response
func (o *GroupRoleMappingsGetDefault) Code() int {
	return o._statusCode
}

func (o *GroupRoleMappingsGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/group/role-mappings/{group_id}/{ontap_role.name}][%d] group_role_mappings_get default %s", o._statusCode, payload)
}

func (o *GroupRoleMappingsGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/group/role-mappings/{group_id}/{ontap_role.name}][%d] group_role_mappings_get default %s", o._statusCode, payload)
}

func (o *GroupRoleMappingsGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GroupRoleMappingsGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
