// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// GroupRoleMappingsModifyCollectionReader is a Reader for the GroupRoleMappingsModifyCollection structure.
type GroupRoleMappingsModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GroupRoleMappingsModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGroupRoleMappingsModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGroupRoleMappingsModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGroupRoleMappingsModifyCollectionOK creates a GroupRoleMappingsModifyCollectionOK with default headers values
func NewGroupRoleMappingsModifyCollectionOK() *GroupRoleMappingsModifyCollectionOK {
	return &GroupRoleMappingsModifyCollectionOK{}
}

/*
GroupRoleMappingsModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type GroupRoleMappingsModifyCollectionOK struct {
}

// IsSuccess returns true when this group role mappings modify collection o k response has a 2xx status code
func (o *GroupRoleMappingsModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this group role mappings modify collection o k response has a 3xx status code
func (o *GroupRoleMappingsModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this group role mappings modify collection o k response has a 4xx status code
func (o *GroupRoleMappingsModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this group role mappings modify collection o k response has a 5xx status code
func (o *GroupRoleMappingsModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this group role mappings modify collection o k response a status code equal to that given
func (o *GroupRoleMappingsModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the group role mappings modify collection o k response
func (o *GroupRoleMappingsModifyCollectionOK) Code() int {
	return 200
}

func (o *GroupRoleMappingsModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /security/group/role-mappings][%d] groupRoleMappingsModifyCollectionOK", 200)
}

func (o *GroupRoleMappingsModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /security/group/role-mappings][%d] groupRoleMappingsModifyCollectionOK", 200)
}

func (o *GroupRoleMappingsModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGroupRoleMappingsModifyCollectionDefault creates a GroupRoleMappingsModifyCollectionDefault with default headers values
func NewGroupRoleMappingsModifyCollectionDefault(code int) *GroupRoleMappingsModifyCollectionDefault {
	return &GroupRoleMappingsModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
GroupRoleMappingsModifyCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type GroupRoleMappingsModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this group role mappings modify collection default response has a 2xx status code
func (o *GroupRoleMappingsModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this group role mappings modify collection default response has a 3xx status code
func (o *GroupRoleMappingsModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this group role mappings modify collection default response has a 4xx status code
func (o *GroupRoleMappingsModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this group role mappings modify collection default response has a 5xx status code
func (o *GroupRoleMappingsModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this group role mappings modify collection default response a status code equal to that given
func (o *GroupRoleMappingsModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the group role mappings modify collection default response
func (o *GroupRoleMappingsModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *GroupRoleMappingsModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/group/role-mappings][%d] group_role_mappings_modify_collection default %s", o._statusCode, payload)
}

func (o *GroupRoleMappingsModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/group/role-mappings][%d] group_role_mappings_modify_collection default %s", o._statusCode, payload)
}

func (o *GroupRoleMappingsModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GroupRoleMappingsModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
GroupRoleMappingsModifyCollectionBody group role mappings modify collection body
swagger:model GroupRoleMappingsModifyCollectionBody
*/
type GroupRoleMappingsModifyCollectionBody struct {

	// links
	Links *models.GroupRoleMappingsInlineLinks `json:"_links,omitempty"`

	// Any comment regarding this group entry.
	Comment *string `json:"comment,omitempty"`

	// Group ID.
	// Example: 1
	// Maximum: 4.294967295e+09
	// Minimum: 1
	GroupID *int64 `json:"group_id,omitempty"`

	// group role mappings response inline records
	GroupRoleMappingsResponseInlineRecords []*models.GroupRoleMappings `json:"records,omitempty"`

	// ontap role
	OntapRole *models.GroupRoleMappingsInlineOntapRole `json:"ontap_role,omitempty"`

	// Scope of the entity. Set to "cluster" for cluster owned objects and to "svm" for SVM owned objects.
	// Read Only: true
	// Enum: ["cluster","svm"]
	Scope *string `json:"scope,omitempty"`
}

// Validate validates this group role mappings modify collection body
func (o *GroupRoleMappingsModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateGroupID(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateGroupRoleMappingsResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOntapRole(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GroupRoleMappingsModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *GroupRoleMappingsModifyCollectionBody) validateGroupID(formats strfmt.Registry) error {
	if swag.IsZero(o.GroupID) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"group_id", "body", *o.GroupID, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"group_id", "body", *o.GroupID, 4.294967295e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *GroupRoleMappingsModifyCollectionBody) validateGroupRoleMappingsResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.GroupRoleMappingsResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.GroupRoleMappingsResponseInlineRecords); i++ {
		if swag.IsZero(o.GroupRoleMappingsResponseInlineRecords[i]) { // not required
			continue
		}

		if o.GroupRoleMappingsResponseInlineRecords[i] != nil {
			if err := o.GroupRoleMappingsResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *GroupRoleMappingsModifyCollectionBody) validateOntapRole(formats strfmt.Registry) error {
	if swag.IsZero(o.OntapRole) { // not required
		return nil
	}

	if o.OntapRole != nil {
		if err := o.OntapRole.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ontap_role")
			}
			return err
		}
	}

	return nil
}

var groupRoleMappingsModifyCollectionBodyTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cluster","svm"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		groupRoleMappingsModifyCollectionBodyTypeScopePropEnum = append(groupRoleMappingsModifyCollectionBodyTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// GroupRoleMappingsModifyCollectionBody
	// GroupRoleMappingsModifyCollectionBody
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// GroupRoleMappingsModifyCollectionBodyScopeCluster captures enum value "cluster"
	GroupRoleMappingsModifyCollectionBodyScopeCluster string = "cluster"

	// BEGIN DEBUGGING
	// GroupRoleMappingsModifyCollectionBody
	// GroupRoleMappingsModifyCollectionBody
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// GroupRoleMappingsModifyCollectionBodyScopeSvm captures enum value "svm"
	GroupRoleMappingsModifyCollectionBodyScopeSvm string = "svm"
)

// prop value enum
func (o *GroupRoleMappingsModifyCollectionBody) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, groupRoleMappingsModifyCollectionBodyTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *GroupRoleMappingsModifyCollectionBody) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(o.Scope) { // not required
		return nil
	}

	// value enum
	if err := o.validateScopeEnum("info"+"."+"scope", "body", *o.Scope); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this group role mappings modify collection body based on the context it is used
func (o *GroupRoleMappingsModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateGroupRoleMappingsResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOntapRole(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GroupRoleMappingsModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *GroupRoleMappingsModifyCollectionBody) contextValidateGroupRoleMappingsResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.GroupRoleMappingsResponseInlineRecords); i++ {

		if o.GroupRoleMappingsResponseInlineRecords[i] != nil {
			if err := o.GroupRoleMappingsResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *GroupRoleMappingsModifyCollectionBody) contextValidateOntapRole(ctx context.Context, formats strfmt.Registry) error {

	if o.OntapRole != nil {
		if err := o.OntapRole.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ontap_role")
			}
			return err
		}
	}

	return nil
}

func (o *GroupRoleMappingsModifyCollectionBody) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"scope", "body", o.Scope); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *GroupRoleMappingsModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GroupRoleMappingsModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res GroupRoleMappingsModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
GroupRoleMappingsInlineLinks group role mappings inline links
swagger:model group_role_mappings_inline__links
*/
type GroupRoleMappingsInlineLinks struct {

	// next
	Next *models.Href `json:"next,omitempty"`

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this group role mappings inline links
func (o *GroupRoleMappingsInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateNext(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GroupRoleMappingsInlineLinks) validateNext(formats strfmt.Registry) error {
	if swag.IsZero(o.Next) { // not required
		return nil
	}

	if o.Next != nil {
		if err := o.Next.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (o *GroupRoleMappingsInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this group role mappings inline links based on the context it is used
func (o *GroupRoleMappingsInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateNext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GroupRoleMappingsInlineLinks) contextValidateNext(ctx context.Context, formats strfmt.Registry) error {

	if o.Next != nil {
		if err := o.Next.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "next")
			}
			return err
		}
	}

	return nil
}

func (o *GroupRoleMappingsInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *GroupRoleMappingsInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GroupRoleMappingsInlineLinks) UnmarshalBinary(b []byte) error {
	var res GroupRoleMappingsInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
GroupRoleMappingsInlineOntapRole Role name.
swagger:model group_role_mappings_inline_ontap_role
*/
type GroupRoleMappingsInlineOntapRole struct {

	// links
	Links *models.GroupRoleMappingsInlineOntapRoleInlineLinks `json:"_links,omitempty"`

	// Role name
	// Example: admin
	Name *string `json:"name,omitempty"`
}

// Validate validates this group role mappings inline ontap role
func (o *GroupRoleMappingsInlineOntapRole) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GroupRoleMappingsInlineOntapRole) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ontap_role" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this group role mappings inline ontap role based on the context it is used
func (o *GroupRoleMappingsInlineOntapRole) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GroupRoleMappingsInlineOntapRole) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ontap_role" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *GroupRoleMappingsInlineOntapRole) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GroupRoleMappingsInlineOntapRole) UnmarshalBinary(b []byte) error {
	var res GroupRoleMappingsInlineOntapRole
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
GroupRoleMappingsInlineOntapRoleInlineLinks group role mappings inline ontap role inline links
swagger:model group_role_mappings_inline_ontap_role_inline__links
*/
type GroupRoleMappingsInlineOntapRoleInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this group role mappings inline ontap role inline links
func (o *GroupRoleMappingsInlineOntapRoleInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GroupRoleMappingsInlineOntapRoleInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ontap_role" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this group role mappings inline ontap role inline links based on the context it is used
func (o *GroupRoleMappingsInlineOntapRoleInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GroupRoleMappingsInlineOntapRoleInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ontap_role" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *GroupRoleMappingsInlineOntapRoleInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GroupRoleMappingsInlineOntapRoleInlineLinks) UnmarshalBinary(b []byte) error {
	var res GroupRoleMappingsInlineOntapRoleInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
