// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewGroupRoleMappingsModifyParams creates a new GroupRoleMappingsModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGroupRoleMappingsModifyParams() *GroupRoleMappingsModifyParams {
	return &GroupRoleMappingsModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGroupRoleMappingsModifyParamsWithTimeout creates a new GroupRoleMappingsModifyParams object
// with the ability to set a timeout on a request.
func NewGroupRoleMappingsModifyParamsWithTimeout(timeout time.Duration) *GroupRoleMappingsModifyParams {
	return &GroupRoleMappingsModifyParams{
		timeout: timeout,
	}
}

// NewGroupRoleMappingsModifyParamsWithContext creates a new GroupRoleMappingsModifyParams object
// with the ability to set a context for a request.
func NewGroupRoleMappingsModifyParamsWithContext(ctx context.Context) *GroupRoleMappingsModifyParams {
	return &GroupRoleMappingsModifyParams{
		Context: ctx,
	}
}

// NewGroupRoleMappingsModifyParamsWithHTTPClient creates a new GroupRoleMappingsModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewGroupRoleMappingsModifyParamsWithHTTPClient(client *http.Client) *GroupRoleMappingsModifyParams {
	return &GroupRoleMappingsModifyParams{
		HTTPClient: client,
	}
}

/*
GroupRoleMappingsModifyParams contains all the parameters to send to the API endpoint

	for the group role mappings modify operation.

	Typically these are written to a http.Request.
*/
type GroupRoleMappingsModifyParams struct {

	/* GroupID.

	   Group ID.

	   Format: int64
	*/
	GroupID int64

	/* Info.

	   Group to role-mapping modification details.
	*/
	Info *models.GroupRoleMappings

	/* OntapRoleName.

	   Role name.
	*/
	OntapRoleName string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the group role mappings modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GroupRoleMappingsModifyParams) WithDefaults() *GroupRoleMappingsModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the group role mappings modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GroupRoleMappingsModifyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the group role mappings modify params
func (o *GroupRoleMappingsModifyParams) WithTimeout(timeout time.Duration) *GroupRoleMappingsModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the group role mappings modify params
func (o *GroupRoleMappingsModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the group role mappings modify params
func (o *GroupRoleMappingsModifyParams) WithContext(ctx context.Context) *GroupRoleMappingsModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the group role mappings modify params
func (o *GroupRoleMappingsModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the group role mappings modify params
func (o *GroupRoleMappingsModifyParams) WithHTTPClient(client *http.Client) *GroupRoleMappingsModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the group role mappings modify params
func (o *GroupRoleMappingsModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithGroupID adds the groupID to the group role mappings modify params
func (o *GroupRoleMappingsModifyParams) WithGroupID(groupID int64) *GroupRoleMappingsModifyParams {
	o.SetGroupID(groupID)
	return o
}

// SetGroupID adds the groupId to the group role mappings modify params
func (o *GroupRoleMappingsModifyParams) SetGroupID(groupID int64) {
	o.GroupID = groupID
}

// WithInfo adds the info to the group role mappings modify params
func (o *GroupRoleMappingsModifyParams) WithInfo(info *models.GroupRoleMappings) *GroupRoleMappingsModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the group role mappings modify params
func (o *GroupRoleMappingsModifyParams) SetInfo(info *models.GroupRoleMappings) {
	o.Info = info
}

// WithOntapRoleName adds the ontapRoleName to the group role mappings modify params
func (o *GroupRoleMappingsModifyParams) WithOntapRoleName(ontapRoleName string) *GroupRoleMappingsModifyParams {
	o.SetOntapRoleName(ontapRoleName)
	return o
}

// SetOntapRoleName adds the ontapRoleName to the group role mappings modify params
func (o *GroupRoleMappingsModifyParams) SetOntapRoleName(ontapRoleName string) {
	o.OntapRoleName = ontapRoleName
}

// WriteToRequest writes these params to a swagger request
func (o *GroupRoleMappingsModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param group_id
	if err := r.SetPathParam("group_id", swag.FormatInt64(o.GroupID)); err != nil {
		return err
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param ontap_role.name
	if err := r.SetPathParam("ontap_role.name", o.OntapRoleName); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
