// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewIpsecCaCertificateCollectionGetParams creates a new IpsecCaCertificateCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewIpsecCaCertificateCollectionGetParams() *IpsecCaCertificateCollectionGetParams {
	return &IpsecCaCertificateCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewIpsecCaCertificateCollectionGetParamsWithTimeout creates a new IpsecCaCertificateCollectionGetParams object
// with the ability to set a timeout on a request.
func NewIpsecCaCertificateCollectionGetParamsWithTimeout(timeout time.Duration) *IpsecCaCertificateCollectionGetParams {
	return &IpsecCaCertificateCollectionGetParams{
		timeout: timeout,
	}
}

// NewIpsecCaCertificateCollectionGetParamsWithContext creates a new IpsecCaCertificateCollectionGetParams object
// with the ability to set a context for a request.
func NewIpsecCaCertificateCollectionGetParamsWithContext(ctx context.Context) *IpsecCaCertificateCollectionGetParams {
	return &IpsecCaCertificateCollectionGetParams{
		Context: ctx,
	}
}

// NewIpsecCaCertificateCollectionGetParamsWithHTTPClient creates a new IpsecCaCertificateCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewIpsecCaCertificateCollectionGetParamsWithHTTPClient(client *http.Client) *IpsecCaCertificateCollectionGetParams {
	return &IpsecCaCertificateCollectionGetParams{
		HTTPClient: client,
	}
}

/*
IpsecCaCertificateCollectionGetParams contains all the parameters to send to the API endpoint

	for the ipsec ca certificate collection get operation.

	Typically these are written to a http.Request.
*/
type IpsecCaCertificateCollectionGetParams struct {

	/* CertificateUUID.

	   Filter by certificate.uuid
	*/
	CertificateUUID *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the ipsec ca certificate collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IpsecCaCertificateCollectionGetParams) WithDefaults() *IpsecCaCertificateCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the ipsec ca certificate collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IpsecCaCertificateCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := IpsecCaCertificateCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the ipsec ca certificate collection get params
func (o *IpsecCaCertificateCollectionGetParams) WithTimeout(timeout time.Duration) *IpsecCaCertificateCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the ipsec ca certificate collection get params
func (o *IpsecCaCertificateCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the ipsec ca certificate collection get params
func (o *IpsecCaCertificateCollectionGetParams) WithContext(ctx context.Context) *IpsecCaCertificateCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the ipsec ca certificate collection get params
func (o *IpsecCaCertificateCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the ipsec ca certificate collection get params
func (o *IpsecCaCertificateCollectionGetParams) WithHTTPClient(client *http.Client) *IpsecCaCertificateCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the ipsec ca certificate collection get params
func (o *IpsecCaCertificateCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCertificateUUID adds the certificateUUID to the ipsec ca certificate collection get params
func (o *IpsecCaCertificateCollectionGetParams) WithCertificateUUID(certificateUUID *string) *IpsecCaCertificateCollectionGetParams {
	o.SetCertificateUUID(certificateUUID)
	return o
}

// SetCertificateUUID adds the certificateUuid to the ipsec ca certificate collection get params
func (o *IpsecCaCertificateCollectionGetParams) SetCertificateUUID(certificateUUID *string) {
	o.CertificateUUID = certificateUUID
}

// WithFields adds the fields to the ipsec ca certificate collection get params
func (o *IpsecCaCertificateCollectionGetParams) WithFields(fields []string) *IpsecCaCertificateCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the ipsec ca certificate collection get params
func (o *IpsecCaCertificateCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the ipsec ca certificate collection get params
func (o *IpsecCaCertificateCollectionGetParams) WithMaxRecords(maxRecords *int64) *IpsecCaCertificateCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the ipsec ca certificate collection get params
func (o *IpsecCaCertificateCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the ipsec ca certificate collection get params
func (o *IpsecCaCertificateCollectionGetParams) WithOrderBy(orderBy []string) *IpsecCaCertificateCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the ipsec ca certificate collection get params
func (o *IpsecCaCertificateCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the ipsec ca certificate collection get params
func (o *IpsecCaCertificateCollectionGetParams) WithReturnRecords(returnRecords *bool) *IpsecCaCertificateCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the ipsec ca certificate collection get params
func (o *IpsecCaCertificateCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the ipsec ca certificate collection get params
func (o *IpsecCaCertificateCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *IpsecCaCertificateCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the ipsec ca certificate collection get params
func (o *IpsecCaCertificateCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the ipsec ca certificate collection get params
func (o *IpsecCaCertificateCollectionGetParams) WithScope(scope *string) *IpsecCaCertificateCollectionGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the ipsec ca certificate collection get params
func (o *IpsecCaCertificateCollectionGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSvmName adds the svmName to the ipsec ca certificate collection get params
func (o *IpsecCaCertificateCollectionGetParams) WithSvmName(svmName *string) *IpsecCaCertificateCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the ipsec ca certificate collection get params
func (o *IpsecCaCertificateCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the ipsec ca certificate collection get params
func (o *IpsecCaCertificateCollectionGetParams) WithSvmUUID(svmUUID *string) *IpsecCaCertificateCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the ipsec ca certificate collection get params
func (o *IpsecCaCertificateCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *IpsecCaCertificateCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CertificateUUID != nil {

		// query param certificate.uuid
		var qrCertificateUUID string

		if o.CertificateUUID != nil {
			qrCertificateUUID = *o.CertificateUUID
		}
		qCertificateUUID := qrCertificateUUID
		if qCertificateUUID != "" {

			if err := r.SetQueryParam("certificate.uuid", qCertificateUUID); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamIpsecCaCertificateCollectionGet binds the parameter fields
func (o *IpsecCaCertificateCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamIpsecCaCertificateCollectionGet binds the parameter order_by
func (o *IpsecCaCertificateCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
