// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewIpsecCaCertificateDeleteCollectionParams creates a new IpsecCaCertificateDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewIpsecCaCertificateDeleteCollectionParams() *IpsecCaCertificateDeleteCollectionParams {
	return &IpsecCaCertificateDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewIpsecCaCertificateDeleteCollectionParamsWithTimeout creates a new IpsecCaCertificateDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewIpsecCaCertificateDeleteCollectionParamsWithTimeout(timeout time.Duration) *IpsecCaCertificateDeleteCollectionParams {
	return &IpsecCaCertificateDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewIpsecCaCertificateDeleteCollectionParamsWithContext creates a new IpsecCaCertificateDeleteCollectionParams object
// with the ability to set a context for a request.
func NewIpsecCaCertificateDeleteCollectionParamsWithContext(ctx context.Context) *IpsecCaCertificateDeleteCollectionParams {
	return &IpsecCaCertificateDeleteCollectionParams{
		Context: ctx,
	}
}

// NewIpsecCaCertificateDeleteCollectionParamsWithHTTPClient creates a new IpsecCaCertificateDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewIpsecCaCertificateDeleteCollectionParamsWithHTTPClient(client *http.Client) *IpsecCaCertificateDeleteCollectionParams {
	return &IpsecCaCertificateDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
IpsecCaCertificateDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the ipsec ca certificate delete collection operation.

	Typically these are written to a http.Request.
*/
type IpsecCaCertificateDeleteCollectionParams struct {

	/* CertificateUUID.

	   Filter by certificate.uuid
	*/
	CertificateUUID *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info IpsecCaCertificateDeleteCollectionBody

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the ipsec ca certificate delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IpsecCaCertificateDeleteCollectionParams) WithDefaults() *IpsecCaCertificateDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the ipsec ca certificate delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IpsecCaCertificateDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := IpsecCaCertificateDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the ipsec ca certificate delete collection params
func (o *IpsecCaCertificateDeleteCollectionParams) WithTimeout(timeout time.Duration) *IpsecCaCertificateDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the ipsec ca certificate delete collection params
func (o *IpsecCaCertificateDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the ipsec ca certificate delete collection params
func (o *IpsecCaCertificateDeleteCollectionParams) WithContext(ctx context.Context) *IpsecCaCertificateDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the ipsec ca certificate delete collection params
func (o *IpsecCaCertificateDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the ipsec ca certificate delete collection params
func (o *IpsecCaCertificateDeleteCollectionParams) WithHTTPClient(client *http.Client) *IpsecCaCertificateDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the ipsec ca certificate delete collection params
func (o *IpsecCaCertificateDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCertificateUUID adds the certificateUUID to the ipsec ca certificate delete collection params
func (o *IpsecCaCertificateDeleteCollectionParams) WithCertificateUUID(certificateUUID *string) *IpsecCaCertificateDeleteCollectionParams {
	o.SetCertificateUUID(certificateUUID)
	return o
}

// SetCertificateUUID adds the certificateUuid to the ipsec ca certificate delete collection params
func (o *IpsecCaCertificateDeleteCollectionParams) SetCertificateUUID(certificateUUID *string) {
	o.CertificateUUID = certificateUUID
}

// WithContinueOnFailure adds the continueOnFailure to the ipsec ca certificate delete collection params
func (o *IpsecCaCertificateDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *IpsecCaCertificateDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the ipsec ca certificate delete collection params
func (o *IpsecCaCertificateDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the ipsec ca certificate delete collection params
func (o *IpsecCaCertificateDeleteCollectionParams) WithInfo(info IpsecCaCertificateDeleteCollectionBody) *IpsecCaCertificateDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the ipsec ca certificate delete collection params
func (o *IpsecCaCertificateDeleteCollectionParams) SetInfo(info IpsecCaCertificateDeleteCollectionBody) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the ipsec ca certificate delete collection params
func (o *IpsecCaCertificateDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *IpsecCaCertificateDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the ipsec ca certificate delete collection params
func (o *IpsecCaCertificateDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the ipsec ca certificate delete collection params
func (o *IpsecCaCertificateDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *IpsecCaCertificateDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the ipsec ca certificate delete collection params
func (o *IpsecCaCertificateDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the ipsec ca certificate delete collection params
func (o *IpsecCaCertificateDeleteCollectionParams) WithScope(scope *string) *IpsecCaCertificateDeleteCollectionParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the ipsec ca certificate delete collection params
func (o *IpsecCaCertificateDeleteCollectionParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSerialRecords adds the serialRecords to the ipsec ca certificate delete collection params
func (o *IpsecCaCertificateDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *IpsecCaCertificateDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the ipsec ca certificate delete collection params
func (o *IpsecCaCertificateDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSvmName adds the svmName to the ipsec ca certificate delete collection params
func (o *IpsecCaCertificateDeleteCollectionParams) WithSvmName(svmName *string) *IpsecCaCertificateDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the ipsec ca certificate delete collection params
func (o *IpsecCaCertificateDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the ipsec ca certificate delete collection params
func (o *IpsecCaCertificateDeleteCollectionParams) WithSvmUUID(svmUUID *string) *IpsecCaCertificateDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the ipsec ca certificate delete collection params
func (o *IpsecCaCertificateDeleteCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *IpsecCaCertificateDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CertificateUUID != nil {

		// query param certificate.uuid
		var qrCertificateUUID string

		if o.CertificateUUID != nil {
			qrCertificateUUID = *o.CertificateUUID
		}
		qCertificateUUID := qrCertificateUUID
		if qCertificateUUID != "" {

			if err := r.SetQueryParam("certificate.uuid", qCertificateUUID); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
