// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// IpsecCaCertificateDeleteCollectionReader is a Reader for the IpsecCaCertificateDeleteCollection structure.
type IpsecCaCertificateDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IpsecCaCertificateDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewIpsecCaCertificateDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIpsecCaCertificateDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIpsecCaCertificateDeleteCollectionOK creates a IpsecCaCertificateDeleteCollectionOK with default headers values
func NewIpsecCaCertificateDeleteCollectionOK() *IpsecCaCertificateDeleteCollectionOK {
	return &IpsecCaCertificateDeleteCollectionOK{}
}

/*
IpsecCaCertificateDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type IpsecCaCertificateDeleteCollectionOK struct {
}

// IsSuccess returns true when this ipsec ca certificate delete collection o k response has a 2xx status code
func (o *IpsecCaCertificateDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ipsec ca certificate delete collection o k response has a 3xx status code
func (o *IpsecCaCertificateDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ipsec ca certificate delete collection o k response has a 4xx status code
func (o *IpsecCaCertificateDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ipsec ca certificate delete collection o k response has a 5xx status code
func (o *IpsecCaCertificateDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ipsec ca certificate delete collection o k response a status code equal to that given
func (o *IpsecCaCertificateDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ipsec ca certificate delete collection o k response
func (o *IpsecCaCertificateDeleteCollectionOK) Code() int {
	return 200
}

func (o *IpsecCaCertificateDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /security/ipsec/ca-certificates][%d] ipsecCaCertificateDeleteCollectionOK", 200)
}

func (o *IpsecCaCertificateDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /security/ipsec/ca-certificates][%d] ipsecCaCertificateDeleteCollectionOK", 200)
}

func (o *IpsecCaCertificateDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewIpsecCaCertificateDeleteCollectionDefault creates a IpsecCaCertificateDeleteCollectionDefault with default headers values
func NewIpsecCaCertificateDeleteCollectionDefault(code int) *IpsecCaCertificateDeleteCollectionDefault {
	return &IpsecCaCertificateDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	IpsecCaCertificateDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 66257298 | CA certificate is not installed for IPsec. |
| 66257303 | The CA certificate cannot be removed from IPsec because it is not installed. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type IpsecCaCertificateDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ipsec ca certificate delete collection default response has a 2xx status code
func (o *IpsecCaCertificateDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ipsec ca certificate delete collection default response has a 3xx status code
func (o *IpsecCaCertificateDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ipsec ca certificate delete collection default response has a 4xx status code
func (o *IpsecCaCertificateDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ipsec ca certificate delete collection default response has a 5xx status code
func (o *IpsecCaCertificateDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ipsec ca certificate delete collection default response a status code equal to that given
func (o *IpsecCaCertificateDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ipsec ca certificate delete collection default response
func (o *IpsecCaCertificateDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *IpsecCaCertificateDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/ipsec/ca-certificates][%d] ipsec_ca_certificate_delete_collection default %s", o._statusCode, payload)
}

func (o *IpsecCaCertificateDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/ipsec/ca-certificates][%d] ipsec_ca_certificate_delete_collection default %s", o._statusCode, payload)
}

func (o *IpsecCaCertificateDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *IpsecCaCertificateDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
IpsecCaCertificateDeleteCollectionBody ipsec ca certificate delete collection body
swagger:model IpsecCaCertificateDeleteCollectionBody
*/
type IpsecCaCertificateDeleteCollectionBody struct {

	// ipsec ca certificate response inline records
	IpsecCaCertificateResponseInlineRecords []*models.IpsecCaCertificate `json:"records,omitempty"`
}

// Validate validates this ipsec ca certificate delete collection body
func (o *IpsecCaCertificateDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIpsecCaCertificateResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpsecCaCertificateDeleteCollectionBody) validateIpsecCaCertificateResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.IpsecCaCertificateResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.IpsecCaCertificateResponseInlineRecords); i++ {
		if swag.IsZero(o.IpsecCaCertificateResponseInlineRecords[i]) { // not required
			continue
		}

		if o.IpsecCaCertificateResponseInlineRecords[i] != nil {
			if err := o.IpsecCaCertificateResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ipsec ca certificate delete collection body based on the context it is used
func (o *IpsecCaCertificateDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIpsecCaCertificateResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpsecCaCertificateDeleteCollectionBody) contextValidateIpsecCaCertificateResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.IpsecCaCertificateResponseInlineRecords); i++ {

		if o.IpsecCaCertificateResponseInlineRecords[i] != nil {
			if err := o.IpsecCaCertificateResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *IpsecCaCertificateDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IpsecCaCertificateDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res IpsecCaCertificateDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
