// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewIpsecCaCertificateGetParams creates a new IpsecCaCertificateGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewIpsecCaCertificateGetParams() *IpsecCaCertificateGetParams {
	return &IpsecCaCertificateGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewIpsecCaCertificateGetParamsWithTimeout creates a new IpsecCaCertificateGetParams object
// with the ability to set a timeout on a request.
func NewIpsecCaCertificateGetParamsWithTimeout(timeout time.Duration) *IpsecCaCertificateGetParams {
	return &IpsecCaCertificateGetParams{
		timeout: timeout,
	}
}

// NewIpsecCaCertificateGetParamsWithContext creates a new IpsecCaCertificateGetParams object
// with the ability to set a context for a request.
func NewIpsecCaCertificateGetParamsWithContext(ctx context.Context) *IpsecCaCertificateGetParams {
	return &IpsecCaCertificateGetParams{
		Context: ctx,
	}
}

// NewIpsecCaCertificateGetParamsWithHTTPClient creates a new IpsecCaCertificateGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewIpsecCaCertificateGetParamsWithHTTPClient(client *http.Client) *IpsecCaCertificateGetParams {
	return &IpsecCaCertificateGetParams{
		HTTPClient: client,
	}
}

/*
IpsecCaCertificateGetParams contains all the parameters to send to the API endpoint

	for the ipsec ca certificate get operation.

	Typically these are written to a http.Request.
*/
type IpsecCaCertificateGetParams struct {

	/* CertificateUUID.

	   UUID of the IPsec CA certificate.
	*/
	CertificateUUID string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the ipsec ca certificate get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IpsecCaCertificateGetParams) WithDefaults() *IpsecCaCertificateGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the ipsec ca certificate get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IpsecCaCertificateGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the ipsec ca certificate get params
func (o *IpsecCaCertificateGetParams) WithTimeout(timeout time.Duration) *IpsecCaCertificateGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the ipsec ca certificate get params
func (o *IpsecCaCertificateGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the ipsec ca certificate get params
func (o *IpsecCaCertificateGetParams) WithContext(ctx context.Context) *IpsecCaCertificateGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the ipsec ca certificate get params
func (o *IpsecCaCertificateGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the ipsec ca certificate get params
func (o *IpsecCaCertificateGetParams) WithHTTPClient(client *http.Client) *IpsecCaCertificateGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the ipsec ca certificate get params
func (o *IpsecCaCertificateGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCertificateUUID adds the certificateUUID to the ipsec ca certificate get params
func (o *IpsecCaCertificateGetParams) WithCertificateUUID(certificateUUID string) *IpsecCaCertificateGetParams {
	o.SetCertificateUUID(certificateUUID)
	return o
}

// SetCertificateUUID adds the certificateUuid to the ipsec ca certificate get params
func (o *IpsecCaCertificateGetParams) SetCertificateUUID(certificateUUID string) {
	o.CertificateUUID = certificateUUID
}

// WithFields adds the fields to the ipsec ca certificate get params
func (o *IpsecCaCertificateGetParams) WithFields(fields []string) *IpsecCaCertificateGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the ipsec ca certificate get params
func (o *IpsecCaCertificateGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WriteToRequest writes these params to a swagger request
func (o *IpsecCaCertificateGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param certificate.uuid
	if err := r.SetPathParam("certificate.uuid", o.CertificateUUID); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamIpsecCaCertificateGet binds the parameter fields
func (o *IpsecCaCertificateGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
