// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// IpsecModifyReader is a Reader for the IpsecModify structure.
type IpsecModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IpsecModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewIpsecModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIpsecModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIpsecModifyOK creates a IpsecModifyOK with default headers values
func NewIpsecModifyOK() *IpsecModifyOK {
	return &IpsecModifyOK{}
}

/*
IpsecModifyOK describes a response with status code 200, with default header values.

OK
*/
type IpsecModifyOK struct {
}

// IsSuccess returns true when this ipsec modify o k response has a 2xx status code
func (o *IpsecModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ipsec modify o k response has a 3xx status code
func (o *IpsecModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ipsec modify o k response has a 4xx status code
func (o *IpsecModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ipsec modify o k response has a 5xx status code
func (o *IpsecModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ipsec modify o k response a status code equal to that given
func (o *IpsecModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ipsec modify o k response
func (o *IpsecModifyOK) Code() int {
	return 200
}

func (o *IpsecModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /security/ipsec][%d] ipsecModifyOK", 200)
}

func (o *IpsecModifyOK) String() string {
	return fmt.Sprintf("[PATCH /security/ipsec][%d] ipsecModifyOK", 200)
}

func (o *IpsecModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewIpsecModifyDefault creates a IpsecModifyDefault with default headers values
func NewIpsecModifyDefault(code int) *IpsecModifyDefault {
	return &IpsecModifyDefault{
		_statusCode: code,
	}
}

/*
	IpsecModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 66256898 | Internal error. Failed to enable IPsec. |
| 66256899 | Internal error. Failed to disable IPsec. |
| 66256913 | Offload setting changes are not allowed when IPsec is enabled. |
| 66256915 | Anti-replay protection and IPsec offload cannot be operational at the same time. |
| 66257007 | Failed to update replay window size. |
| 66257199 | IPsec is not supported in the current cluster version. |
| 66257496 | IPsec must be enabled to support BGP peer groups with MD5. Disable MD5 first in the BGP peer group. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type IpsecModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ipsec modify default response has a 2xx status code
func (o *IpsecModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ipsec modify default response has a 3xx status code
func (o *IpsecModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ipsec modify default response has a 4xx status code
func (o *IpsecModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ipsec modify default response has a 5xx status code
func (o *IpsecModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ipsec modify default response a status code equal to that given
func (o *IpsecModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ipsec modify default response
func (o *IpsecModifyDefault) Code() int {
	return o._statusCode
}

func (o *IpsecModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/ipsec][%d] ipsec_modify default %s", o._statusCode, payload)
}

func (o *IpsecModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/ipsec][%d] ipsec_modify default %s", o._statusCode, payload)
}

func (o *IpsecModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *IpsecModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
