// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewIpsecPolicyCollectionGetParams creates a new IpsecPolicyCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewIpsecPolicyCollectionGetParams() *IpsecPolicyCollectionGetParams {
	return &IpsecPolicyCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewIpsecPolicyCollectionGetParamsWithTimeout creates a new IpsecPolicyCollectionGetParams object
// with the ability to set a timeout on a request.
func NewIpsecPolicyCollectionGetParamsWithTimeout(timeout time.Duration) *IpsecPolicyCollectionGetParams {
	return &IpsecPolicyCollectionGetParams{
		timeout: timeout,
	}
}

// NewIpsecPolicyCollectionGetParamsWithContext creates a new IpsecPolicyCollectionGetParams object
// with the ability to set a context for a request.
func NewIpsecPolicyCollectionGetParamsWithContext(ctx context.Context) *IpsecPolicyCollectionGetParams {
	return &IpsecPolicyCollectionGetParams{
		Context: ctx,
	}
}

// NewIpsecPolicyCollectionGetParamsWithHTTPClient creates a new IpsecPolicyCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewIpsecPolicyCollectionGetParamsWithHTTPClient(client *http.Client) *IpsecPolicyCollectionGetParams {
	return &IpsecPolicyCollectionGetParams{
		HTTPClient: client,
	}
}

/*
IpsecPolicyCollectionGetParams contains all the parameters to send to the API endpoint

	for the ipsec policy collection get operation.

	Typically these are written to a http.Request.
*/
type IpsecPolicyCollectionGetParams struct {

	/* Action.

	   Filter by action
	*/
	Action *string

	/* AuthenticationMethod.

	   Filter by authentication_method
	*/
	AuthenticationMethod *string

	/* CertificateName.

	   Filter by certificate.name
	*/
	CertificateName *string

	/* CertificateUUID.

	   Filter by certificate.uuid
	*/
	CertificateUUID *string

	/* CertificateModifyKeepsa.

	   Filter by certificate_modify_keepsa
	*/
	CertificateModifyKeepsa *bool

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* IpspaceName.

	   Filter by ipspace.name
	*/
	IpspaceName *string

	/* IpspaceUUID.

	   Filter by ipspace.uuid
	*/
	IpspaceUUID *string

	/* LocalEndpointAddress.

	   Filter by local_endpoint.address
	*/
	LocalEndpointAddress *string

	/* LocalEndpointFamily.

	   Filter by local_endpoint.family
	*/
	LocalEndpointFamily *string

	/* LocalEndpointNetmask.

	   Filter by local_endpoint.netmask
	*/
	LocalEndpointNetmask *string

	/* LocalEndpointPort.

	   Filter by local_endpoint.port
	*/
	LocalEndpointPort *string

	/* LocalIdentity.

	   Filter by local_identity
	*/
	LocalIdentity *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* PpkIdentity.

	   Filter by ppk.identity
	*/
	PpkIdentity *string

	/* Protocol.

	   Filter by protocol
	*/
	Protocol *string

	/* RemoteEndpointAddress.

	   Filter by remote_endpoint.address
	*/
	RemoteEndpointAddress *string

	/* RemoteEndpointFamily.

	   Filter by remote_endpoint.family
	*/
	RemoteEndpointFamily *string

	/* RemoteEndpointNetmask.

	   Filter by remote_endpoint.netmask
	*/
	RemoteEndpointNetmask *string

	/* RemoteEndpointPort.

	   Filter by remote_endpoint.port
	*/
	RemoteEndpointPort *string

	/* RemoteIdentity.

	   Filter by remote_identity
	*/
	RemoteIdentity *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the ipsec policy collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IpsecPolicyCollectionGetParams) WithDefaults() *IpsecPolicyCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the ipsec policy collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IpsecPolicyCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := IpsecPolicyCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithTimeout(timeout time.Duration) *IpsecPolicyCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithContext(ctx context.Context) *IpsecPolicyCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithHTTPClient(client *http.Client) *IpsecPolicyCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAction adds the action to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithAction(action *string) *IpsecPolicyCollectionGetParams {
	o.SetAction(action)
	return o
}

// SetAction adds the action to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetAction(action *string) {
	o.Action = action
}

// WithAuthenticationMethod adds the authenticationMethod to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithAuthenticationMethod(authenticationMethod *string) *IpsecPolicyCollectionGetParams {
	o.SetAuthenticationMethod(authenticationMethod)
	return o
}

// SetAuthenticationMethod adds the authenticationMethod to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetAuthenticationMethod(authenticationMethod *string) {
	o.AuthenticationMethod = authenticationMethod
}

// WithCertificateName adds the certificateName to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithCertificateName(certificateName *string) *IpsecPolicyCollectionGetParams {
	o.SetCertificateName(certificateName)
	return o
}

// SetCertificateName adds the certificateName to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetCertificateName(certificateName *string) {
	o.CertificateName = certificateName
}

// WithCertificateUUID adds the certificateUUID to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithCertificateUUID(certificateUUID *string) *IpsecPolicyCollectionGetParams {
	o.SetCertificateUUID(certificateUUID)
	return o
}

// SetCertificateUUID adds the certificateUuid to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetCertificateUUID(certificateUUID *string) {
	o.CertificateUUID = certificateUUID
}

// WithCertificateModifyKeepsa adds the certificateModifyKeepsa to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithCertificateModifyKeepsa(certificateModifyKeepsa *bool) *IpsecPolicyCollectionGetParams {
	o.SetCertificateModifyKeepsa(certificateModifyKeepsa)
	return o
}

// SetCertificateModifyKeepsa adds the certificateModifyKeepsa to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetCertificateModifyKeepsa(certificateModifyKeepsa *bool) {
	o.CertificateModifyKeepsa = certificateModifyKeepsa
}

// WithEnabled adds the enabled to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithEnabled(enabled *bool) *IpsecPolicyCollectionGetParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithFields adds the fields to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithFields(fields []string) *IpsecPolicyCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIpspaceName adds the ipspaceName to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithIpspaceName(ipspaceName *string) *IpsecPolicyCollectionGetParams {
	o.SetIpspaceName(ipspaceName)
	return o
}

// SetIpspaceName adds the ipspaceName to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetIpspaceName(ipspaceName *string) {
	o.IpspaceName = ipspaceName
}

// WithIpspaceUUID adds the ipspaceUUID to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithIpspaceUUID(ipspaceUUID *string) *IpsecPolicyCollectionGetParams {
	o.SetIpspaceUUID(ipspaceUUID)
	return o
}

// SetIpspaceUUID adds the ipspaceUuid to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetIpspaceUUID(ipspaceUUID *string) {
	o.IpspaceUUID = ipspaceUUID
}

// WithLocalEndpointAddress adds the localEndpointAddress to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithLocalEndpointAddress(localEndpointAddress *string) *IpsecPolicyCollectionGetParams {
	o.SetLocalEndpointAddress(localEndpointAddress)
	return o
}

// SetLocalEndpointAddress adds the localEndpointAddress to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetLocalEndpointAddress(localEndpointAddress *string) {
	o.LocalEndpointAddress = localEndpointAddress
}

// WithLocalEndpointFamily adds the localEndpointFamily to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithLocalEndpointFamily(localEndpointFamily *string) *IpsecPolicyCollectionGetParams {
	o.SetLocalEndpointFamily(localEndpointFamily)
	return o
}

// SetLocalEndpointFamily adds the localEndpointFamily to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetLocalEndpointFamily(localEndpointFamily *string) {
	o.LocalEndpointFamily = localEndpointFamily
}

// WithLocalEndpointNetmask adds the localEndpointNetmask to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithLocalEndpointNetmask(localEndpointNetmask *string) *IpsecPolicyCollectionGetParams {
	o.SetLocalEndpointNetmask(localEndpointNetmask)
	return o
}

// SetLocalEndpointNetmask adds the localEndpointNetmask to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetLocalEndpointNetmask(localEndpointNetmask *string) {
	o.LocalEndpointNetmask = localEndpointNetmask
}

// WithLocalEndpointPort adds the localEndpointPort to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithLocalEndpointPort(localEndpointPort *string) *IpsecPolicyCollectionGetParams {
	o.SetLocalEndpointPort(localEndpointPort)
	return o
}

// SetLocalEndpointPort adds the localEndpointPort to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetLocalEndpointPort(localEndpointPort *string) {
	o.LocalEndpointPort = localEndpointPort
}

// WithLocalIdentity adds the localIdentity to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithLocalIdentity(localIdentity *string) *IpsecPolicyCollectionGetParams {
	o.SetLocalIdentity(localIdentity)
	return o
}

// SetLocalIdentity adds the localIdentity to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetLocalIdentity(localIdentity *string) {
	o.LocalIdentity = localIdentity
}

// WithMaxRecords adds the maxRecords to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithMaxRecords(maxRecords *int64) *IpsecPolicyCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithName(name *string) *IpsecPolicyCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithOrderBy(orderBy []string) *IpsecPolicyCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPpkIdentity adds the ppkIdentity to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithPpkIdentity(ppkIdentity *string) *IpsecPolicyCollectionGetParams {
	o.SetPpkIdentity(ppkIdentity)
	return o
}

// SetPpkIdentity adds the ppkIdentity to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetPpkIdentity(ppkIdentity *string) {
	o.PpkIdentity = ppkIdentity
}

// WithProtocol adds the protocol to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithProtocol(protocol *string) *IpsecPolicyCollectionGetParams {
	o.SetProtocol(protocol)
	return o
}

// SetProtocol adds the protocol to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetProtocol(protocol *string) {
	o.Protocol = protocol
}

// WithRemoteEndpointAddress adds the remoteEndpointAddress to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithRemoteEndpointAddress(remoteEndpointAddress *string) *IpsecPolicyCollectionGetParams {
	o.SetRemoteEndpointAddress(remoteEndpointAddress)
	return o
}

// SetRemoteEndpointAddress adds the remoteEndpointAddress to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetRemoteEndpointAddress(remoteEndpointAddress *string) {
	o.RemoteEndpointAddress = remoteEndpointAddress
}

// WithRemoteEndpointFamily adds the remoteEndpointFamily to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithRemoteEndpointFamily(remoteEndpointFamily *string) *IpsecPolicyCollectionGetParams {
	o.SetRemoteEndpointFamily(remoteEndpointFamily)
	return o
}

// SetRemoteEndpointFamily adds the remoteEndpointFamily to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetRemoteEndpointFamily(remoteEndpointFamily *string) {
	o.RemoteEndpointFamily = remoteEndpointFamily
}

// WithRemoteEndpointNetmask adds the remoteEndpointNetmask to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithRemoteEndpointNetmask(remoteEndpointNetmask *string) *IpsecPolicyCollectionGetParams {
	o.SetRemoteEndpointNetmask(remoteEndpointNetmask)
	return o
}

// SetRemoteEndpointNetmask adds the remoteEndpointNetmask to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetRemoteEndpointNetmask(remoteEndpointNetmask *string) {
	o.RemoteEndpointNetmask = remoteEndpointNetmask
}

// WithRemoteEndpointPort adds the remoteEndpointPort to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithRemoteEndpointPort(remoteEndpointPort *string) *IpsecPolicyCollectionGetParams {
	o.SetRemoteEndpointPort(remoteEndpointPort)
	return o
}

// SetRemoteEndpointPort adds the remoteEndpointPort to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetRemoteEndpointPort(remoteEndpointPort *string) {
	o.RemoteEndpointPort = remoteEndpointPort
}

// WithRemoteIdentity adds the remoteIdentity to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithRemoteIdentity(remoteIdentity *string) *IpsecPolicyCollectionGetParams {
	o.SetRemoteIdentity(remoteIdentity)
	return o
}

// SetRemoteIdentity adds the remoteIdentity to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetRemoteIdentity(remoteIdentity *string) {
	o.RemoteIdentity = remoteIdentity
}

// WithReturnRecords adds the returnRecords to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithReturnRecords(returnRecords *bool) *IpsecPolicyCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *IpsecPolicyCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithScope(scope *string) *IpsecPolicyCollectionGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSvmName adds the svmName to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithSvmName(svmName *string) *IpsecPolicyCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithSvmUUID(svmUUID *string) *IpsecPolicyCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) WithUUID(uuid *string) *IpsecPolicyCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the ipsec policy collection get params
func (o *IpsecPolicyCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *IpsecPolicyCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Action != nil {

		// query param action
		var qrAction string

		if o.Action != nil {
			qrAction = *o.Action
		}
		qAction := qrAction
		if qAction != "" {

			if err := r.SetQueryParam("action", qAction); err != nil {
				return err
			}
		}
	}

	if o.AuthenticationMethod != nil {

		// query param authentication_method
		var qrAuthenticationMethod string

		if o.AuthenticationMethod != nil {
			qrAuthenticationMethod = *o.AuthenticationMethod
		}
		qAuthenticationMethod := qrAuthenticationMethod
		if qAuthenticationMethod != "" {

			if err := r.SetQueryParam("authentication_method", qAuthenticationMethod); err != nil {
				return err
			}
		}
	}

	if o.CertificateName != nil {

		// query param certificate.name
		var qrCertificateName string

		if o.CertificateName != nil {
			qrCertificateName = *o.CertificateName
		}
		qCertificateName := qrCertificateName
		if qCertificateName != "" {

			if err := r.SetQueryParam("certificate.name", qCertificateName); err != nil {
				return err
			}
		}
	}

	if o.CertificateUUID != nil {

		// query param certificate.uuid
		var qrCertificateUUID string

		if o.CertificateUUID != nil {
			qrCertificateUUID = *o.CertificateUUID
		}
		qCertificateUUID := qrCertificateUUID
		if qCertificateUUID != "" {

			if err := r.SetQueryParam("certificate.uuid", qCertificateUUID); err != nil {
				return err
			}
		}
	}

	if o.CertificateModifyKeepsa != nil {

		// query param certificate_modify_keepsa
		var qrCertificateModifyKeepsa bool

		if o.CertificateModifyKeepsa != nil {
			qrCertificateModifyKeepsa = *o.CertificateModifyKeepsa
		}
		qCertificateModifyKeepsa := swag.FormatBool(qrCertificateModifyKeepsa)
		if qCertificateModifyKeepsa != "" {

			if err := r.SetQueryParam("certificate_modify_keepsa", qCertificateModifyKeepsa); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.IpspaceName != nil {

		// query param ipspace.name
		var qrIpspaceName string

		if o.IpspaceName != nil {
			qrIpspaceName = *o.IpspaceName
		}
		qIpspaceName := qrIpspaceName
		if qIpspaceName != "" {

			if err := r.SetQueryParam("ipspace.name", qIpspaceName); err != nil {
				return err
			}
		}
	}

	if o.IpspaceUUID != nil {

		// query param ipspace.uuid
		var qrIpspaceUUID string

		if o.IpspaceUUID != nil {
			qrIpspaceUUID = *o.IpspaceUUID
		}
		qIpspaceUUID := qrIpspaceUUID
		if qIpspaceUUID != "" {

			if err := r.SetQueryParam("ipspace.uuid", qIpspaceUUID); err != nil {
				return err
			}
		}
	}

	if o.LocalEndpointAddress != nil {

		// query param local_endpoint.address
		var qrLocalEndpointAddress string

		if o.LocalEndpointAddress != nil {
			qrLocalEndpointAddress = *o.LocalEndpointAddress
		}
		qLocalEndpointAddress := qrLocalEndpointAddress
		if qLocalEndpointAddress != "" {

			if err := r.SetQueryParam("local_endpoint.address", qLocalEndpointAddress); err != nil {
				return err
			}
		}
	}

	if o.LocalEndpointFamily != nil {

		// query param local_endpoint.family
		var qrLocalEndpointFamily string

		if o.LocalEndpointFamily != nil {
			qrLocalEndpointFamily = *o.LocalEndpointFamily
		}
		qLocalEndpointFamily := qrLocalEndpointFamily
		if qLocalEndpointFamily != "" {

			if err := r.SetQueryParam("local_endpoint.family", qLocalEndpointFamily); err != nil {
				return err
			}
		}
	}

	if o.LocalEndpointNetmask != nil {

		// query param local_endpoint.netmask
		var qrLocalEndpointNetmask string

		if o.LocalEndpointNetmask != nil {
			qrLocalEndpointNetmask = *o.LocalEndpointNetmask
		}
		qLocalEndpointNetmask := qrLocalEndpointNetmask
		if qLocalEndpointNetmask != "" {

			if err := r.SetQueryParam("local_endpoint.netmask", qLocalEndpointNetmask); err != nil {
				return err
			}
		}
	}

	if o.LocalEndpointPort != nil {

		// query param local_endpoint.port
		var qrLocalEndpointPort string

		if o.LocalEndpointPort != nil {
			qrLocalEndpointPort = *o.LocalEndpointPort
		}
		qLocalEndpointPort := qrLocalEndpointPort
		if qLocalEndpointPort != "" {

			if err := r.SetQueryParam("local_endpoint.port", qLocalEndpointPort); err != nil {
				return err
			}
		}
	}

	if o.LocalIdentity != nil {

		// query param local_identity
		var qrLocalIdentity string

		if o.LocalIdentity != nil {
			qrLocalIdentity = *o.LocalIdentity
		}
		qLocalIdentity := qrLocalIdentity
		if qLocalIdentity != "" {

			if err := r.SetQueryParam("local_identity", qLocalIdentity); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.PpkIdentity != nil {

		// query param ppk.identity
		var qrPpkIdentity string

		if o.PpkIdentity != nil {
			qrPpkIdentity = *o.PpkIdentity
		}
		qPpkIdentity := qrPpkIdentity
		if qPpkIdentity != "" {

			if err := r.SetQueryParam("ppk.identity", qPpkIdentity); err != nil {
				return err
			}
		}
	}

	if o.Protocol != nil {

		// query param protocol
		var qrProtocol string

		if o.Protocol != nil {
			qrProtocol = *o.Protocol
		}
		qProtocol := qrProtocol
		if qProtocol != "" {

			if err := r.SetQueryParam("protocol", qProtocol); err != nil {
				return err
			}
		}
	}

	if o.RemoteEndpointAddress != nil {

		// query param remote_endpoint.address
		var qrRemoteEndpointAddress string

		if o.RemoteEndpointAddress != nil {
			qrRemoteEndpointAddress = *o.RemoteEndpointAddress
		}
		qRemoteEndpointAddress := qrRemoteEndpointAddress
		if qRemoteEndpointAddress != "" {

			if err := r.SetQueryParam("remote_endpoint.address", qRemoteEndpointAddress); err != nil {
				return err
			}
		}
	}

	if o.RemoteEndpointFamily != nil {

		// query param remote_endpoint.family
		var qrRemoteEndpointFamily string

		if o.RemoteEndpointFamily != nil {
			qrRemoteEndpointFamily = *o.RemoteEndpointFamily
		}
		qRemoteEndpointFamily := qrRemoteEndpointFamily
		if qRemoteEndpointFamily != "" {

			if err := r.SetQueryParam("remote_endpoint.family", qRemoteEndpointFamily); err != nil {
				return err
			}
		}
	}

	if o.RemoteEndpointNetmask != nil {

		// query param remote_endpoint.netmask
		var qrRemoteEndpointNetmask string

		if o.RemoteEndpointNetmask != nil {
			qrRemoteEndpointNetmask = *o.RemoteEndpointNetmask
		}
		qRemoteEndpointNetmask := qrRemoteEndpointNetmask
		if qRemoteEndpointNetmask != "" {

			if err := r.SetQueryParam("remote_endpoint.netmask", qRemoteEndpointNetmask); err != nil {
				return err
			}
		}
	}

	if o.RemoteEndpointPort != nil {

		// query param remote_endpoint.port
		var qrRemoteEndpointPort string

		if o.RemoteEndpointPort != nil {
			qrRemoteEndpointPort = *o.RemoteEndpointPort
		}
		qRemoteEndpointPort := qrRemoteEndpointPort
		if qRemoteEndpointPort != "" {

			if err := r.SetQueryParam("remote_endpoint.port", qRemoteEndpointPort); err != nil {
				return err
			}
		}
	}

	if o.RemoteIdentity != nil {

		// query param remote_identity
		var qrRemoteIdentity string

		if o.RemoteIdentity != nil {
			qrRemoteIdentity = *o.RemoteIdentity
		}
		qRemoteIdentity := qrRemoteIdentity
		if qRemoteIdentity != "" {

			if err := r.SetQueryParam("remote_identity", qRemoteIdentity); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamIpsecPolicyCollectionGet binds the parameter fields
func (o *IpsecPolicyCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamIpsecPolicyCollectionGet binds the parameter order_by
func (o *IpsecPolicyCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
