// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// IpsecPolicyDeleteCollectionReader is a Reader for the IpsecPolicyDeleteCollection structure.
type IpsecPolicyDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IpsecPolicyDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewIpsecPolicyDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIpsecPolicyDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIpsecPolicyDeleteCollectionOK creates a IpsecPolicyDeleteCollectionOK with default headers values
func NewIpsecPolicyDeleteCollectionOK() *IpsecPolicyDeleteCollectionOK {
	return &IpsecPolicyDeleteCollectionOK{}
}

/*
IpsecPolicyDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type IpsecPolicyDeleteCollectionOK struct {
}

// IsSuccess returns true when this ipsec policy delete collection o k response has a 2xx status code
func (o *IpsecPolicyDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ipsec policy delete collection o k response has a 3xx status code
func (o *IpsecPolicyDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ipsec policy delete collection o k response has a 4xx status code
func (o *IpsecPolicyDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ipsec policy delete collection o k response has a 5xx status code
func (o *IpsecPolicyDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ipsec policy delete collection o k response a status code equal to that given
func (o *IpsecPolicyDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ipsec policy delete collection o k response
func (o *IpsecPolicyDeleteCollectionOK) Code() int {
	return 200
}

func (o *IpsecPolicyDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /security/ipsec/policies][%d] ipsecPolicyDeleteCollectionOK", 200)
}

func (o *IpsecPolicyDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /security/ipsec/policies][%d] ipsecPolicyDeleteCollectionOK", 200)
}

func (o *IpsecPolicyDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewIpsecPolicyDeleteCollectionDefault creates a IpsecPolicyDeleteCollectionDefault with default headers values
func NewIpsecPolicyDeleteCollectionDefault(code int) *IpsecPolicyDeleteCollectionDefault {
	return &IpsecPolicyDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	IpsecPolicyDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 66257096 | Internal error. Failed to purge connections associated with the IPsec policy. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type IpsecPolicyDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ipsec policy delete collection default response has a 2xx status code
func (o *IpsecPolicyDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ipsec policy delete collection default response has a 3xx status code
func (o *IpsecPolicyDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ipsec policy delete collection default response has a 4xx status code
func (o *IpsecPolicyDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ipsec policy delete collection default response has a 5xx status code
func (o *IpsecPolicyDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ipsec policy delete collection default response a status code equal to that given
func (o *IpsecPolicyDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ipsec policy delete collection default response
func (o *IpsecPolicyDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *IpsecPolicyDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/ipsec/policies][%d] ipsec_policy_delete_collection default %s", o._statusCode, payload)
}

func (o *IpsecPolicyDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/ipsec/policies][%d] ipsec_policy_delete_collection default %s", o._statusCode, payload)
}

func (o *IpsecPolicyDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *IpsecPolicyDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
IpsecPolicyDeleteCollectionBody ipsec policy delete collection body
swagger:model IpsecPolicyDeleteCollectionBody
*/
type IpsecPolicyDeleteCollectionBody struct {

	// error
	Error *models.IpsecPolicyResponseInlineError `json:"error,omitempty"`

	// ipsec policy response inline records
	IpsecPolicyResponseInlineRecords []*models.IpsecPolicyResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`
}

// Validate validates this ipsec policy delete collection body
func (o *IpsecPolicyDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIpsecPolicyResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpsecPolicyDeleteCollectionBody) validateError(formats strfmt.Registry) error {
	if swag.IsZero(o.Error) { // not required
		return nil
	}

	if o.Error != nil {
		if err := o.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyDeleteCollectionBody) validateIpsecPolicyResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.IpsecPolicyResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.IpsecPolicyResponseInlineRecords); i++ {
		if swag.IsZero(o.IpsecPolicyResponseInlineRecords[i]) { // not required
			continue
		}

		if o.IpsecPolicyResponseInlineRecords[i] != nil {
			if err := o.IpsecPolicyResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ipsec policy delete collection body based on the context it is used
func (o *IpsecPolicyDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIpsecPolicyResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpsecPolicyDeleteCollectionBody) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if o.Error != nil {
		if err := o.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyDeleteCollectionBody) contextValidateIpsecPolicyResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.IpsecPolicyResponseInlineRecords); i++ {

		if o.IpsecPolicyResponseInlineRecords[i] != nil {
			if err := o.IpsecPolicyResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *IpsecPolicyDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IpsecPolicyDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IpsecPolicyResponseInlineError ipsec policy response inline error
swagger:model ipsec_policy_response_inline_error
*/
type IpsecPolicyResponseInlineError struct {

	// Message arguments
	// Read Only: true
	Arguments []*models.ErrorArguments `json:"arguments,omitempty"`

	// Error code
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Error message
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this ipsec policy response inline error
func (o *IpsecPolicyResponseInlineError) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpsecPolicyResponseInlineError) validateArguments(formats strfmt.Registry) error {
	if swag.IsZero(o.Arguments) { // not required
		return nil
	}

	for i := 0; i < len(o.Arguments); i++ {
		if swag.IsZero(o.Arguments[i]) { // not required
			continue
		}

		if o.Arguments[i] != nil {
			if err := o.Arguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "error" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this ipsec policy response inline error based on the context it is used
func (o *IpsecPolicyResponseInlineError) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpsecPolicyResponseInlineError) contextValidateArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"error"+"."+"arguments", "body", []*models.ErrorArguments(o.Arguments)); err != nil {
		return err
	}

	for i := 0; i < len(o.Arguments); i++ {

		if o.Arguments[i] != nil {
			if err := o.Arguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "error" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IpsecPolicyResponseInlineError) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"error"+"."+"code", "body", o.Code); err != nil {
		return err
	}

	return nil
}

func (o *IpsecPolicyResponseInlineError) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"error"+"."+"message", "body", o.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IpsecPolicyResponseInlineError) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IpsecPolicyResponseInlineError) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyResponseInlineError
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IpsecPolicyResponseInlineRecordsInlineArrayItem IPsec policy object.
swagger:model ipsec_policy_response_inline_records_inline_array_item
*/
type IpsecPolicyResponseInlineRecordsInlineArrayItem struct {

	// Action for the IPsec policy.
	// Enum: ["bypass","discard","esp_transport","esp_udp"]
	Action *string `json:"action,omitempty"`

	// Authentication method for the IPsec policy.
	// Enum: ["none","psk","pki"]
	AuthenticationMethod *string `json:"authentication_method,omitempty"`

	// certificate
	Certificate *models.IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificate `json:"certificate,omitempty"`

	// Indicates whether old security associations are kept upon certificate modification.
	CertificateModifyKeepsa *bool `json:"certificate_modify_keepsa,omitempty"`

	// Indicates whether or not the policy is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// ipspace
	Ipspace *models.IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspace `json:"ipspace,omitempty"`

	// local endpoint
	LocalEndpoint *models.IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint `json:"local_endpoint,omitempty"`

	// Local Identity
	LocalIdentity *string `json:"local_identity,omitempty"`

	// IPsec policy name.
	// Max Length: 64
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// ppk
	Ppk *models.IpsecPolicyResponseInlineRecordsInlineArrayItemInlinePpk `json:"ppk,omitempty"`

	// Lower layer protocol to be covered by the IPsec policy.
	// Example: 17
	Protocol *string `json:"protocol,omitempty"`

	// remote endpoint
	RemoteEndpoint *models.IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint `json:"remote_endpoint,omitempty"`

	// Remote Identity
	RemoteIdentity *string `json:"remote_identity,omitempty"`

	// scope
	Scope *models.NetworkScopeReadonly `json:"scope,omitempty"`

	// Pre-shared key for IKE negotiation.
	// Max Length: 128
	// Min Length: 18
	SecretKey *string `json:"secret_key,omitempty"`

	// svm
	Svm *models.IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvm `json:"svm,omitempty"`

	// Unique identifier of the IPsec policy.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ipsec policy response inline records inline array item
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAuthenticationMethod(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIpspace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLocalEndpoint(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePpk(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRemoteEndpoint(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSecretKey(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var ipsecPolicyResponseInlineRecordsInlineArrayItemTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["bypass","discard","esp_transport","esp_udp"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ipsecPolicyResponseInlineRecordsInlineArrayItemTypeActionPropEnum = append(ipsecPolicyResponseInlineRecordsInlineArrayItemTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ipsec_policy_response_inline_records_inline_array_item
	// IpsecPolicyResponseInlineRecordsInlineArrayItem
	// action
	// Action
	// bypass
	// END DEBUGGING
	// IpsecPolicyResponseInlineRecordsInlineArrayItemActionBypass captures enum value "bypass"
	IpsecPolicyResponseInlineRecordsInlineArrayItemActionBypass string = "bypass"

	// BEGIN DEBUGGING
	// ipsec_policy_response_inline_records_inline_array_item
	// IpsecPolicyResponseInlineRecordsInlineArrayItem
	// action
	// Action
	// discard
	// END DEBUGGING
	// IpsecPolicyResponseInlineRecordsInlineArrayItemActionDiscard captures enum value "discard"
	IpsecPolicyResponseInlineRecordsInlineArrayItemActionDiscard string = "discard"

	// BEGIN DEBUGGING
	// ipsec_policy_response_inline_records_inline_array_item
	// IpsecPolicyResponseInlineRecordsInlineArrayItem
	// action
	// Action
	// esp_transport
	// END DEBUGGING
	// IpsecPolicyResponseInlineRecordsInlineArrayItemActionEspTransport captures enum value "esp_transport"
	IpsecPolicyResponseInlineRecordsInlineArrayItemActionEspTransport string = "esp_transport"

	// BEGIN DEBUGGING
	// ipsec_policy_response_inline_records_inline_array_item
	// IpsecPolicyResponseInlineRecordsInlineArrayItem
	// action
	// Action
	// esp_udp
	// END DEBUGGING
	// IpsecPolicyResponseInlineRecordsInlineArrayItemActionEspUDP captures enum value "esp_udp"
	IpsecPolicyResponseInlineRecordsInlineArrayItemActionEspUDP string = "esp_udp"
)

// prop value enum
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItem) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ipsecPolicyResponseInlineRecordsInlineArrayItemTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItem) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(o.Action) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionEnum("action", "body", *o.Action); err != nil {
		return err
	}

	return nil
}

var ipsecPolicyResponseInlineRecordsInlineArrayItemTypeAuthenticationMethodPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","psk","pki"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ipsecPolicyResponseInlineRecordsInlineArrayItemTypeAuthenticationMethodPropEnum = append(ipsecPolicyResponseInlineRecordsInlineArrayItemTypeAuthenticationMethodPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ipsec_policy_response_inline_records_inline_array_item
	// IpsecPolicyResponseInlineRecordsInlineArrayItem
	// authentication_method
	// AuthenticationMethod
	// none
	// END DEBUGGING
	// IpsecPolicyResponseInlineRecordsInlineArrayItemAuthenticationMethodNone captures enum value "none"
	IpsecPolicyResponseInlineRecordsInlineArrayItemAuthenticationMethodNone string = "none"

	// BEGIN DEBUGGING
	// ipsec_policy_response_inline_records_inline_array_item
	// IpsecPolicyResponseInlineRecordsInlineArrayItem
	// authentication_method
	// AuthenticationMethod
	// psk
	// END DEBUGGING
	// IpsecPolicyResponseInlineRecordsInlineArrayItemAuthenticationMethodPsk captures enum value "psk"
	IpsecPolicyResponseInlineRecordsInlineArrayItemAuthenticationMethodPsk string = "psk"

	// BEGIN DEBUGGING
	// ipsec_policy_response_inline_records_inline_array_item
	// IpsecPolicyResponseInlineRecordsInlineArrayItem
	// authentication_method
	// AuthenticationMethod
	// pki
	// END DEBUGGING
	// IpsecPolicyResponseInlineRecordsInlineArrayItemAuthenticationMethodPki captures enum value "pki"
	IpsecPolicyResponseInlineRecordsInlineArrayItemAuthenticationMethodPki string = "pki"
)

// prop value enum
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItem) validateAuthenticationMethodEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ipsecPolicyResponseInlineRecordsInlineArrayItemTypeAuthenticationMethodPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItem) validateAuthenticationMethod(formats strfmt.Registry) error {
	if swag.IsZero(o.AuthenticationMethod) { // not required
		return nil
	}

	// value enum
	if err := o.validateAuthenticationMethodEnum("authentication_method", "body", *o.AuthenticationMethod); err != nil {
		return err
	}

	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItem) validateCertificate(formats strfmt.Registry) error {
	if swag.IsZero(o.Certificate) { // not required
		return nil
	}

	if o.Certificate != nil {
		if err := o.Certificate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItem) validateIpspace(formats strfmt.Registry) error {
	if swag.IsZero(o.Ipspace) { // not required
		return nil
	}

	if o.Ipspace != nil {
		if err := o.Ipspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItem) validateLocalEndpoint(formats strfmt.Registry) error {
	if swag.IsZero(o.LocalEndpoint) { // not required
		return nil
	}

	if o.LocalEndpoint != nil {
		if err := o.LocalEndpoint.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_endpoint")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *o.Name, 64); err != nil {
		return err
	}

	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItem) validatePpk(formats strfmt.Registry) error {
	if swag.IsZero(o.Ppk) { // not required
		return nil
	}

	if o.Ppk != nil {
		if err := o.Ppk.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ppk")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItem) validateRemoteEndpoint(formats strfmt.Registry) error {
	if swag.IsZero(o.RemoteEndpoint) { // not required
		return nil
	}

	if o.RemoteEndpoint != nil {
		if err := o.RemoteEndpoint.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_endpoint")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItem) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(o.Scope) { // not required
		return nil
	}

	if o.Scope != nil {
		if err := o.Scope.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("scope")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItem) validateSecretKey(formats strfmt.Registry) error {
	if swag.IsZero(o.SecretKey) { // not required
		return nil
	}

	if err := validate.MinLength("secret_key", "body", *o.SecretKey, 18); err != nil {
		return err
	}

	if err := validate.MaxLength("secret_key", "body", *o.SecretKey, 128); err != nil {
		return err
	}

	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItem) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy response inline records inline array item based on the context it is used
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCertificate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIpspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLocalEndpoint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePpk(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRemoteEndpoint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItem) contextValidateCertificate(ctx context.Context, formats strfmt.Registry) error {

	if o.Certificate != nil {
		if err := o.Certificate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItem) contextValidateIpspace(ctx context.Context, formats strfmt.Registry) error {

	if o.Ipspace != nil {
		if err := o.Ipspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItem) contextValidateLocalEndpoint(ctx context.Context, formats strfmt.Registry) error {

	if o.LocalEndpoint != nil {
		if err := o.LocalEndpoint.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_endpoint")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItem) contextValidatePpk(ctx context.Context, formats strfmt.Registry) error {

	if o.Ppk != nil {
		if err := o.Ppk.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ppk")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItem) contextValidateRemoteEndpoint(ctx context.Context, formats strfmt.Registry) error {

	if o.RemoteEndpoint != nil {
		if err := o.RemoteEndpoint.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_endpoint")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItem) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if o.Scope != nil {
		if err := o.Scope.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("scope")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItem) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificate Certificate for the IPsec policy.
swagger:model ipsec_policy_response_inline_records_inline_array_item_inline_certificate
*/
type IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificate struct {

	// links
	Links *models.IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks `json:"_links,omitempty"`

	// Certificate name
	Name *string `json:"name,omitempty"`

	// Certificate UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ipsec policy response inline records inline array item inline certificate
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy response inline records inline array item inline certificate based on the context it is used
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificate) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificate) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks ipsec policy response inline records inline array item inline certificate inline links
swagger:model ipsec_policy_response_inline_records_inline_array_item_inline_certificate_inline__links
*/
type IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ipsec policy response inline records inline array item inline certificate inline links
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy response inline records inline array item inline certificate inline links based on the context it is used
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspace Applies to both SVM and cluster-scoped objects. Either the UUID or name may be supplied on input.
swagger:model ipsec_policy_response_inline_records_inline_array_item_inline_ipspace
*/
type IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspace struct {

	// links
	Links *models.IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspaceInlineLinks `json:"_links,omitempty"`

	// IPspace name
	// Example: Default
	Name *string `json:"name,omitempty"`

	// IPspace UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ipsec policy response inline records inline array item inline ipspace
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspace) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy response inline records inline array item inline ipspace based on the context it is used
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspace) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspace) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspace) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspaceInlineLinks ipsec policy response inline records inline array item inline ipspace inline links
swagger:model ipsec_policy_response_inline_records_inline_array_item_inline_ipspace_inline__links
*/
type IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspaceInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ipsec policy response inline records inline array item inline ipspace inline links
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy response inline records inline array item inline ipspace inline links based on the context it is used
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspaceInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint Local endpoint for the IPsec policy.
swagger:model ipsec_policy_response_inline_records_inline_array_item_inline_local_endpoint
*/
type IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint struct {

	// address
	Address *models.IPAddress `json:"address,omitempty"`

	// family
	Family *models.IPAddressFamily `json:"family,omitempty"`

	// netmask
	Netmask *models.IPNetmask `json:"netmask,omitempty"`

	// Application port to be covered by the IPsec policy
	// Example: 23
	Port *string `json:"port,omitempty"`
}

// Validate validates this ipsec policy response inline records inline array item inline local endpoint
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFamily(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNetmask(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(o.Address) { // not required
		return nil
	}

	if o.Address != nil {
		if err := o.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_endpoint" + "." + "address")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint) validateFamily(formats strfmt.Registry) error {
	if swag.IsZero(o.Family) { // not required
		return nil
	}

	if o.Family != nil {
		if err := o.Family.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_endpoint" + "." + "family")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint) validateNetmask(formats strfmt.Registry) error {
	if swag.IsZero(o.Netmask) { // not required
		return nil
	}

	if o.Netmask != nil {
		if err := o.Netmask.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_endpoint" + "." + "netmask")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy response inline records inline array item inline local endpoint based on the context it is used
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFamily(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNetmask(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if o.Address != nil {
		if err := o.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_endpoint" + "." + "address")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint) contextValidateFamily(ctx context.Context, formats strfmt.Registry) error {

	if o.Family != nil {
		if err := o.Family.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_endpoint" + "." + "family")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint) contextValidateNetmask(ctx context.Context, formats strfmt.Registry) error {

	if o.Netmask != nil {
		if err := o.Netmask.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_endpoint" + "." + "netmask")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IpsecPolicyResponseInlineRecordsInlineArrayItemInlinePpk Post-quantum pre-shared key information.
swagger:model ipsec_policy_response_inline_records_inline_array_item_inline_ppk
*/
type IpsecPolicyResponseInlineRecordsInlineArrayItemInlinePpk struct {

	// Post-quantum pre-shared key identity.
	// Max Length: 64
	// Min Length: 6
	Identity *string `json:"identity,omitempty"`

	// Post-quantum pre-shared key.
	// Max Length: 128
	// Min Length: 18
	SharedKey *string `json:"shared_key,omitempty"`
}

// Validate validates this ipsec policy response inline records inline array item inline ppk
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlinePpk) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIdentity(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSharedKey(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlinePpk) validateIdentity(formats strfmt.Registry) error {
	if swag.IsZero(o.Identity) { // not required
		return nil
	}

	if err := validate.MinLength("ppk"+"."+"identity", "body", *o.Identity, 6); err != nil {
		return err
	}

	if err := validate.MaxLength("ppk"+"."+"identity", "body", *o.Identity, 64); err != nil {
		return err
	}

	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlinePpk) validateSharedKey(formats strfmt.Registry) error {
	if swag.IsZero(o.SharedKey) { // not required
		return nil
	}

	if err := validate.MinLength("ppk"+"."+"shared_key", "body", *o.SharedKey, 18); err != nil {
		return err
	}

	if err := validate.MaxLength("ppk"+"."+"shared_key", "body", *o.SharedKey, 128); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this ipsec policy response inline records inline array item inline ppk based on context it is used
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlinePpk) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlinePpk) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlinePpk) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyResponseInlineRecordsInlineArrayItemInlinePpk
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint Remote endpoint for the IPsec policy.
swagger:model ipsec_policy_response_inline_records_inline_array_item_inline_remote_endpoint
*/
type IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint struct {

	// address
	Address *models.IPAddress `json:"address,omitempty"`

	// family
	Family *models.IPAddressFamily `json:"family,omitempty"`

	// netmask
	Netmask *models.IPNetmask `json:"netmask,omitempty"`

	// Application port to be covered by the IPsec policy
	// Example: 23
	Port *string `json:"port,omitempty"`
}

// Validate validates this ipsec policy response inline records inline array item inline remote endpoint
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFamily(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNetmask(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(o.Address) { // not required
		return nil
	}

	if o.Address != nil {
		if err := o.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_endpoint" + "." + "address")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint) validateFamily(formats strfmt.Registry) error {
	if swag.IsZero(o.Family) { // not required
		return nil
	}

	if o.Family != nil {
		if err := o.Family.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_endpoint" + "." + "family")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint) validateNetmask(formats strfmt.Registry) error {
	if swag.IsZero(o.Netmask) { // not required
		return nil
	}

	if o.Netmask != nil {
		if err := o.Netmask.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_endpoint" + "." + "netmask")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy response inline records inline array item inline remote endpoint based on the context it is used
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFamily(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNetmask(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if o.Address != nil {
		if err := o.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_endpoint" + "." + "address")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint) contextValidateFamily(ctx context.Context, formats strfmt.Registry) error {

	if o.Family != nil {
		if err := o.Family.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_endpoint" + "." + "family")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint) contextValidateNetmask(ctx context.Context, formats strfmt.Registry) error {

	if o.Netmask != nil {
		if err := o.Netmask.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote_endpoint" + "." + "netmask")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model ipsec_policy_response_inline_records_inline_array_item_inline_svm
*/
type IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvm struct {

	// links
	Links *models.IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ipsec policy response inline records inline array item inline svm
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy response inline records inline array item inline svm based on the context it is used
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvm) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks ipsec policy response inline records inline array item inline svm inline links
swagger:model ipsec_policy_response_inline_records_inline_array_item_inline_svm_inline__links
*/
type IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this ipsec policy response inline records inline array item inline svm inline links
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy response inline records inline array item inline svm inline links based on the context it is used
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
