// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewIpsecPolicyGetParams creates a new IpsecPolicyGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewIpsecPolicyGetParams() *IpsecPolicyGetParams {
	return &IpsecPolicyGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewIpsecPolicyGetParamsWithTimeout creates a new IpsecPolicyGetParams object
// with the ability to set a timeout on a request.
func NewIpsecPolicyGetParamsWithTimeout(timeout time.Duration) *IpsecPolicyGetParams {
	return &IpsecPolicyGetParams{
		timeout: timeout,
	}
}

// NewIpsecPolicyGetParamsWithContext creates a new IpsecPolicyGetParams object
// with the ability to set a context for a request.
func NewIpsecPolicyGetParamsWithContext(ctx context.Context) *IpsecPolicyGetParams {
	return &IpsecPolicyGetParams{
		Context: ctx,
	}
}

// NewIpsecPolicyGetParamsWithHTTPClient creates a new IpsecPolicyGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewIpsecPolicyGetParamsWithHTTPClient(client *http.Client) *IpsecPolicyGetParams {
	return &IpsecPolicyGetParams{
		HTTPClient: client,
	}
}

/*
IpsecPolicyGetParams contains all the parameters to send to the API endpoint

	for the ipsec policy get operation.

	Typically these are written to a http.Request.
*/
type IpsecPolicyGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* UUID.

	   IPsec policy UUID
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the ipsec policy get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IpsecPolicyGetParams) WithDefaults() *IpsecPolicyGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the ipsec policy get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IpsecPolicyGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the ipsec policy get params
func (o *IpsecPolicyGetParams) WithTimeout(timeout time.Duration) *IpsecPolicyGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the ipsec policy get params
func (o *IpsecPolicyGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the ipsec policy get params
func (o *IpsecPolicyGetParams) WithContext(ctx context.Context) *IpsecPolicyGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the ipsec policy get params
func (o *IpsecPolicyGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the ipsec policy get params
func (o *IpsecPolicyGetParams) WithHTTPClient(client *http.Client) *IpsecPolicyGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the ipsec policy get params
func (o *IpsecPolicyGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the ipsec policy get params
func (o *IpsecPolicyGetParams) WithFields(fields []string) *IpsecPolicyGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the ipsec policy get params
func (o *IpsecPolicyGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithUUID adds the uuid to the ipsec policy get params
func (o *IpsecPolicyGetParams) WithUUID(uuid string) *IpsecPolicyGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the ipsec policy get params
func (o *IpsecPolicyGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *IpsecPolicyGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamIpsecPolicyGet binds the parameter fields
func (o *IpsecPolicyGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
