// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// IpsecPolicyGetReader is a Reader for the IpsecPolicyGet structure.
type IpsecPolicyGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IpsecPolicyGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewIpsecPolicyGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIpsecPolicyGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIpsecPolicyGetOK creates a IpsecPolicyGetOK with default headers values
func NewIpsecPolicyGetOK() *IpsecPolicyGetOK {
	return &IpsecPolicyGetOK{}
}

/*
IpsecPolicyGetOK describes a response with status code 200, with default header values.

OK
*/
type IpsecPolicyGetOK struct {
	Payload *models.IpsecPolicy
}

// IsSuccess returns true when this ipsec policy get o k response has a 2xx status code
func (o *IpsecPolicyGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ipsec policy get o k response has a 3xx status code
func (o *IpsecPolicyGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ipsec policy get o k response has a 4xx status code
func (o *IpsecPolicyGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ipsec policy get o k response has a 5xx status code
func (o *IpsecPolicyGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ipsec policy get o k response a status code equal to that given
func (o *IpsecPolicyGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ipsec policy get o k response
func (o *IpsecPolicyGetOK) Code() int {
	return 200
}

func (o *IpsecPolicyGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/ipsec/policies/{uuid}][%d] ipsecPolicyGetOK %s", 200, payload)
}

func (o *IpsecPolicyGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/ipsec/policies/{uuid}][%d] ipsecPolicyGetOK %s", 200, payload)
}

func (o *IpsecPolicyGetOK) GetPayload() *models.IpsecPolicy {
	return o.Payload
}

func (o *IpsecPolicyGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.IpsecPolicy)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewIpsecPolicyGetDefault creates a IpsecPolicyGetDefault with default headers values
func NewIpsecPolicyGetDefault(code int) *IpsecPolicyGetDefault {
	return &IpsecPolicyGetDefault{
		_statusCode: code,
	}
}

/*
IpsecPolicyGetDefault describes a response with status code -1, with default header values.

Error
*/
type IpsecPolicyGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ipsec policy get default response has a 2xx status code
func (o *IpsecPolicyGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ipsec policy get default response has a 3xx status code
func (o *IpsecPolicyGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ipsec policy get default response has a 4xx status code
func (o *IpsecPolicyGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ipsec policy get default response has a 5xx status code
func (o *IpsecPolicyGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ipsec policy get default response a status code equal to that given
func (o *IpsecPolicyGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ipsec policy get default response
func (o *IpsecPolicyGetDefault) Code() int {
	return o._statusCode
}

func (o *IpsecPolicyGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/ipsec/policies/{uuid}][%d] ipsec_policy_get default %s", o._statusCode, payload)
}

func (o *IpsecPolicyGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/ipsec/policies/{uuid}][%d] ipsec_policy_get default %s", o._statusCode, payload)
}

func (o *IpsecPolicyGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *IpsecPolicyGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
