// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// IpsecPolicyModifyCollectionReader is a Reader for the IpsecPolicyModifyCollection structure.
type IpsecPolicyModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IpsecPolicyModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewIpsecPolicyModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIpsecPolicyModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIpsecPolicyModifyCollectionOK creates a IpsecPolicyModifyCollectionOK with default headers values
func NewIpsecPolicyModifyCollectionOK() *IpsecPolicyModifyCollectionOK {
	return &IpsecPolicyModifyCollectionOK{}
}

/*
IpsecPolicyModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type IpsecPolicyModifyCollectionOK struct {
}

// IsSuccess returns true when this ipsec policy modify collection o k response has a 2xx status code
func (o *IpsecPolicyModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ipsec policy modify collection o k response has a 3xx status code
func (o *IpsecPolicyModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ipsec policy modify collection o k response has a 4xx status code
func (o *IpsecPolicyModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ipsec policy modify collection o k response has a 5xx status code
func (o *IpsecPolicyModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ipsec policy modify collection o k response a status code equal to that given
func (o *IpsecPolicyModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ipsec policy modify collection o k response
func (o *IpsecPolicyModifyCollectionOK) Code() int {
	return 200
}

func (o *IpsecPolicyModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /security/ipsec/policies][%d] ipsecPolicyModifyCollectionOK", 200)
}

func (o *IpsecPolicyModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /security/ipsec/policies][%d] ipsecPolicyModifyCollectionOK", 200)
}

func (o *IpsecPolicyModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewIpsecPolicyModifyCollectionDefault creates a IpsecPolicyModifyCollectionDefault with default headers values
func NewIpsecPolicyModifyCollectionDefault(code int) *IpsecPolicyModifyCollectionDefault {
	return &IpsecPolicyModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	IpsecPolicyModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 66257097 | Internal error. Failed to update the IPsec policy. |
| 66257099 | Only one protocol can be specified. |
| 66257100 | Only one local port can be specified. |
| 66257101 | Only one remote port can be specified. |
| 66257110 | Failed to create a policy sequencing value. |
| 66257113 | Only one local IP subnet can be specified. |
| 66257114 | Only one remote IP subnet can be specified. |
| 66257115 | Port ranges containing more than one port are not supported. |
| 66257120 | The subnet selector must be a host address (An IPv4 address with a 32-bit netmask or an IPv6 address with a 128-bit netmask). |
| 66257125 | The local_endpoint.address must be specified with local_endpoint.netmask. |
| 66257126 | The remote_endpoint.address must be specified with remote_endpoint.netmask. |
| 66257127 | The local subnet must be configured as a non-zero subnet. |
| 66257128 | Invalid ANY wildcard subnet. |
| 66257129 | A specific local or remote port number is required when the remote subnet is configured as an ANY wildcard subnet. |
| 66257131 | ESP in UDPv6 Encapsulation is not supported. |
| 66257135 | The specified certificate is not found on the SVM. |
| 66257136 | A certificate is not needed for the PSK authentication method. |
| 66257138 | Remote identity is required when using certificate verification. |
| 66257139 | Certificate with the specified UUID was not found. |
| 66257140 | Only certificates with a client or server type are supported. |
| 66257142 | Failed to create IPsec policy because the specified SVM is being migrated. |
| 66257143 | Invalid IPsec policy provided. The subnet must be non-empty. |
| 66257153 | The policy requires a post-quantum pre-shared key because ppk-identity is specified for this policy. |
| 66257154 | The policy requires a post-quantum pre-shared identity because ppk-shared-key is specified for this policy. |
| 66257199 | Not all of the nodes in the cluster are running a version that supports the IPsec feature. |
| 66257200 | The shared key does not meet required ASCII-range characters length. |
| 66257201 | Support for the feature available with effective cluster version or later. |
| 66257305 | The certificate UUID does not match the provided certificate name. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type IpsecPolicyModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ipsec policy modify collection default response has a 2xx status code
func (o *IpsecPolicyModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ipsec policy modify collection default response has a 3xx status code
func (o *IpsecPolicyModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ipsec policy modify collection default response has a 4xx status code
func (o *IpsecPolicyModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ipsec policy modify collection default response has a 5xx status code
func (o *IpsecPolicyModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ipsec policy modify collection default response a status code equal to that given
func (o *IpsecPolicyModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ipsec policy modify collection default response
func (o *IpsecPolicyModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *IpsecPolicyModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/ipsec/policies][%d] ipsec_policy_modify_collection default %s", o._statusCode, payload)
}

func (o *IpsecPolicyModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/ipsec/policies][%d] ipsec_policy_modify_collection default %s", o._statusCode, payload)
}

func (o *IpsecPolicyModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *IpsecPolicyModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
IpsecPolicyModifyCollectionBody ipsec policy modify collection body
swagger:model IpsecPolicyModifyCollectionBody
*/
type IpsecPolicyModifyCollectionBody struct {

	// Action for the IPsec policy.
	// Enum: ["bypass","discard","esp_transport","esp_udp"]
	Action *string `json:"action,omitempty"`

	// Authentication method for the IPsec policy.
	// Enum: ["none","psk","pki"]
	AuthenticationMethod *string `json:"authentication_method,omitempty"`

	// certificate
	Certificate *models.IpsecPolicyResponseInlineRecordsInlineArrayItemInlineCertificate `json:"certificate,omitempty"`

	// Indicates whether old security associations are kept upon certificate modification.
	CertificateModifyKeepsa *bool `json:"certificate_modify_keepsa,omitempty"`

	// Indicates whether or not the policy is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// error
	Error *models.IpsecPolicyResponseInlineError `json:"error,omitempty"`

	// ipsec policy response inline records
	IpsecPolicyResponseInlineRecords []*models.IpsecPolicyResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`

	// ipspace
	Ipspace *models.IpsecPolicyResponseInlineRecordsInlineArrayItemInlineIpspace `json:"ipspace,omitempty"`

	// local endpoint
	LocalEndpoint *models.IpsecPolicyResponseInlineRecordsInlineArrayItemInlineLocalEndpoint `json:"local_endpoint,omitempty"`

	// Local Identity
	LocalIdentity *string `json:"local_identity,omitempty"`

	// IPsec policy name.
	// Max Length: 64
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// ppk
	Ppk *models.IpsecPolicyResponseInlineRecordsInlineArrayItemInlinePpk `json:"ppk,omitempty"`

	// Lower layer protocol to be covered by the IPsec policy.
	// Example: 17
	Protocol *string `json:"protocol,omitempty"`

	// remote endpoint
	RemoteEndpoint *models.IpsecPolicyResponseInlineRecordsInlineArrayItemInlineRemoteEndpoint `json:"remote_endpoint,omitempty"`

	// Remote Identity
	RemoteIdentity *string `json:"remote_identity,omitempty"`

	// scope
	Scope *models.NetworkScopeReadonly `json:"scope,omitempty"`

	// Pre-shared key for IKE negotiation.
	// Max Length: 128
	// Min Length: 18
	SecretKey *string `json:"secret_key,omitempty"`

	// svm
	Svm *models.IpsecPolicyResponseInlineRecordsInlineArrayItemInlineSvm `json:"svm,omitempty"`

	// Unique identifier of the IPsec policy.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this ipsec policy modify collection body
func (o *IpsecPolicyModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAuthenticationMethod(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIpsecPolicyResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIpspace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLocalEndpoint(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePpk(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRemoteEndpoint(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSecretKey(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var ipsecPolicyModifyCollectionBodyTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["bypass","discard","esp_transport","esp_udp"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ipsecPolicyModifyCollectionBodyTypeActionPropEnum = append(ipsecPolicyModifyCollectionBodyTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// IpsecPolicyModifyCollectionBody
	// IpsecPolicyModifyCollectionBody
	// action
	// Action
	// bypass
	// END DEBUGGING
	// IpsecPolicyModifyCollectionBodyActionBypass captures enum value "bypass"
	IpsecPolicyModifyCollectionBodyActionBypass string = "bypass"

	// BEGIN DEBUGGING
	// IpsecPolicyModifyCollectionBody
	// IpsecPolicyModifyCollectionBody
	// action
	// Action
	// discard
	// END DEBUGGING
	// IpsecPolicyModifyCollectionBodyActionDiscard captures enum value "discard"
	IpsecPolicyModifyCollectionBodyActionDiscard string = "discard"

	// BEGIN DEBUGGING
	// IpsecPolicyModifyCollectionBody
	// IpsecPolicyModifyCollectionBody
	// action
	// Action
	// esp_transport
	// END DEBUGGING
	// IpsecPolicyModifyCollectionBodyActionEspTransport captures enum value "esp_transport"
	IpsecPolicyModifyCollectionBodyActionEspTransport string = "esp_transport"

	// BEGIN DEBUGGING
	// IpsecPolicyModifyCollectionBody
	// IpsecPolicyModifyCollectionBody
	// action
	// Action
	// esp_udp
	// END DEBUGGING
	// IpsecPolicyModifyCollectionBodyActionEspUDP captures enum value "esp_udp"
	IpsecPolicyModifyCollectionBodyActionEspUDP string = "esp_udp"
)

// prop value enum
func (o *IpsecPolicyModifyCollectionBody) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ipsecPolicyModifyCollectionBodyTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *IpsecPolicyModifyCollectionBody) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(o.Action) { // not required
		return nil
	}

	// value enum
	if err := o.validateActionEnum("info"+"."+"action", "body", *o.Action); err != nil {
		return err
	}

	return nil
}

var ipsecPolicyModifyCollectionBodyTypeAuthenticationMethodPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","psk","pki"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		ipsecPolicyModifyCollectionBodyTypeAuthenticationMethodPropEnum = append(ipsecPolicyModifyCollectionBodyTypeAuthenticationMethodPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// IpsecPolicyModifyCollectionBody
	// IpsecPolicyModifyCollectionBody
	// authentication_method
	// AuthenticationMethod
	// none
	// END DEBUGGING
	// IpsecPolicyModifyCollectionBodyAuthenticationMethodNone captures enum value "none"
	IpsecPolicyModifyCollectionBodyAuthenticationMethodNone string = "none"

	// BEGIN DEBUGGING
	// IpsecPolicyModifyCollectionBody
	// IpsecPolicyModifyCollectionBody
	// authentication_method
	// AuthenticationMethod
	// psk
	// END DEBUGGING
	// IpsecPolicyModifyCollectionBodyAuthenticationMethodPsk captures enum value "psk"
	IpsecPolicyModifyCollectionBodyAuthenticationMethodPsk string = "psk"

	// BEGIN DEBUGGING
	// IpsecPolicyModifyCollectionBody
	// IpsecPolicyModifyCollectionBody
	// authentication_method
	// AuthenticationMethod
	// pki
	// END DEBUGGING
	// IpsecPolicyModifyCollectionBodyAuthenticationMethodPki captures enum value "pki"
	IpsecPolicyModifyCollectionBodyAuthenticationMethodPki string = "pki"
)

// prop value enum
func (o *IpsecPolicyModifyCollectionBody) validateAuthenticationMethodEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, ipsecPolicyModifyCollectionBodyTypeAuthenticationMethodPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *IpsecPolicyModifyCollectionBody) validateAuthenticationMethod(formats strfmt.Registry) error {
	if swag.IsZero(o.AuthenticationMethod) { // not required
		return nil
	}

	// value enum
	if err := o.validateAuthenticationMethodEnum("info"+"."+"authentication_method", "body", *o.AuthenticationMethod); err != nil {
		return err
	}

	return nil
}

func (o *IpsecPolicyModifyCollectionBody) validateCertificate(formats strfmt.Registry) error {
	if swag.IsZero(o.Certificate) { // not required
		return nil
	}

	if o.Certificate != nil {
		if err := o.Certificate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "certificate")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyModifyCollectionBody) validateError(formats strfmt.Registry) error {
	if swag.IsZero(o.Error) { // not required
		return nil
	}

	if o.Error != nil {
		if err := o.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyModifyCollectionBody) validateIpsecPolicyResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.IpsecPolicyResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.IpsecPolicyResponseInlineRecords); i++ {
		if swag.IsZero(o.IpsecPolicyResponseInlineRecords[i]) { // not required
			continue
		}

		if o.IpsecPolicyResponseInlineRecords[i] != nil {
			if err := o.IpsecPolicyResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IpsecPolicyModifyCollectionBody) validateIpspace(formats strfmt.Registry) error {
	if swag.IsZero(o.Ipspace) { // not required
		return nil
	}

	if o.Ipspace != nil {
		if err := o.Ipspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyModifyCollectionBody) validateLocalEndpoint(formats strfmt.Registry) error {
	if swag.IsZero(o.LocalEndpoint) { // not required
		return nil
	}

	if o.LocalEndpoint != nil {
		if err := o.LocalEndpoint.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local_endpoint")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyModifyCollectionBody) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"name", "body", *o.Name, 64); err != nil {
		return err
	}

	return nil
}

func (o *IpsecPolicyModifyCollectionBody) validatePpk(formats strfmt.Registry) error {
	if swag.IsZero(o.Ppk) { // not required
		return nil
	}

	if o.Ppk != nil {
		if err := o.Ppk.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ppk")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyModifyCollectionBody) validateRemoteEndpoint(formats strfmt.Registry) error {
	if swag.IsZero(o.RemoteEndpoint) { // not required
		return nil
	}

	if o.RemoteEndpoint != nil {
		if err := o.RemoteEndpoint.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "remote_endpoint")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyModifyCollectionBody) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(o.Scope) { // not required
		return nil
	}

	if o.Scope != nil {
		if err := o.Scope.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "scope")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyModifyCollectionBody) validateSecretKey(formats strfmt.Registry) error {
	if swag.IsZero(o.SecretKey) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"secret_key", "body", *o.SecretKey, 18); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"secret_key", "body", *o.SecretKey, 128); err != nil {
		return err
	}

	return nil
}

func (o *IpsecPolicyModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this ipsec policy modify collection body based on the context it is used
func (o *IpsecPolicyModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCertificate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIpsecPolicyResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIpspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLocalEndpoint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePpk(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRemoteEndpoint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IpsecPolicyModifyCollectionBody) contextValidateCertificate(ctx context.Context, formats strfmt.Registry) error {

	if o.Certificate != nil {
		if err := o.Certificate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "certificate")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyModifyCollectionBody) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if o.Error != nil {
		if err := o.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyModifyCollectionBody) contextValidateIpsecPolicyResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.IpsecPolicyResponseInlineRecords); i++ {

		if o.IpsecPolicyResponseInlineRecords[i] != nil {
			if err := o.IpsecPolicyResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IpsecPolicyModifyCollectionBody) contextValidateIpspace(ctx context.Context, formats strfmt.Registry) error {

	if o.Ipspace != nil {
		if err := o.Ipspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ipspace")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyModifyCollectionBody) contextValidateLocalEndpoint(ctx context.Context, formats strfmt.Registry) error {

	if o.LocalEndpoint != nil {
		if err := o.LocalEndpoint.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "local_endpoint")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyModifyCollectionBody) contextValidatePpk(ctx context.Context, formats strfmt.Registry) error {

	if o.Ppk != nil {
		if err := o.Ppk.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ppk")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyModifyCollectionBody) contextValidateRemoteEndpoint(ctx context.Context, formats strfmt.Registry) error {

	if o.RemoteEndpoint != nil {
		if err := o.RemoteEndpoint.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "remote_endpoint")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyModifyCollectionBody) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if o.Scope != nil {
		if err := o.Scope.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "scope")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *IpsecPolicyModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IpsecPolicyModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IpsecPolicyModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res IpsecPolicyModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
