// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// IpsecPolicyModifyReader is a Reader for the IpsecPolicyModify structure.
type IpsecPolicyModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IpsecPolicyModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewIpsecPolicyModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIpsecPolicyModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIpsecPolicyModifyOK creates a IpsecPolicyModifyOK with default headers values
func NewIpsecPolicyModifyOK() *IpsecPolicyModifyOK {
	return &IpsecPolicyModifyOK{}
}

/*
IpsecPolicyModifyOK describes a response with status code 200, with default header values.

OK
*/
type IpsecPolicyModifyOK struct {
}

// IsSuccess returns true when this ipsec policy modify o k response has a 2xx status code
func (o *IpsecPolicyModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this ipsec policy modify o k response has a 3xx status code
func (o *IpsecPolicyModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this ipsec policy modify o k response has a 4xx status code
func (o *IpsecPolicyModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this ipsec policy modify o k response has a 5xx status code
func (o *IpsecPolicyModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this ipsec policy modify o k response a status code equal to that given
func (o *IpsecPolicyModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the ipsec policy modify o k response
func (o *IpsecPolicyModifyOK) Code() int {
	return 200
}

func (o *IpsecPolicyModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /security/ipsec/policies/{uuid}][%d] ipsecPolicyModifyOK", 200)
}

func (o *IpsecPolicyModifyOK) String() string {
	return fmt.Sprintf("[PATCH /security/ipsec/policies/{uuid}][%d] ipsecPolicyModifyOK", 200)
}

func (o *IpsecPolicyModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewIpsecPolicyModifyDefault creates a IpsecPolicyModifyDefault with default headers values
func NewIpsecPolicyModifyDefault(code int) *IpsecPolicyModifyDefault {
	return &IpsecPolicyModifyDefault{
		_statusCode: code,
	}
}

/*
	IpsecPolicyModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 66257097 | Internal error. Failed to update the IPsec policy. |
| 66257099 | Only one protocol can be specified. |
| 66257100 | Only one local port can be specified. |
| 66257101 | Only one remote port can be specified. |
| 66257110 | Failed to create a policy sequencing value. |
| 66257113 | Only one local IP subnet can be specified. |
| 66257114 | Only one remote IP subnet can be specified. |
| 66257115 | Port ranges containing more than one port are not supported. |
| 66257120 | The subnet selector must be a host address (An IPv4 address with a 32-bit netmask or an IPv6 address with a 128-bit netmask). |
| 66257125 | The local_endpoint.address must be specified with local_endpoint.netmask. |
| 66257126 | The remote_endpoint.address must be specified with remote_endpoint.netmask. |
| 66257127 | The local subnet must be configured as a non-zero subnet. |
| 66257128 | Invalid ANY wildcard subnet. |
| 66257129 | A specific local or remote port number is required when the remote subnet is configured as an ANY wildcard subnet. |
| 66257131 | ESP in UDPv6 Encapsulation is not supported. |
| 66257135 | The specified certificate is not found on the SVM. |
| 66257136 | A certificate is not needed for the PSK authentication method. |
| 66257138 | Remote identity is required when using certificate verification. |
| 66257139 | Certificate with the specified UUID was not found. |
| 66257140 | Only certificates with a client or server type are supported. |
| 66257142 | Failed to create IPsec policy because the specified SVM is being migrated. |
| 66257143 | Invalid IPsec policy provided. The subnet must be non-empty. |
| 66257153 | The policy requires a post-quantum pre-shared key because ppk-identity is specified for this policy. |
| 66257154 | The policy requires a post-quantum pre-shared identity because ppk-shared-key is specified for this policy. |
| 66257199 | Not all of the nodes in the cluster are running a version that supports the IPsec feature. |
| 66257200 | The shared key does not meet required ASCII-range characters length. |
| 66257201 | Support for the feature available with effective cluster version or later. |
| 66257305 | The certificate UUID does not match the provided certificate name. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type IpsecPolicyModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this ipsec policy modify default response has a 2xx status code
func (o *IpsecPolicyModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this ipsec policy modify default response has a 3xx status code
func (o *IpsecPolicyModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this ipsec policy modify default response has a 4xx status code
func (o *IpsecPolicyModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this ipsec policy modify default response has a 5xx status code
func (o *IpsecPolicyModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this ipsec policy modify default response a status code equal to that given
func (o *IpsecPolicyModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the ipsec policy modify default response
func (o *IpsecPolicyModifyDefault) Code() int {
	return o._statusCode
}

func (o *IpsecPolicyModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/ipsec/policies/{uuid}][%d] ipsec_policy_modify default %s", o._statusCode, payload)
}

func (o *IpsecPolicyModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/ipsec/policies/{uuid}][%d] ipsec_policy_modify default %s", o._statusCode, payload)
}

func (o *IpsecPolicyModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *IpsecPolicyModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
