// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewKeyManagerAuthKeyCollectionGetParams creates a new KeyManagerAuthKeyCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewKeyManagerAuthKeyCollectionGetParams() *KeyManagerAuthKeyCollectionGetParams {
	return &KeyManagerAuthKeyCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewKeyManagerAuthKeyCollectionGetParamsWithTimeout creates a new KeyManagerAuthKeyCollectionGetParams object
// with the ability to set a timeout on a request.
func NewKeyManagerAuthKeyCollectionGetParamsWithTimeout(timeout time.Duration) *KeyManagerAuthKeyCollectionGetParams {
	return &KeyManagerAuthKeyCollectionGetParams{
		timeout: timeout,
	}
}

// NewKeyManagerAuthKeyCollectionGetParamsWithContext creates a new KeyManagerAuthKeyCollectionGetParams object
// with the ability to set a context for a request.
func NewKeyManagerAuthKeyCollectionGetParamsWithContext(ctx context.Context) *KeyManagerAuthKeyCollectionGetParams {
	return &KeyManagerAuthKeyCollectionGetParams{
		Context: ctx,
	}
}

// NewKeyManagerAuthKeyCollectionGetParamsWithHTTPClient creates a new KeyManagerAuthKeyCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewKeyManagerAuthKeyCollectionGetParamsWithHTTPClient(client *http.Client) *KeyManagerAuthKeyCollectionGetParams {
	return &KeyManagerAuthKeyCollectionGetParams{
		HTTPClient: client,
	}
}

/*
KeyManagerAuthKeyCollectionGetParams contains all the parameters to send to the API endpoint

	for the key manager auth key collection get operation.

	Typically these are written to a http.Request.
*/
type KeyManagerAuthKeyCollectionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* KeyID.

	   Filter by key_id
	*/
	KeyID *string

	/* KeyTag.

	   Filter by key_tag
	*/
	KeyTag *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SecurityKeyManagerUUID.

	   External key manager UUID
	*/
	SecurityKeyManagerUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the key manager auth key collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *KeyManagerAuthKeyCollectionGetParams) WithDefaults() *KeyManagerAuthKeyCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the key manager auth key collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *KeyManagerAuthKeyCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := KeyManagerAuthKeyCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the key manager auth key collection get params
func (o *KeyManagerAuthKeyCollectionGetParams) WithTimeout(timeout time.Duration) *KeyManagerAuthKeyCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the key manager auth key collection get params
func (o *KeyManagerAuthKeyCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the key manager auth key collection get params
func (o *KeyManagerAuthKeyCollectionGetParams) WithContext(ctx context.Context) *KeyManagerAuthKeyCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the key manager auth key collection get params
func (o *KeyManagerAuthKeyCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the key manager auth key collection get params
func (o *KeyManagerAuthKeyCollectionGetParams) WithHTTPClient(client *http.Client) *KeyManagerAuthKeyCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the key manager auth key collection get params
func (o *KeyManagerAuthKeyCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the key manager auth key collection get params
func (o *KeyManagerAuthKeyCollectionGetParams) WithFields(fields []string) *KeyManagerAuthKeyCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the key manager auth key collection get params
func (o *KeyManagerAuthKeyCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithKeyID adds the keyID to the key manager auth key collection get params
func (o *KeyManagerAuthKeyCollectionGetParams) WithKeyID(keyID *string) *KeyManagerAuthKeyCollectionGetParams {
	o.SetKeyID(keyID)
	return o
}

// SetKeyID adds the keyId to the key manager auth key collection get params
func (o *KeyManagerAuthKeyCollectionGetParams) SetKeyID(keyID *string) {
	o.KeyID = keyID
}

// WithKeyTag adds the keyTag to the key manager auth key collection get params
func (o *KeyManagerAuthKeyCollectionGetParams) WithKeyTag(keyTag *string) *KeyManagerAuthKeyCollectionGetParams {
	o.SetKeyTag(keyTag)
	return o
}

// SetKeyTag adds the keyTag to the key manager auth key collection get params
func (o *KeyManagerAuthKeyCollectionGetParams) SetKeyTag(keyTag *string) {
	o.KeyTag = keyTag
}

// WithMaxRecords adds the maxRecords to the key manager auth key collection get params
func (o *KeyManagerAuthKeyCollectionGetParams) WithMaxRecords(maxRecords *int64) *KeyManagerAuthKeyCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the key manager auth key collection get params
func (o *KeyManagerAuthKeyCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the key manager auth key collection get params
func (o *KeyManagerAuthKeyCollectionGetParams) WithOrderBy(orderBy []string) *KeyManagerAuthKeyCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the key manager auth key collection get params
func (o *KeyManagerAuthKeyCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the key manager auth key collection get params
func (o *KeyManagerAuthKeyCollectionGetParams) WithReturnRecords(returnRecords *bool) *KeyManagerAuthKeyCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the key manager auth key collection get params
func (o *KeyManagerAuthKeyCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the key manager auth key collection get params
func (o *KeyManagerAuthKeyCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *KeyManagerAuthKeyCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the key manager auth key collection get params
func (o *KeyManagerAuthKeyCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSecurityKeyManagerUUID adds the securityKeyManagerUUID to the key manager auth key collection get params
func (o *KeyManagerAuthKeyCollectionGetParams) WithSecurityKeyManagerUUID(securityKeyManagerUUID string) *KeyManagerAuthKeyCollectionGetParams {
	o.SetSecurityKeyManagerUUID(securityKeyManagerUUID)
	return o
}

// SetSecurityKeyManagerUUID adds the securityKeyManagerUuid to the key manager auth key collection get params
func (o *KeyManagerAuthKeyCollectionGetParams) SetSecurityKeyManagerUUID(securityKeyManagerUUID string) {
	o.SecurityKeyManagerUUID = securityKeyManagerUUID
}

// WriteToRequest writes these params to a swagger request
func (o *KeyManagerAuthKeyCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.KeyID != nil {

		// query param key_id
		var qrKeyID string

		if o.KeyID != nil {
			qrKeyID = *o.KeyID
		}
		qKeyID := qrKeyID
		if qKeyID != "" {

			if err := r.SetQueryParam("key_id", qKeyID); err != nil {
				return err
			}
		}
	}

	if o.KeyTag != nil {

		// query param key_tag
		var qrKeyTag string

		if o.KeyTag != nil {
			qrKeyTag = *o.KeyTag
		}
		qKeyTag := qrKeyTag
		if qKeyTag != "" {

			if err := r.SetQueryParam("key_tag", qKeyTag); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param security_key_manager.uuid
	if err := r.SetPathParam("security_key_manager.uuid", o.SecurityKeyManagerUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamKeyManagerAuthKeyCollectionGet binds the parameter fields
func (o *KeyManagerAuthKeyCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamKeyManagerAuthKeyCollectionGet binds the parameter order_by
func (o *KeyManagerAuthKeyCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
