// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewKeyManagerAuthKeyCreateParams creates a new KeyManagerAuthKeyCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewKeyManagerAuthKeyCreateParams() *KeyManagerAuthKeyCreateParams {
	return &KeyManagerAuthKeyCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewKeyManagerAuthKeyCreateParamsWithTimeout creates a new KeyManagerAuthKeyCreateParams object
// with the ability to set a timeout on a request.
func NewKeyManagerAuthKeyCreateParamsWithTimeout(timeout time.Duration) *KeyManagerAuthKeyCreateParams {
	return &KeyManagerAuthKeyCreateParams{
		timeout: timeout,
	}
}

// NewKeyManagerAuthKeyCreateParamsWithContext creates a new KeyManagerAuthKeyCreateParams object
// with the ability to set a context for a request.
func NewKeyManagerAuthKeyCreateParamsWithContext(ctx context.Context) *KeyManagerAuthKeyCreateParams {
	return &KeyManagerAuthKeyCreateParams{
		Context: ctx,
	}
}

// NewKeyManagerAuthKeyCreateParamsWithHTTPClient creates a new KeyManagerAuthKeyCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewKeyManagerAuthKeyCreateParamsWithHTTPClient(client *http.Client) *KeyManagerAuthKeyCreateParams {
	return &KeyManagerAuthKeyCreateParams{
		HTTPClient: client,
	}
}

/*
KeyManagerAuthKeyCreateParams contains all the parameters to send to the API endpoint

	for the key manager auth key create operation.

	Typically these are written to a http.Request.
*/
type KeyManagerAuthKeyCreateParams struct {

	/* Info.

	   Information specification
	*/
	Info *models.KeyManagerAuthKey

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* SecurityKeyManagerUUID.

	   External key manager UUID
	*/
	SecurityKeyManagerUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the key manager auth key create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *KeyManagerAuthKeyCreateParams) WithDefaults() *KeyManagerAuthKeyCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the key manager auth key create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *KeyManagerAuthKeyCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := KeyManagerAuthKeyCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the key manager auth key create params
func (o *KeyManagerAuthKeyCreateParams) WithTimeout(timeout time.Duration) *KeyManagerAuthKeyCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the key manager auth key create params
func (o *KeyManagerAuthKeyCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the key manager auth key create params
func (o *KeyManagerAuthKeyCreateParams) WithContext(ctx context.Context) *KeyManagerAuthKeyCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the key manager auth key create params
func (o *KeyManagerAuthKeyCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the key manager auth key create params
func (o *KeyManagerAuthKeyCreateParams) WithHTTPClient(client *http.Client) *KeyManagerAuthKeyCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the key manager auth key create params
func (o *KeyManagerAuthKeyCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the key manager auth key create params
func (o *KeyManagerAuthKeyCreateParams) WithInfo(info *models.KeyManagerAuthKey) *KeyManagerAuthKeyCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the key manager auth key create params
func (o *KeyManagerAuthKeyCreateParams) SetInfo(info *models.KeyManagerAuthKey) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the key manager auth key create params
func (o *KeyManagerAuthKeyCreateParams) WithReturnRecords(returnRecords *bool) *KeyManagerAuthKeyCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the key manager auth key create params
func (o *KeyManagerAuthKeyCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithSecurityKeyManagerUUID adds the securityKeyManagerUUID to the key manager auth key create params
func (o *KeyManagerAuthKeyCreateParams) WithSecurityKeyManagerUUID(securityKeyManagerUUID string) *KeyManagerAuthKeyCreateParams {
	o.SetSecurityKeyManagerUUID(securityKeyManagerUUID)
	return o
}

// SetSecurityKeyManagerUUID adds the securityKeyManagerUuid to the key manager auth key create params
func (o *KeyManagerAuthKeyCreateParams) SetSecurityKeyManagerUUID(securityKeyManagerUUID string) {
	o.SecurityKeyManagerUUID = securityKeyManagerUUID
}

// WriteToRequest writes these params to a swagger request
func (o *KeyManagerAuthKeyCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	// path param security_key_manager.uuid
	if err := r.SetPathParam("security_key_manager.uuid", o.SecurityKeyManagerUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
