// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewKeyManagerAuthKeyDeleteCollectionParams creates a new KeyManagerAuthKeyDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewKeyManagerAuthKeyDeleteCollectionParams() *KeyManagerAuthKeyDeleteCollectionParams {
	return &KeyManagerAuthKeyDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewKeyManagerAuthKeyDeleteCollectionParamsWithTimeout creates a new KeyManagerAuthKeyDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewKeyManagerAuthKeyDeleteCollectionParamsWithTimeout(timeout time.Duration) *KeyManagerAuthKeyDeleteCollectionParams {
	return &KeyManagerAuthKeyDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewKeyManagerAuthKeyDeleteCollectionParamsWithContext creates a new KeyManagerAuthKeyDeleteCollectionParams object
// with the ability to set a context for a request.
func NewKeyManagerAuthKeyDeleteCollectionParamsWithContext(ctx context.Context) *KeyManagerAuthKeyDeleteCollectionParams {
	return &KeyManagerAuthKeyDeleteCollectionParams{
		Context: ctx,
	}
}

// NewKeyManagerAuthKeyDeleteCollectionParamsWithHTTPClient creates a new KeyManagerAuthKeyDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewKeyManagerAuthKeyDeleteCollectionParamsWithHTTPClient(client *http.Client) *KeyManagerAuthKeyDeleteCollectionParams {
	return &KeyManagerAuthKeyDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
KeyManagerAuthKeyDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the key manager auth key delete collection operation.

	Typically these are written to a http.Request.
*/
type KeyManagerAuthKeyDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info KeyManagerAuthKeyDeleteCollectionBody

	/* KeyID.

	   Filter by key_id
	*/
	KeyID *string

	/* KeyTag.

	   Filter by key_tag
	*/
	KeyTag *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SecurityKeyManagerUUID.

	   External key manager UUID
	*/
	SecurityKeyManagerUUID string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the key manager auth key delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *KeyManagerAuthKeyDeleteCollectionParams) WithDefaults() *KeyManagerAuthKeyDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the key manager auth key delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *KeyManagerAuthKeyDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := KeyManagerAuthKeyDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the key manager auth key delete collection params
func (o *KeyManagerAuthKeyDeleteCollectionParams) WithTimeout(timeout time.Duration) *KeyManagerAuthKeyDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the key manager auth key delete collection params
func (o *KeyManagerAuthKeyDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the key manager auth key delete collection params
func (o *KeyManagerAuthKeyDeleteCollectionParams) WithContext(ctx context.Context) *KeyManagerAuthKeyDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the key manager auth key delete collection params
func (o *KeyManagerAuthKeyDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the key manager auth key delete collection params
func (o *KeyManagerAuthKeyDeleteCollectionParams) WithHTTPClient(client *http.Client) *KeyManagerAuthKeyDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the key manager auth key delete collection params
func (o *KeyManagerAuthKeyDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the key manager auth key delete collection params
func (o *KeyManagerAuthKeyDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *KeyManagerAuthKeyDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the key manager auth key delete collection params
func (o *KeyManagerAuthKeyDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the key manager auth key delete collection params
func (o *KeyManagerAuthKeyDeleteCollectionParams) WithInfo(info KeyManagerAuthKeyDeleteCollectionBody) *KeyManagerAuthKeyDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the key manager auth key delete collection params
func (o *KeyManagerAuthKeyDeleteCollectionParams) SetInfo(info KeyManagerAuthKeyDeleteCollectionBody) {
	o.Info = info
}

// WithKeyID adds the keyID to the key manager auth key delete collection params
func (o *KeyManagerAuthKeyDeleteCollectionParams) WithKeyID(keyID *string) *KeyManagerAuthKeyDeleteCollectionParams {
	o.SetKeyID(keyID)
	return o
}

// SetKeyID adds the keyId to the key manager auth key delete collection params
func (o *KeyManagerAuthKeyDeleteCollectionParams) SetKeyID(keyID *string) {
	o.KeyID = keyID
}

// WithKeyTag adds the keyTag to the key manager auth key delete collection params
func (o *KeyManagerAuthKeyDeleteCollectionParams) WithKeyTag(keyTag *string) *KeyManagerAuthKeyDeleteCollectionParams {
	o.SetKeyTag(keyTag)
	return o
}

// SetKeyTag adds the keyTag to the key manager auth key delete collection params
func (o *KeyManagerAuthKeyDeleteCollectionParams) SetKeyTag(keyTag *string) {
	o.KeyTag = keyTag
}

// WithReturnRecords adds the returnRecords to the key manager auth key delete collection params
func (o *KeyManagerAuthKeyDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *KeyManagerAuthKeyDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the key manager auth key delete collection params
func (o *KeyManagerAuthKeyDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the key manager auth key delete collection params
func (o *KeyManagerAuthKeyDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *KeyManagerAuthKeyDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the key manager auth key delete collection params
func (o *KeyManagerAuthKeyDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSecurityKeyManagerUUID adds the securityKeyManagerUUID to the key manager auth key delete collection params
func (o *KeyManagerAuthKeyDeleteCollectionParams) WithSecurityKeyManagerUUID(securityKeyManagerUUID string) *KeyManagerAuthKeyDeleteCollectionParams {
	o.SetSecurityKeyManagerUUID(securityKeyManagerUUID)
	return o
}

// SetSecurityKeyManagerUUID adds the securityKeyManagerUuid to the key manager auth key delete collection params
func (o *KeyManagerAuthKeyDeleteCollectionParams) SetSecurityKeyManagerUUID(securityKeyManagerUUID string) {
	o.SecurityKeyManagerUUID = securityKeyManagerUUID
}

// WithSerialRecords adds the serialRecords to the key manager auth key delete collection params
func (o *KeyManagerAuthKeyDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *KeyManagerAuthKeyDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the key manager auth key delete collection params
func (o *KeyManagerAuthKeyDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WriteToRequest writes these params to a swagger request
func (o *KeyManagerAuthKeyDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.KeyID != nil {

		// query param key_id
		var qrKeyID string

		if o.KeyID != nil {
			qrKeyID = *o.KeyID
		}
		qKeyID := qrKeyID
		if qKeyID != "" {

			if err := r.SetQueryParam("key_id", qKeyID); err != nil {
				return err
			}
		}
	}

	if o.KeyTag != nil {

		// query param key_tag
		var qrKeyTag string

		if o.KeyTag != nil {
			qrKeyTag = *o.KeyTag
		}
		qKeyTag := qrKeyTag
		if qKeyTag != "" {

			if err := r.SetQueryParam("key_tag", qKeyTag); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param security_key_manager.uuid
	if err := r.SetPathParam("security_key_manager.uuid", o.SecurityKeyManagerUUID); err != nil {
		return err
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
