// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// KeyManagerAuthKeyDeleteCollectionReader is a Reader for the KeyManagerAuthKeyDeleteCollection structure.
type KeyManagerAuthKeyDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *KeyManagerAuthKeyDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewKeyManagerAuthKeyDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewKeyManagerAuthKeyDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewKeyManagerAuthKeyDeleteCollectionOK creates a KeyManagerAuthKeyDeleteCollectionOK with default headers values
func NewKeyManagerAuthKeyDeleteCollectionOK() *KeyManagerAuthKeyDeleteCollectionOK {
	return &KeyManagerAuthKeyDeleteCollectionOK{}
}

/*
KeyManagerAuthKeyDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type KeyManagerAuthKeyDeleteCollectionOK struct {
}

// IsSuccess returns true when this key manager auth key delete collection o k response has a 2xx status code
func (o *KeyManagerAuthKeyDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this key manager auth key delete collection o k response has a 3xx status code
func (o *KeyManagerAuthKeyDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this key manager auth key delete collection o k response has a 4xx status code
func (o *KeyManagerAuthKeyDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this key manager auth key delete collection o k response has a 5xx status code
func (o *KeyManagerAuthKeyDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this key manager auth key delete collection o k response a status code equal to that given
func (o *KeyManagerAuthKeyDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the key manager auth key delete collection o k response
func (o *KeyManagerAuthKeyDeleteCollectionOK) Code() int {
	return 200
}

func (o *KeyManagerAuthKeyDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /security/key-managers/{security_key_manager.uuid}/auth-keys][%d] keyManagerAuthKeyDeleteCollectionOK", 200)
}

func (o *KeyManagerAuthKeyDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /security/key-managers/{security_key_manager.uuid}/auth-keys][%d] keyManagerAuthKeyDeleteCollectionOK", 200)
}

func (o *KeyManagerAuthKeyDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewKeyManagerAuthKeyDeleteCollectionDefault creates a KeyManagerAuthKeyDeleteCollectionDefault with default headers values
func NewKeyManagerAuthKeyDeleteCollectionDefault(code int) *KeyManagerAuthKeyDeleteCollectionDefault {
	return &KeyManagerAuthKeyDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	KeyManagerAuthKeyDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 65536828 | External key management is not enabled for the SVM. |
| 65536859 | Authentication key-Id provided for deletion is in use. |
| 65536860 | Key-id provided for deletion is not an authentication key. |
| 65538800 | External KMIP DKMIP keymanager not configured on administrative Vserver. |
| 65538801 | Internal error while accessing keymanager database. |
| 65538802 | The UUID provided is not associated with the administrator SVM key manager. |
| 66060296 | Failed to delete key from an external key server. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type KeyManagerAuthKeyDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this key manager auth key delete collection default response has a 2xx status code
func (o *KeyManagerAuthKeyDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this key manager auth key delete collection default response has a 3xx status code
func (o *KeyManagerAuthKeyDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this key manager auth key delete collection default response has a 4xx status code
func (o *KeyManagerAuthKeyDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this key manager auth key delete collection default response has a 5xx status code
func (o *KeyManagerAuthKeyDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this key manager auth key delete collection default response a status code equal to that given
func (o *KeyManagerAuthKeyDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the key manager auth key delete collection default response
func (o *KeyManagerAuthKeyDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *KeyManagerAuthKeyDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/key-managers/{security_key_manager.uuid}/auth-keys][%d] key_manager_auth_key_delete_collection default %s", o._statusCode, payload)
}

func (o *KeyManagerAuthKeyDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/key-managers/{security_key_manager.uuid}/auth-keys][%d] key_manager_auth_key_delete_collection default %s", o._statusCode, payload)
}

func (o *KeyManagerAuthKeyDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *KeyManagerAuthKeyDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
KeyManagerAuthKeyDeleteCollectionBody key manager auth key delete collection body
swagger:model KeyManagerAuthKeyDeleteCollectionBody
*/
type KeyManagerAuthKeyDeleteCollectionBody struct {

	// key manager auth key response inline records
	KeyManagerAuthKeyResponseInlineRecords []*models.KeyManagerAuthKey `json:"records,omitempty"`
}

// Validate validates this key manager auth key delete collection body
func (o *KeyManagerAuthKeyDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateKeyManagerAuthKeyResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *KeyManagerAuthKeyDeleteCollectionBody) validateKeyManagerAuthKeyResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.KeyManagerAuthKeyResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.KeyManagerAuthKeyResponseInlineRecords); i++ {
		if swag.IsZero(o.KeyManagerAuthKeyResponseInlineRecords[i]) { // not required
			continue
		}

		if o.KeyManagerAuthKeyResponseInlineRecords[i] != nil {
			if err := o.KeyManagerAuthKeyResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this key manager auth key delete collection body based on the context it is used
func (o *KeyManagerAuthKeyDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateKeyManagerAuthKeyResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *KeyManagerAuthKeyDeleteCollectionBody) contextValidateKeyManagerAuthKeyResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.KeyManagerAuthKeyResponseInlineRecords); i++ {

		if o.KeyManagerAuthKeyResponseInlineRecords[i] != nil {
			if err := o.KeyManagerAuthKeyResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *KeyManagerAuthKeyDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *KeyManagerAuthKeyDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res KeyManagerAuthKeyDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
