// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewKeyManagerAuthKeyDeleteParams creates a new KeyManagerAuthKeyDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewKeyManagerAuthKeyDeleteParams() *KeyManagerAuthKeyDeleteParams {
	return &KeyManagerAuthKeyDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewKeyManagerAuthKeyDeleteParamsWithTimeout creates a new KeyManagerAuthKeyDeleteParams object
// with the ability to set a timeout on a request.
func NewKeyManagerAuthKeyDeleteParamsWithTimeout(timeout time.Duration) *KeyManagerAuthKeyDeleteParams {
	return &KeyManagerAuthKeyDeleteParams{
		timeout: timeout,
	}
}

// NewKeyManagerAuthKeyDeleteParamsWithContext creates a new KeyManagerAuthKeyDeleteParams object
// with the ability to set a context for a request.
func NewKeyManagerAuthKeyDeleteParamsWithContext(ctx context.Context) *KeyManagerAuthKeyDeleteParams {
	return &KeyManagerAuthKeyDeleteParams{
		Context: ctx,
	}
}

// NewKeyManagerAuthKeyDeleteParamsWithHTTPClient creates a new KeyManagerAuthKeyDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewKeyManagerAuthKeyDeleteParamsWithHTTPClient(client *http.Client) *KeyManagerAuthKeyDeleteParams {
	return &KeyManagerAuthKeyDeleteParams{
		HTTPClient: client,
	}
}

/*
KeyManagerAuthKeyDeleteParams contains all the parameters to send to the API endpoint

	for the key manager auth key delete operation.

	Typically these are written to a http.Request.
*/
type KeyManagerAuthKeyDeleteParams struct {

	/* KeyID.

	   Key ID of the authentication key to be deleted.
	*/
	KeyID string

	/* SecurityKeyManagerUUID.

	   External key manager UUID
	*/
	SecurityKeyManagerUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the key manager auth key delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *KeyManagerAuthKeyDeleteParams) WithDefaults() *KeyManagerAuthKeyDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the key manager auth key delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *KeyManagerAuthKeyDeleteParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the key manager auth key delete params
func (o *KeyManagerAuthKeyDeleteParams) WithTimeout(timeout time.Duration) *KeyManagerAuthKeyDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the key manager auth key delete params
func (o *KeyManagerAuthKeyDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the key manager auth key delete params
func (o *KeyManagerAuthKeyDeleteParams) WithContext(ctx context.Context) *KeyManagerAuthKeyDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the key manager auth key delete params
func (o *KeyManagerAuthKeyDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the key manager auth key delete params
func (o *KeyManagerAuthKeyDeleteParams) WithHTTPClient(client *http.Client) *KeyManagerAuthKeyDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the key manager auth key delete params
func (o *KeyManagerAuthKeyDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithKeyID adds the keyID to the key manager auth key delete params
func (o *KeyManagerAuthKeyDeleteParams) WithKeyID(keyID string) *KeyManagerAuthKeyDeleteParams {
	o.SetKeyID(keyID)
	return o
}

// SetKeyID adds the keyId to the key manager auth key delete params
func (o *KeyManagerAuthKeyDeleteParams) SetKeyID(keyID string) {
	o.KeyID = keyID
}

// WithSecurityKeyManagerUUID adds the securityKeyManagerUUID to the key manager auth key delete params
func (o *KeyManagerAuthKeyDeleteParams) WithSecurityKeyManagerUUID(securityKeyManagerUUID string) *KeyManagerAuthKeyDeleteParams {
	o.SetSecurityKeyManagerUUID(securityKeyManagerUUID)
	return o
}

// SetSecurityKeyManagerUUID adds the securityKeyManagerUuid to the key manager auth key delete params
func (o *KeyManagerAuthKeyDeleteParams) SetSecurityKeyManagerUUID(securityKeyManagerUUID string) {
	o.SecurityKeyManagerUUID = securityKeyManagerUUID
}

// WriteToRequest writes these params to a swagger request
func (o *KeyManagerAuthKeyDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param key_id
	if err := r.SetPathParam("key_id", o.KeyID); err != nil {
		return err
	}

	// path param security_key_manager.uuid
	if err := r.SetPathParam("security_key_manager.uuid", o.SecurityKeyManagerUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
