// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewKeyManagerKeysCollectionGetParams creates a new KeyManagerKeysCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewKeyManagerKeysCollectionGetParams() *KeyManagerKeysCollectionGetParams {
	return &KeyManagerKeysCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewKeyManagerKeysCollectionGetParamsWithTimeout creates a new KeyManagerKeysCollectionGetParams object
// with the ability to set a timeout on a request.
func NewKeyManagerKeysCollectionGetParamsWithTimeout(timeout time.Duration) *KeyManagerKeysCollectionGetParams {
	return &KeyManagerKeysCollectionGetParams{
		timeout: timeout,
	}
}

// NewKeyManagerKeysCollectionGetParamsWithContext creates a new KeyManagerKeysCollectionGetParams object
// with the ability to set a context for a request.
func NewKeyManagerKeysCollectionGetParamsWithContext(ctx context.Context) *KeyManagerKeysCollectionGetParams {
	return &KeyManagerKeysCollectionGetParams{
		Context: ctx,
	}
}

// NewKeyManagerKeysCollectionGetParamsWithHTTPClient creates a new KeyManagerKeysCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewKeyManagerKeysCollectionGetParamsWithHTTPClient(client *http.Client) *KeyManagerKeysCollectionGetParams {
	return &KeyManagerKeysCollectionGetParams{
		HTTPClient: client,
	}
}

/*
KeyManagerKeysCollectionGetParams contains all the parameters to send to the API endpoint

	for the key manager keys collection get operation.

	Typically these are written to a http.Request.
*/
type KeyManagerKeysCollectionGetParams struct {

	/* Crn.

	   Filter by crn
	*/
	Crn *string

	/* EncryptionAlgorithm.

	   Filter by encryption_algorithm
	*/
	EncryptionAlgorithm *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* KeyID.

	   Filter by key_id
	*/
	KeyID *string

	/* KeyManager.

	   Filter by key_manager
	*/
	KeyManager *string

	/* KeyServer.

	   Filter by key_server
	*/
	KeyServer *string

	/* KeyStore.

	   Filter by key_store
	*/
	KeyStore *string

	/* KeyStoreType.

	   Filter by key_store_type
	*/
	KeyStoreType *string

	/* KeyTag.

	   Filter by key_tag
	*/
	KeyTag *string

	/* KeyType.

	   Filter by key_type
	*/
	KeyType *string

	/* KeyUser.

	   Filter by key_user
	*/
	KeyUser *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Node UUID.
	*/
	NodeUUID string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* Policy.

	   Filter by policy
	*/
	Policy *string

	/* Restored.

	   Filter by restored
	*/
	Restored *bool

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SecurityKeyManagerUUID.

	   Key manager UUID.
	*/
	SecurityKeyManagerUUID string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the key manager keys collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *KeyManagerKeysCollectionGetParams) WithDefaults() *KeyManagerKeysCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the key manager keys collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *KeyManagerKeysCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := KeyManagerKeysCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) WithTimeout(timeout time.Duration) *KeyManagerKeysCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) WithContext(ctx context.Context) *KeyManagerKeysCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) WithHTTPClient(client *http.Client) *KeyManagerKeysCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCrn adds the crn to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) WithCrn(crn *string) *KeyManagerKeysCollectionGetParams {
	o.SetCrn(crn)
	return o
}

// SetCrn adds the crn to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) SetCrn(crn *string) {
	o.Crn = crn
}

// WithEncryptionAlgorithm adds the encryptionAlgorithm to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) WithEncryptionAlgorithm(encryptionAlgorithm *string) *KeyManagerKeysCollectionGetParams {
	o.SetEncryptionAlgorithm(encryptionAlgorithm)
	return o
}

// SetEncryptionAlgorithm adds the encryptionAlgorithm to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) SetEncryptionAlgorithm(encryptionAlgorithm *string) {
	o.EncryptionAlgorithm = encryptionAlgorithm
}

// WithFields adds the fields to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) WithFields(fields []string) *KeyManagerKeysCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithKeyID adds the keyID to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) WithKeyID(keyID *string) *KeyManagerKeysCollectionGetParams {
	o.SetKeyID(keyID)
	return o
}

// SetKeyID adds the keyId to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) SetKeyID(keyID *string) {
	o.KeyID = keyID
}

// WithKeyManager adds the keyManager to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) WithKeyManager(keyManager *string) *KeyManagerKeysCollectionGetParams {
	o.SetKeyManager(keyManager)
	return o
}

// SetKeyManager adds the keyManager to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) SetKeyManager(keyManager *string) {
	o.KeyManager = keyManager
}

// WithKeyServer adds the keyServer to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) WithKeyServer(keyServer *string) *KeyManagerKeysCollectionGetParams {
	o.SetKeyServer(keyServer)
	return o
}

// SetKeyServer adds the keyServer to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) SetKeyServer(keyServer *string) {
	o.KeyServer = keyServer
}

// WithKeyStore adds the keyStore to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) WithKeyStore(keyStore *string) *KeyManagerKeysCollectionGetParams {
	o.SetKeyStore(keyStore)
	return o
}

// SetKeyStore adds the keyStore to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) SetKeyStore(keyStore *string) {
	o.KeyStore = keyStore
}

// WithKeyStoreType adds the keyStoreType to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) WithKeyStoreType(keyStoreType *string) *KeyManagerKeysCollectionGetParams {
	o.SetKeyStoreType(keyStoreType)
	return o
}

// SetKeyStoreType adds the keyStoreType to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) SetKeyStoreType(keyStoreType *string) {
	o.KeyStoreType = keyStoreType
}

// WithKeyTag adds the keyTag to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) WithKeyTag(keyTag *string) *KeyManagerKeysCollectionGetParams {
	o.SetKeyTag(keyTag)
	return o
}

// SetKeyTag adds the keyTag to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) SetKeyTag(keyTag *string) {
	o.KeyTag = keyTag
}

// WithKeyType adds the keyType to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) WithKeyType(keyType *string) *KeyManagerKeysCollectionGetParams {
	o.SetKeyType(keyType)
	return o
}

// SetKeyType adds the keyType to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) SetKeyType(keyType *string) {
	o.KeyType = keyType
}

// WithKeyUser adds the keyUser to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) WithKeyUser(keyUser *string) *KeyManagerKeysCollectionGetParams {
	o.SetKeyUser(keyUser)
	return o
}

// SetKeyUser adds the keyUser to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) SetKeyUser(keyUser *string) {
	o.KeyUser = keyUser
}

// WithMaxRecords adds the maxRecords to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) WithMaxRecords(maxRecords *int64) *KeyManagerKeysCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithNodeName adds the nodeName to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) WithNodeName(nodeName *string) *KeyManagerKeysCollectionGetParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) WithNodeUUID(nodeUUID string) *KeyManagerKeysCollectionGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) SetNodeUUID(nodeUUID string) {
	o.NodeUUID = nodeUUID
}

// WithOrderBy adds the orderBy to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) WithOrderBy(orderBy []string) *KeyManagerKeysCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPolicy adds the policy to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) WithPolicy(policy *string) *KeyManagerKeysCollectionGetParams {
	o.SetPolicy(policy)
	return o
}

// SetPolicy adds the policy to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) SetPolicy(policy *string) {
	o.Policy = policy
}

// WithRestored adds the restored to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) WithRestored(restored *bool) *KeyManagerKeysCollectionGetParams {
	o.SetRestored(restored)
	return o
}

// SetRestored adds the restored to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) SetRestored(restored *bool) {
	o.Restored = restored
}

// WithReturnRecords adds the returnRecords to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) WithReturnRecords(returnRecords *bool) *KeyManagerKeysCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *KeyManagerKeysCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) WithScope(scope *string) *KeyManagerKeysCollectionGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSecurityKeyManagerUUID adds the securityKeyManagerUUID to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) WithSecurityKeyManagerUUID(securityKeyManagerUUID string) *KeyManagerKeysCollectionGetParams {
	o.SetSecurityKeyManagerUUID(securityKeyManagerUUID)
	return o
}

// SetSecurityKeyManagerUUID adds the securityKeyManagerUuid to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) SetSecurityKeyManagerUUID(securityKeyManagerUUID string) {
	o.SecurityKeyManagerUUID = securityKeyManagerUUID
}

// WithSvmName adds the svmName to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) WithSvmName(svmName *string) *KeyManagerKeysCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) WithSvmUUID(svmUUID *string) *KeyManagerKeysCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the key manager keys collection get params
func (o *KeyManagerKeysCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *KeyManagerKeysCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Crn != nil {

		// query param crn
		var qrCrn string

		if o.Crn != nil {
			qrCrn = *o.Crn
		}
		qCrn := qrCrn
		if qCrn != "" {

			if err := r.SetQueryParam("crn", qCrn); err != nil {
				return err
			}
		}
	}

	if o.EncryptionAlgorithm != nil {

		// query param encryption_algorithm
		var qrEncryptionAlgorithm string

		if o.EncryptionAlgorithm != nil {
			qrEncryptionAlgorithm = *o.EncryptionAlgorithm
		}
		qEncryptionAlgorithm := qrEncryptionAlgorithm
		if qEncryptionAlgorithm != "" {

			if err := r.SetQueryParam("encryption_algorithm", qEncryptionAlgorithm); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.KeyID != nil {

		// query param key_id
		var qrKeyID string

		if o.KeyID != nil {
			qrKeyID = *o.KeyID
		}
		qKeyID := qrKeyID
		if qKeyID != "" {

			if err := r.SetQueryParam("key_id", qKeyID); err != nil {
				return err
			}
		}
	}

	if o.KeyManager != nil {

		// query param key_manager
		var qrKeyManager string

		if o.KeyManager != nil {
			qrKeyManager = *o.KeyManager
		}
		qKeyManager := qrKeyManager
		if qKeyManager != "" {

			if err := r.SetQueryParam("key_manager", qKeyManager); err != nil {
				return err
			}
		}
	}

	if o.KeyServer != nil {

		// query param key_server
		var qrKeyServer string

		if o.KeyServer != nil {
			qrKeyServer = *o.KeyServer
		}
		qKeyServer := qrKeyServer
		if qKeyServer != "" {

			if err := r.SetQueryParam("key_server", qKeyServer); err != nil {
				return err
			}
		}
	}

	if o.KeyStore != nil {

		// query param key_store
		var qrKeyStore string

		if o.KeyStore != nil {
			qrKeyStore = *o.KeyStore
		}
		qKeyStore := qrKeyStore
		if qKeyStore != "" {

			if err := r.SetQueryParam("key_store", qKeyStore); err != nil {
				return err
			}
		}
	}

	if o.KeyStoreType != nil {

		// query param key_store_type
		var qrKeyStoreType string

		if o.KeyStoreType != nil {
			qrKeyStoreType = *o.KeyStoreType
		}
		qKeyStoreType := qrKeyStoreType
		if qKeyStoreType != "" {

			if err := r.SetQueryParam("key_store_type", qKeyStoreType); err != nil {
				return err
			}
		}
	}

	if o.KeyTag != nil {

		// query param key_tag
		var qrKeyTag string

		if o.KeyTag != nil {
			qrKeyTag = *o.KeyTag
		}
		qKeyTag := qrKeyTag
		if qKeyTag != "" {

			if err := r.SetQueryParam("key_tag", qKeyTag); err != nil {
				return err
			}
		}
	}

	if o.KeyType != nil {

		// query param key_type
		var qrKeyType string

		if o.KeyType != nil {
			qrKeyType = *o.KeyType
		}
		qKeyType := qrKeyType
		if qKeyType != "" {

			if err := r.SetQueryParam("key_type", qKeyType); err != nil {
				return err
			}
		}
	}

	if o.KeyUser != nil {

		// query param key_user
		var qrKeyUser string

		if o.KeyUser != nil {
			qrKeyUser = *o.KeyUser
		}
		qKeyUser := qrKeyUser
		if qKeyUser != "" {

			if err := r.SetQueryParam("key_user", qKeyUser); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	// path param node.uuid
	if err := r.SetPathParam("node.uuid", o.NodeUUID); err != nil {
		return err
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.Policy != nil {

		// query param policy
		var qrPolicy string

		if o.Policy != nil {
			qrPolicy = *o.Policy
		}
		qPolicy := qrPolicy
		if qPolicy != "" {

			if err := r.SetQueryParam("policy", qPolicy); err != nil {
				return err
			}
		}
	}

	if o.Restored != nil {

		// query param restored
		var qrRestored bool

		if o.Restored != nil {
			qrRestored = *o.Restored
		}
		qRestored := swag.FormatBool(qrRestored)
		if qRestored != "" {

			if err := r.SetQueryParam("restored", qRestored); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	// path param security_key_manager.uuid
	if err := r.SetPathParam("security_key_manager.uuid", o.SecurityKeyManagerUUID); err != nil {
		return err
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamKeyManagerKeysCollectionGet binds the parameter fields
func (o *KeyManagerKeysCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamKeyManagerKeysCollectionGet binds the parameter order_by
func (o *KeyManagerKeysCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
