// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewKeyManagerKeysGetParams creates a new KeyManagerKeysGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewKeyManagerKeysGetParams() *KeyManagerKeysGetParams {
	return &KeyManagerKeysGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewKeyManagerKeysGetParamsWithTimeout creates a new KeyManagerKeysGetParams object
// with the ability to set a timeout on a request.
func NewKeyManagerKeysGetParamsWithTimeout(timeout time.Duration) *KeyManagerKeysGetParams {
	return &KeyManagerKeysGetParams{
		timeout: timeout,
	}
}

// NewKeyManagerKeysGetParamsWithContext creates a new KeyManagerKeysGetParams object
// with the ability to set a context for a request.
func NewKeyManagerKeysGetParamsWithContext(ctx context.Context) *KeyManagerKeysGetParams {
	return &KeyManagerKeysGetParams{
		Context: ctx,
	}
}

// NewKeyManagerKeysGetParamsWithHTTPClient creates a new KeyManagerKeysGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewKeyManagerKeysGetParamsWithHTTPClient(client *http.Client) *KeyManagerKeysGetParams {
	return &KeyManagerKeysGetParams{
		HTTPClient: client,
	}
}

/*
KeyManagerKeysGetParams contains all the parameters to send to the API endpoint

	for the key manager keys get operation.

	Typically these are written to a http.Request.
*/
type KeyManagerKeysGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* KeyID.

	   Key identifier.
	*/
	KeyID string

	/* NodeUUID.

	   Node UUID.
	*/
	NodeUUID string

	/* SecurityKeyManagerUUID.

	   Key manager UUID.
	*/
	SecurityKeyManagerUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the key manager keys get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *KeyManagerKeysGetParams) WithDefaults() *KeyManagerKeysGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the key manager keys get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *KeyManagerKeysGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the key manager keys get params
func (o *KeyManagerKeysGetParams) WithTimeout(timeout time.Duration) *KeyManagerKeysGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the key manager keys get params
func (o *KeyManagerKeysGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the key manager keys get params
func (o *KeyManagerKeysGetParams) WithContext(ctx context.Context) *KeyManagerKeysGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the key manager keys get params
func (o *KeyManagerKeysGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the key manager keys get params
func (o *KeyManagerKeysGetParams) WithHTTPClient(client *http.Client) *KeyManagerKeysGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the key manager keys get params
func (o *KeyManagerKeysGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the key manager keys get params
func (o *KeyManagerKeysGetParams) WithFields(fields []string) *KeyManagerKeysGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the key manager keys get params
func (o *KeyManagerKeysGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithKeyID adds the keyID to the key manager keys get params
func (o *KeyManagerKeysGetParams) WithKeyID(keyID string) *KeyManagerKeysGetParams {
	o.SetKeyID(keyID)
	return o
}

// SetKeyID adds the keyId to the key manager keys get params
func (o *KeyManagerKeysGetParams) SetKeyID(keyID string) {
	o.KeyID = keyID
}

// WithNodeUUID adds the nodeUUID to the key manager keys get params
func (o *KeyManagerKeysGetParams) WithNodeUUID(nodeUUID string) *KeyManagerKeysGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the key manager keys get params
func (o *KeyManagerKeysGetParams) SetNodeUUID(nodeUUID string) {
	o.NodeUUID = nodeUUID
}

// WithSecurityKeyManagerUUID adds the securityKeyManagerUUID to the key manager keys get params
func (o *KeyManagerKeysGetParams) WithSecurityKeyManagerUUID(securityKeyManagerUUID string) *KeyManagerKeysGetParams {
	o.SetSecurityKeyManagerUUID(securityKeyManagerUUID)
	return o
}

// SetSecurityKeyManagerUUID adds the securityKeyManagerUuid to the key manager keys get params
func (o *KeyManagerKeysGetParams) SetSecurityKeyManagerUUID(securityKeyManagerUUID string) {
	o.SecurityKeyManagerUUID = securityKeyManagerUUID
}

// WriteToRequest writes these params to a swagger request
func (o *KeyManagerKeysGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param key_id
	if err := r.SetPathParam("key_id", o.KeyID); err != nil {
		return err
	}

	// path param node.uuid
	if err := r.SetPathParam("node.uuid", o.NodeUUID); err != nil {
		return err
	}

	// path param security_key_manager.uuid
	if err := r.SetPathParam("security_key_manager.uuid", o.SecurityKeyManagerUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamKeyManagerKeysGet binds the parameter fields
func (o *KeyManagerKeysGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
