// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewLoginMessagesCollectionGetParams creates a new LoginMessagesCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewLoginMessagesCollectionGetParams() *LoginMessagesCollectionGetParams {
	return &LoginMessagesCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewLoginMessagesCollectionGetParamsWithTimeout creates a new LoginMessagesCollectionGetParams object
// with the ability to set a timeout on a request.
func NewLoginMessagesCollectionGetParamsWithTimeout(timeout time.Duration) *LoginMessagesCollectionGetParams {
	return &LoginMessagesCollectionGetParams{
		timeout: timeout,
	}
}

// NewLoginMessagesCollectionGetParamsWithContext creates a new LoginMessagesCollectionGetParams object
// with the ability to set a context for a request.
func NewLoginMessagesCollectionGetParamsWithContext(ctx context.Context) *LoginMessagesCollectionGetParams {
	return &LoginMessagesCollectionGetParams{
		Context: ctx,
	}
}

// NewLoginMessagesCollectionGetParamsWithHTTPClient creates a new LoginMessagesCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewLoginMessagesCollectionGetParamsWithHTTPClient(client *http.Client) *LoginMessagesCollectionGetParams {
	return &LoginMessagesCollectionGetParams{
		HTTPClient: client,
	}
}

/*
LoginMessagesCollectionGetParams contains all the parameters to send to the API endpoint

	for the login messages collection get operation.

	Typically these are written to a http.Request.
*/
type LoginMessagesCollectionGetParams struct {

	/* Banner.

	   Filter by banner
	*/
	Banner *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Message.

	   Filter by message
	*/
	Message *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* ShowClusterMessage.

	   Filter by show_cluster_message
	*/
	ShowClusterMessage *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the login messages collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LoginMessagesCollectionGetParams) WithDefaults() *LoginMessagesCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the login messages collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LoginMessagesCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := LoginMessagesCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) WithTimeout(timeout time.Duration) *LoginMessagesCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) WithContext(ctx context.Context) *LoginMessagesCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) WithHTTPClient(client *http.Client) *LoginMessagesCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBanner adds the banner to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) WithBanner(banner *string) *LoginMessagesCollectionGetParams {
	o.SetBanner(banner)
	return o
}

// SetBanner adds the banner to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) SetBanner(banner *string) {
	o.Banner = banner
}

// WithFields adds the fields to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) WithFields(fields []string) *LoginMessagesCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) WithMaxRecords(maxRecords *int64) *LoginMessagesCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithMessage adds the message to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) WithMessage(message *string) *LoginMessagesCollectionGetParams {
	o.SetMessage(message)
	return o
}

// SetMessage adds the message to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) SetMessage(message *string) {
	o.Message = message
}

// WithOrderBy adds the orderBy to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) WithOrderBy(orderBy []string) *LoginMessagesCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) WithReturnRecords(returnRecords *bool) *LoginMessagesCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *LoginMessagesCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) WithScope(scope *string) *LoginMessagesCollectionGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithShowClusterMessage adds the showClusterMessage to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) WithShowClusterMessage(showClusterMessage *bool) *LoginMessagesCollectionGetParams {
	o.SetShowClusterMessage(showClusterMessage)
	return o
}

// SetShowClusterMessage adds the showClusterMessage to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) SetShowClusterMessage(showClusterMessage *bool) {
	o.ShowClusterMessage = showClusterMessage
}

// WithSvmName adds the svmName to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) WithSvmName(svmName *string) *LoginMessagesCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) WithSvmUUID(svmUUID *string) *LoginMessagesCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) WithUUID(uuid *string) *LoginMessagesCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the login messages collection get params
func (o *LoginMessagesCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *LoginMessagesCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Banner != nil {

		// query param banner
		var qrBanner string

		if o.Banner != nil {
			qrBanner = *o.Banner
		}
		qBanner := qrBanner
		if qBanner != "" {

			if err := r.SetQueryParam("banner", qBanner); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Message != nil {

		// query param message
		var qrMessage string

		if o.Message != nil {
			qrMessage = *o.Message
		}
		qMessage := qrMessage
		if qMessage != "" {

			if err := r.SetQueryParam("message", qMessage); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.ShowClusterMessage != nil {

		// query param show_cluster_message
		var qrShowClusterMessage bool

		if o.ShowClusterMessage != nil {
			qrShowClusterMessage = *o.ShowClusterMessage
		}
		qShowClusterMessage := swag.FormatBool(qrShowClusterMessage)
		if qShowClusterMessage != "" {

			if err := r.SetQueryParam("show_cluster_message", qShowClusterMessage); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamLoginMessagesCollectionGet binds the parameter fields
func (o *LoginMessagesCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamLoginMessagesCollectionGet binds the parameter order_by
func (o *LoginMessagesCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
