// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LoginMessagesCollectionGetReader is a Reader for the LoginMessagesCollectionGet structure.
type LoginMessagesCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LoginMessagesCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLoginMessagesCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLoginMessagesCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLoginMessagesCollectionGetOK creates a LoginMessagesCollectionGetOK with default headers values
func NewLoginMessagesCollectionGetOK() *LoginMessagesCollectionGetOK {
	return &LoginMessagesCollectionGetOK{}
}

/*
LoginMessagesCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type LoginMessagesCollectionGetOK struct {
	Payload *models.LoginMessagesResponse
}

// IsSuccess returns true when this login messages collection get o k response has a 2xx status code
func (o *LoginMessagesCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this login messages collection get o k response has a 3xx status code
func (o *LoginMessagesCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this login messages collection get o k response has a 4xx status code
func (o *LoginMessagesCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this login messages collection get o k response has a 5xx status code
func (o *LoginMessagesCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this login messages collection get o k response a status code equal to that given
func (o *LoginMessagesCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the login messages collection get o k response
func (o *LoginMessagesCollectionGetOK) Code() int {
	return 200
}

func (o *LoginMessagesCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/login/messages][%d] loginMessagesCollectionGetOK %s", 200, payload)
}

func (o *LoginMessagesCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/login/messages][%d] loginMessagesCollectionGetOK %s", 200, payload)
}

func (o *LoginMessagesCollectionGetOK) GetPayload() *models.LoginMessagesResponse {
	return o.Payload
}

func (o *LoginMessagesCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LoginMessagesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewLoginMessagesCollectionGetDefault creates a LoginMessagesCollectionGetDefault with default headers values
func NewLoginMessagesCollectionGetDefault(code int) *LoginMessagesCollectionGetDefault {
	return &LoginMessagesCollectionGetDefault{
		_statusCode: code,
	}
}

/*
LoginMessagesCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type LoginMessagesCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this login messages collection get default response has a 2xx status code
func (o *LoginMessagesCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this login messages collection get default response has a 3xx status code
func (o *LoginMessagesCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this login messages collection get default response has a 4xx status code
func (o *LoginMessagesCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this login messages collection get default response has a 5xx status code
func (o *LoginMessagesCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this login messages collection get default response a status code equal to that given
func (o *LoginMessagesCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the login messages collection get default response
func (o *LoginMessagesCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *LoginMessagesCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/login/messages][%d] login_messages_collection_get default %s", o._statusCode, payload)
}

func (o *LoginMessagesCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/login/messages][%d] login_messages_collection_get default %s", o._statusCode, payload)
}

func (o *LoginMessagesCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LoginMessagesCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
