// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LoginMessagesGetReader is a Reader for the LoginMessagesGet structure.
type LoginMessagesGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LoginMessagesGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLoginMessagesGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLoginMessagesGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLoginMessagesGetOK creates a LoginMessagesGetOK with default headers values
func NewLoginMessagesGetOK() *LoginMessagesGetOK {
	return &LoginMessagesGetOK{}
}

/*
LoginMessagesGetOK describes a response with status code 200, with default header values.

OK
*/
type LoginMessagesGetOK struct {
	Payload *models.LoginMessages
}

// IsSuccess returns true when this login messages get o k response has a 2xx status code
func (o *LoginMessagesGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this login messages get o k response has a 3xx status code
func (o *LoginMessagesGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this login messages get o k response has a 4xx status code
func (o *LoginMessagesGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this login messages get o k response has a 5xx status code
func (o *LoginMessagesGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this login messages get o k response a status code equal to that given
func (o *LoginMessagesGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the login messages get o k response
func (o *LoginMessagesGetOK) Code() int {
	return 200
}

func (o *LoginMessagesGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/login/messages/{uuid}][%d] loginMessagesGetOK %s", 200, payload)
}

func (o *LoginMessagesGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/login/messages/{uuid}][%d] loginMessagesGetOK %s", 200, payload)
}

func (o *LoginMessagesGetOK) GetPayload() *models.LoginMessages {
	return o.Payload
}

func (o *LoginMessagesGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LoginMessages)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewLoginMessagesGetDefault creates a LoginMessagesGetDefault with default headers values
func NewLoginMessagesGetDefault(code int) *LoginMessagesGetDefault {
	return &LoginMessagesGetDefault{
		_statusCode: code,
	}
}

/*
LoginMessagesGetDefault describes a response with status code -1, with default header values.

Error
*/
type LoginMessagesGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this login messages get default response has a 2xx status code
func (o *LoginMessagesGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this login messages get default response has a 3xx status code
func (o *LoginMessagesGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this login messages get default response has a 4xx status code
func (o *LoginMessagesGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this login messages get default response has a 5xx status code
func (o *LoginMessagesGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this login messages get default response a status code equal to that given
func (o *LoginMessagesGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the login messages get default response
func (o *LoginMessagesGetDefault) Code() int {
	return o._statusCode
}

func (o *LoginMessagesGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/login/messages/{uuid}][%d] login_messages_get default %s", o._statusCode, payload)
}

func (o *LoginMessagesGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/login/messages/{uuid}][%d] login_messages_get default %s", o._statusCode, payload)
}

func (o *LoginMessagesGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LoginMessagesGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
