// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LoginMessagesModifyCollectionReader is a Reader for the LoginMessagesModifyCollection structure.
type LoginMessagesModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LoginMessagesModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLoginMessagesModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLoginMessagesModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLoginMessagesModifyCollectionOK creates a LoginMessagesModifyCollectionOK with default headers values
func NewLoginMessagesModifyCollectionOK() *LoginMessagesModifyCollectionOK {
	return &LoginMessagesModifyCollectionOK{}
}

/*
LoginMessagesModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type LoginMessagesModifyCollectionOK struct {
}

// IsSuccess returns true when this login messages modify collection o k response has a 2xx status code
func (o *LoginMessagesModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this login messages modify collection o k response has a 3xx status code
func (o *LoginMessagesModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this login messages modify collection o k response has a 4xx status code
func (o *LoginMessagesModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this login messages modify collection o k response has a 5xx status code
func (o *LoginMessagesModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this login messages modify collection o k response a status code equal to that given
func (o *LoginMessagesModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the login messages modify collection o k response
func (o *LoginMessagesModifyCollectionOK) Code() int {
	return 200
}

func (o *LoginMessagesModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /security/login/messages][%d] loginMessagesModifyCollectionOK", 200)
}

func (o *LoginMessagesModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /security/login/messages][%d] loginMessagesModifyCollectionOK", 200)
}

func (o *LoginMessagesModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewLoginMessagesModifyCollectionDefault creates a LoginMessagesModifyCollectionDefault with default headers values
func NewLoginMessagesModifyCollectionDefault(code int) *LoginMessagesModifyCollectionDefault {
	return &LoginMessagesModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	LoginMessagesModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error codes | Description |
| ----------- | ----------- |
| 10225636    | Only a cluster administrator can modify the `show_cluster_message` property. |
*/
type LoginMessagesModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this login messages modify collection default response has a 2xx status code
func (o *LoginMessagesModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this login messages modify collection default response has a 3xx status code
func (o *LoginMessagesModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this login messages modify collection default response has a 4xx status code
func (o *LoginMessagesModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this login messages modify collection default response has a 5xx status code
func (o *LoginMessagesModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this login messages modify collection default response a status code equal to that given
func (o *LoginMessagesModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the login messages modify collection default response
func (o *LoginMessagesModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *LoginMessagesModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/login/messages][%d] login_messages_modify_collection default %s", o._statusCode, payload)
}

func (o *LoginMessagesModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/login/messages][%d] login_messages_modify_collection default %s", o._statusCode, payload)
}

func (o *LoginMessagesModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LoginMessagesModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
LoginMessagesModifyCollectionBody login messages modify collection body
swagger:model LoginMessagesModifyCollectionBody
*/
type LoginMessagesModifyCollectionBody struct {

	// links
	Links *models.LoginMessagesInlineLinks `json:"_links,omitempty"`

	// The login banner text. This message is displayed during SSH and console device
	// login just before the password prompt displays. When configured, a cluster-level
	// login banner is used for every incoming connection. Each data SVM can override
	// the cluster-level banner to instead display when you log into the SVM. To restore
	// the default setting for a data SVM, set the banner to an empty string.
	// New lines are supplied as either LF or CRLF but are always returned as LF.
	// Optional in the PATCH body.
	//
	// Max Length: 2048
	// Min Length: 0
	Banner *string `json:"banner,omitempty"`

	// login messages response inline records
	LoginMessagesResponseInlineRecords []*models.LoginMessages `json:"records,omitempty"`

	// The message of the day (MOTD). This message appears just before the clustershell
	// prompt after a successful login. When configured, the cluster message
	// displays first. If you log in as a data SVM administrator, the
	// SVM message is then printed. The cluster-level MOTD can be disabled
	// for a given data SVM using the "show_cluster_message" property.
	// New lines are supplied as either LF or CRLF but are always returned as LF.
	// Optional in the PATCH body.
	//
	// Max Length: 2048
	// Min Length: 0
	Message *string `json:"message,omitempty"`

	// Set to "svm" for interfaces owned by an SVM. Otherwise, set to "cluster".
	// Read Only: true
	// Enum: ["svm","cluster"]
	Scope *string `json:"scope,omitempty"`

	// Specifies whether to show a cluster-level message before the SVM message
	// when logging in as an SVM administrator.
	// This setting can only be modified by cluster administrators.
	// Optional in the PATCH body.
	//
	ShowClusterMessage *bool `json:"show_cluster_message,omitempty"`

	// svm
	Svm *models.LoginMessagesInlineSvm `json:"svm,omitempty"`

	// The unique identifier (ID) of the login messages configuration.
	//
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this login messages modify collection body
func (o *LoginMessagesModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateBanner(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLoginMessagesResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMessage(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LoginMessagesModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *LoginMessagesModifyCollectionBody) validateBanner(formats strfmt.Registry) error {
	if swag.IsZero(o.Banner) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"banner", "body", *o.Banner, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"banner", "body", *o.Banner, 2048); err != nil {
		return err
	}

	return nil
}

func (o *LoginMessagesModifyCollectionBody) validateLoginMessagesResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.LoginMessagesResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.LoginMessagesResponseInlineRecords); i++ {
		if swag.IsZero(o.LoginMessagesResponseInlineRecords[i]) { // not required
			continue
		}

		if o.LoginMessagesResponseInlineRecords[i] != nil {
			if err := o.LoginMessagesResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *LoginMessagesModifyCollectionBody) validateMessage(formats strfmt.Registry) error {
	if swag.IsZero(o.Message) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"message", "body", *o.Message, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"message", "body", *o.Message, 2048); err != nil {
		return err
	}

	return nil
}

var loginMessagesModifyCollectionBodyTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["svm","cluster"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		loginMessagesModifyCollectionBodyTypeScopePropEnum = append(loginMessagesModifyCollectionBodyTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// LoginMessagesModifyCollectionBody
	// LoginMessagesModifyCollectionBody
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// LoginMessagesModifyCollectionBodyScopeSvm captures enum value "svm"
	LoginMessagesModifyCollectionBodyScopeSvm string = "svm"

	// BEGIN DEBUGGING
	// LoginMessagesModifyCollectionBody
	// LoginMessagesModifyCollectionBody
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// LoginMessagesModifyCollectionBodyScopeCluster captures enum value "cluster"
	LoginMessagesModifyCollectionBodyScopeCluster string = "cluster"
)

// prop value enum
func (o *LoginMessagesModifyCollectionBody) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, loginMessagesModifyCollectionBodyTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *LoginMessagesModifyCollectionBody) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(o.Scope) { // not required
		return nil
	}

	// value enum
	if err := o.validateScopeEnum("info"+"."+"scope", "body", *o.Scope); err != nil {
		return err
	}

	return nil
}

func (o *LoginMessagesModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this login messages modify collection body based on the context it is used
func (o *LoginMessagesModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLoginMessagesResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LoginMessagesModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *LoginMessagesModifyCollectionBody) contextValidateLoginMessagesResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.LoginMessagesResponseInlineRecords); i++ {

		if o.LoginMessagesResponseInlineRecords[i] != nil {
			if err := o.LoginMessagesResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *LoginMessagesModifyCollectionBody) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"scope", "body", o.Scope); err != nil {
		return err
	}

	return nil
}

func (o *LoginMessagesModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *LoginMessagesModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *LoginMessagesModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LoginMessagesModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res LoginMessagesModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
LoginMessagesInlineLinks login messages inline links
swagger:model login_messages_inline__links
*/
type LoginMessagesInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this login messages inline links
func (o *LoginMessagesInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LoginMessagesInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this login messages inline links based on the context it is used
func (o *LoginMessagesInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LoginMessagesInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *LoginMessagesInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LoginMessagesInlineLinks) UnmarshalBinary(b []byte) error {
	var res LoginMessagesInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
LoginMessagesInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model login_messages_inline_svm
*/
type LoginMessagesInlineSvm struct {

	// links
	Links *models.LoginMessagesInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this login messages inline svm
func (o *LoginMessagesInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LoginMessagesInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this login messages inline svm based on the context it is used
func (o *LoginMessagesInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LoginMessagesInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *LoginMessagesInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LoginMessagesInlineSvm) UnmarshalBinary(b []byte) error {
	var res LoginMessagesInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
LoginMessagesInlineSvmInlineLinks login messages inline svm inline links
swagger:model login_messages_inline_svm_inline__links
*/
type LoginMessagesInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this login messages inline svm inline links
func (o *LoginMessagesInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LoginMessagesInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this login messages inline svm inline links based on the context it is used
func (o *LoginMessagesInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LoginMessagesInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *LoginMessagesInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LoginMessagesInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res LoginMessagesInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
