// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LoginMessagesModifyReader is a Reader for the LoginMessagesModify structure.
type LoginMessagesModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LoginMessagesModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLoginMessagesModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLoginMessagesModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLoginMessagesModifyOK creates a LoginMessagesModifyOK with default headers values
func NewLoginMessagesModifyOK() *LoginMessagesModifyOK {
	return &LoginMessagesModifyOK{}
}

/*
LoginMessagesModifyOK describes a response with status code 200, with default header values.

OK
*/
type LoginMessagesModifyOK struct {
}

// IsSuccess returns true when this login messages modify o k response has a 2xx status code
func (o *LoginMessagesModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this login messages modify o k response has a 3xx status code
func (o *LoginMessagesModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this login messages modify o k response has a 4xx status code
func (o *LoginMessagesModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this login messages modify o k response has a 5xx status code
func (o *LoginMessagesModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this login messages modify o k response a status code equal to that given
func (o *LoginMessagesModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the login messages modify o k response
func (o *LoginMessagesModifyOK) Code() int {
	return 200
}

func (o *LoginMessagesModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /security/login/messages/{uuid}][%d] loginMessagesModifyOK", 200)
}

func (o *LoginMessagesModifyOK) String() string {
	return fmt.Sprintf("[PATCH /security/login/messages/{uuid}][%d] loginMessagesModifyOK", 200)
}

func (o *LoginMessagesModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewLoginMessagesModifyDefault creates a LoginMessagesModifyDefault with default headers values
func NewLoginMessagesModifyDefault(code int) *LoginMessagesModifyDefault {
	return &LoginMessagesModifyDefault{
		_statusCode: code,
	}
}

/*
	LoginMessagesModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response codes

| Error codes | Description |
| ----------- | ----------- |
| 10225636    | Only a cluster administrator can modify the `show_cluster_message` property. |
*/
type LoginMessagesModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this login messages modify default response has a 2xx status code
func (o *LoginMessagesModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this login messages modify default response has a 3xx status code
func (o *LoginMessagesModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this login messages modify default response has a 4xx status code
func (o *LoginMessagesModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this login messages modify default response has a 5xx status code
func (o *LoginMessagesModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this login messages modify default response a status code equal to that given
func (o *LoginMessagesModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the login messages modify default response
func (o *LoginMessagesModifyDefault) Code() int {
	return o._statusCode
}

func (o *LoginMessagesModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/login/messages/{uuid}][%d] login_messages_modify default %s", o._statusCode, payload)
}

func (o *LoginMessagesModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/login/messages/{uuid}][%d] login_messages_modify default %s", o._statusCode, payload)
}

func (o *LoginMessagesModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LoginMessagesModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
