// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewMultiAdminVerifyApprovalGroupCollectionGetParams creates a new MultiAdminVerifyApprovalGroupCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewMultiAdminVerifyApprovalGroupCollectionGetParams() *MultiAdminVerifyApprovalGroupCollectionGetParams {
	return &MultiAdminVerifyApprovalGroupCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewMultiAdminVerifyApprovalGroupCollectionGetParamsWithTimeout creates a new MultiAdminVerifyApprovalGroupCollectionGetParams object
// with the ability to set a timeout on a request.
func NewMultiAdminVerifyApprovalGroupCollectionGetParamsWithTimeout(timeout time.Duration) *MultiAdminVerifyApprovalGroupCollectionGetParams {
	return &MultiAdminVerifyApprovalGroupCollectionGetParams{
		timeout: timeout,
	}
}

// NewMultiAdminVerifyApprovalGroupCollectionGetParamsWithContext creates a new MultiAdminVerifyApprovalGroupCollectionGetParams object
// with the ability to set a context for a request.
func NewMultiAdminVerifyApprovalGroupCollectionGetParamsWithContext(ctx context.Context) *MultiAdminVerifyApprovalGroupCollectionGetParams {
	return &MultiAdminVerifyApprovalGroupCollectionGetParams{
		Context: ctx,
	}
}

// NewMultiAdminVerifyApprovalGroupCollectionGetParamsWithHTTPClient creates a new MultiAdminVerifyApprovalGroupCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewMultiAdminVerifyApprovalGroupCollectionGetParamsWithHTTPClient(client *http.Client) *MultiAdminVerifyApprovalGroupCollectionGetParams {
	return &MultiAdminVerifyApprovalGroupCollectionGetParams{
		HTTPClient: client,
	}
}

/*
MultiAdminVerifyApprovalGroupCollectionGetParams contains all the parameters to send to the API endpoint

	for the multi admin verify approval group collection get operation.

	Typically these are written to a http.Request.
*/
type MultiAdminVerifyApprovalGroupCollectionGetParams struct {

	/* Approvers.

	   Filter by approvers
	*/
	Approvers *string

	/* Email.

	   Filter by email
	*/
	Email *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* OwnerName.

	   Filter by owner.name
	*/
	OwnerName *string

	/* OwnerUUID.

	   Filter by owner.uuid
	*/
	OwnerUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the multi admin verify approval group collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) WithDefaults() *MultiAdminVerifyApprovalGroupCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the multi admin verify approval group collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := MultiAdminVerifyApprovalGroupCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the multi admin verify approval group collection get params
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) WithTimeout(timeout time.Duration) *MultiAdminVerifyApprovalGroupCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the multi admin verify approval group collection get params
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the multi admin verify approval group collection get params
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) WithContext(ctx context.Context) *MultiAdminVerifyApprovalGroupCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the multi admin verify approval group collection get params
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the multi admin verify approval group collection get params
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) WithHTTPClient(client *http.Client) *MultiAdminVerifyApprovalGroupCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the multi admin verify approval group collection get params
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApprovers adds the approvers to the multi admin verify approval group collection get params
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) WithApprovers(approvers *string) *MultiAdminVerifyApprovalGroupCollectionGetParams {
	o.SetApprovers(approvers)
	return o
}

// SetApprovers adds the approvers to the multi admin verify approval group collection get params
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) SetApprovers(approvers *string) {
	o.Approvers = approvers
}

// WithEmail adds the email to the multi admin verify approval group collection get params
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) WithEmail(email *string) *MultiAdminVerifyApprovalGroupCollectionGetParams {
	o.SetEmail(email)
	return o
}

// SetEmail adds the email to the multi admin verify approval group collection get params
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) SetEmail(email *string) {
	o.Email = email
}

// WithFields adds the fields to the multi admin verify approval group collection get params
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) WithFields(fields []string) *MultiAdminVerifyApprovalGroupCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the multi admin verify approval group collection get params
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the multi admin verify approval group collection get params
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) WithMaxRecords(maxRecords *int64) *MultiAdminVerifyApprovalGroupCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the multi admin verify approval group collection get params
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the multi admin verify approval group collection get params
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) WithName(name *string) *MultiAdminVerifyApprovalGroupCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the multi admin verify approval group collection get params
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the multi admin verify approval group collection get params
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) WithOrderBy(orderBy []string) *MultiAdminVerifyApprovalGroupCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the multi admin verify approval group collection get params
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithOwnerName adds the ownerName to the multi admin verify approval group collection get params
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) WithOwnerName(ownerName *string) *MultiAdminVerifyApprovalGroupCollectionGetParams {
	o.SetOwnerName(ownerName)
	return o
}

// SetOwnerName adds the ownerName to the multi admin verify approval group collection get params
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) SetOwnerName(ownerName *string) {
	o.OwnerName = ownerName
}

// WithOwnerUUID adds the ownerUUID to the multi admin verify approval group collection get params
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) WithOwnerUUID(ownerUUID *string) *MultiAdminVerifyApprovalGroupCollectionGetParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the multi admin verify approval group collection get params
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) SetOwnerUUID(ownerUUID *string) {
	o.OwnerUUID = ownerUUID
}

// WithReturnRecords adds the returnRecords to the multi admin verify approval group collection get params
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) WithReturnRecords(returnRecords *bool) *MultiAdminVerifyApprovalGroupCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the multi admin verify approval group collection get params
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the multi admin verify approval group collection get params
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *MultiAdminVerifyApprovalGroupCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the multi admin verify approval group collection get params
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Approvers != nil {

		// query param approvers
		var qrApprovers string

		if o.Approvers != nil {
			qrApprovers = *o.Approvers
		}
		qApprovers := qrApprovers
		if qApprovers != "" {

			if err := r.SetQueryParam("approvers", qApprovers); err != nil {
				return err
			}
		}
	}

	if o.Email != nil {

		// query param email
		var qrEmail string

		if o.Email != nil {
			qrEmail = *o.Email
		}
		qEmail := qrEmail
		if qEmail != "" {

			if err := r.SetQueryParam("email", qEmail); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.OwnerName != nil {

		// query param owner.name
		var qrOwnerName string

		if o.OwnerName != nil {
			qrOwnerName = *o.OwnerName
		}
		qOwnerName := qrOwnerName
		if qOwnerName != "" {

			if err := r.SetQueryParam("owner.name", qOwnerName); err != nil {
				return err
			}
		}
	}

	if o.OwnerUUID != nil {

		// query param owner.uuid
		var qrOwnerUUID string

		if o.OwnerUUID != nil {
			qrOwnerUUID = *o.OwnerUUID
		}
		qOwnerUUID := qrOwnerUUID
		if qOwnerUUID != "" {

			if err := r.SetQueryParam("owner.uuid", qOwnerUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamMultiAdminVerifyApprovalGroupCollectionGet binds the parameter fields
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamMultiAdminVerifyApprovalGroupCollectionGet binds the parameter order_by
func (o *MultiAdminVerifyApprovalGroupCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
