// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// MultiAdminVerifyApprovalGroupModifyCollectionReader is a Reader for the MultiAdminVerifyApprovalGroupModifyCollection structure.
type MultiAdminVerifyApprovalGroupModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *MultiAdminVerifyApprovalGroupModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewMultiAdminVerifyApprovalGroupModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewMultiAdminVerifyApprovalGroupModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewMultiAdminVerifyApprovalGroupModifyCollectionOK creates a MultiAdminVerifyApprovalGroupModifyCollectionOK with default headers values
func NewMultiAdminVerifyApprovalGroupModifyCollectionOK() *MultiAdminVerifyApprovalGroupModifyCollectionOK {
	return &MultiAdminVerifyApprovalGroupModifyCollectionOK{}
}

/*
MultiAdminVerifyApprovalGroupModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type MultiAdminVerifyApprovalGroupModifyCollectionOK struct {
}

// IsSuccess returns true when this multi admin verify approval group modify collection o k response has a 2xx status code
func (o *MultiAdminVerifyApprovalGroupModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this multi admin verify approval group modify collection o k response has a 3xx status code
func (o *MultiAdminVerifyApprovalGroupModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this multi admin verify approval group modify collection o k response has a 4xx status code
func (o *MultiAdminVerifyApprovalGroupModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this multi admin verify approval group modify collection o k response has a 5xx status code
func (o *MultiAdminVerifyApprovalGroupModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this multi admin verify approval group modify collection o k response a status code equal to that given
func (o *MultiAdminVerifyApprovalGroupModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the multi admin verify approval group modify collection o k response
func (o *MultiAdminVerifyApprovalGroupModifyCollectionOK) Code() int {
	return 200
}

func (o *MultiAdminVerifyApprovalGroupModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /security/multi-admin-verify/approval-groups][%d] multiAdminVerifyApprovalGroupModifyCollectionOK", 200)
}

func (o *MultiAdminVerifyApprovalGroupModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /security/multi-admin-verify/approval-groups][%d] multiAdminVerifyApprovalGroupModifyCollectionOK", 200)
}

func (o *MultiAdminVerifyApprovalGroupModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewMultiAdminVerifyApprovalGroupModifyCollectionDefault creates a MultiAdminVerifyApprovalGroupModifyCollectionDefault with default headers values
func NewMultiAdminVerifyApprovalGroupModifyCollectionDefault(code int) *MultiAdminVerifyApprovalGroupModifyCollectionDefault {
	return &MultiAdminVerifyApprovalGroupModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	MultiAdminVerifyApprovalGroupModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262331 | At least one approver is required. |
| 262332 | An add or remove list is required. |
| 262333 | Invalid user in approval group. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type MultiAdminVerifyApprovalGroupModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this multi admin verify approval group modify collection default response has a 2xx status code
func (o *MultiAdminVerifyApprovalGroupModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this multi admin verify approval group modify collection default response has a 3xx status code
func (o *MultiAdminVerifyApprovalGroupModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this multi admin verify approval group modify collection default response has a 4xx status code
func (o *MultiAdminVerifyApprovalGroupModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this multi admin verify approval group modify collection default response has a 5xx status code
func (o *MultiAdminVerifyApprovalGroupModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this multi admin verify approval group modify collection default response a status code equal to that given
func (o *MultiAdminVerifyApprovalGroupModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the multi admin verify approval group modify collection default response
func (o *MultiAdminVerifyApprovalGroupModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *MultiAdminVerifyApprovalGroupModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/multi-admin-verify/approval-groups][%d] multi_admin_verify_approval_group_modify_collection default %s", o._statusCode, payload)
}

func (o *MultiAdminVerifyApprovalGroupModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/multi-admin-verify/approval-groups][%d] multi_admin_verify_approval_group_modify_collection default %s", o._statusCode, payload)
}

func (o *MultiAdminVerifyApprovalGroupModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *MultiAdminVerifyApprovalGroupModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
MultiAdminVerifyApprovalGroupModifyCollectionBody multi admin verify approval group modify collection body
swagger:model MultiAdminVerifyApprovalGroupModifyCollectionBody
*/
type MultiAdminVerifyApprovalGroupModifyCollectionBody struct {

	// List of users that can approve a request.
	MultiAdminVerifyApprovalGroupInlineApprovers []*string `json:"approvers,omitempty"`

	// Email addresses that are notified when a request is created, approved, vetoed, or executed.
	MultiAdminVerifyApprovalGroupInlineEmail []*strfmt.Email `json:"email,omitempty"`

	// multi admin verify approval group response inline records
	MultiAdminVerifyApprovalGroupResponseInlineRecords []*models.MultiAdminVerifyApprovalGroup `json:"records,omitempty"`

	// Name of the approval group.
	Name *string `json:"name,omitempty"`

	// owner
	Owner *models.MultiAdminVerifyApprovalGroupInlineOwner `json:"owner,omitempty"`
}

// Validate validates this multi admin verify approval group modify collection body
func (o *MultiAdminVerifyApprovalGroupModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateMultiAdminVerifyApprovalGroupInlineEmail(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMultiAdminVerifyApprovalGroupResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOwner(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MultiAdminVerifyApprovalGroupModifyCollectionBody) validateMultiAdminVerifyApprovalGroupInlineEmail(formats strfmt.Registry) error {
	if swag.IsZero(o.MultiAdminVerifyApprovalGroupInlineEmail) { // not required
		return nil
	}

	for i := 0; i < len(o.MultiAdminVerifyApprovalGroupInlineEmail); i++ {
		if swag.IsZero(o.MultiAdminVerifyApprovalGroupInlineEmail[i]) { // not required
			continue
		}

		if err := validate.FormatOf("info"+"."+"email"+"."+strconv.Itoa(i), "body", "email", o.MultiAdminVerifyApprovalGroupInlineEmail[i].String(), formats); err != nil {
			return err
		}

	}

	return nil
}

func (o *MultiAdminVerifyApprovalGroupModifyCollectionBody) validateMultiAdminVerifyApprovalGroupResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.MultiAdminVerifyApprovalGroupResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.MultiAdminVerifyApprovalGroupResponseInlineRecords); i++ {
		if swag.IsZero(o.MultiAdminVerifyApprovalGroupResponseInlineRecords[i]) { // not required
			continue
		}

		if o.MultiAdminVerifyApprovalGroupResponseInlineRecords[i] != nil {
			if err := o.MultiAdminVerifyApprovalGroupResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *MultiAdminVerifyApprovalGroupModifyCollectionBody) validateOwner(formats strfmt.Registry) error {
	if swag.IsZero(o.Owner) { // not required
		return nil
	}

	if o.Owner != nil {
		if err := o.Owner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this multi admin verify approval group modify collection body based on the context it is used
func (o *MultiAdminVerifyApprovalGroupModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateMultiAdminVerifyApprovalGroupResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MultiAdminVerifyApprovalGroupModifyCollectionBody) contextValidateMultiAdminVerifyApprovalGroupResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.MultiAdminVerifyApprovalGroupResponseInlineRecords); i++ {

		if o.MultiAdminVerifyApprovalGroupResponseInlineRecords[i] != nil {
			if err := o.MultiAdminVerifyApprovalGroupResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *MultiAdminVerifyApprovalGroupModifyCollectionBody) contextValidateOwner(ctx context.Context, formats strfmt.Registry) error {

	if o.Owner != nil {
		if err := o.Owner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *MultiAdminVerifyApprovalGroupModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *MultiAdminVerifyApprovalGroupModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res MultiAdminVerifyApprovalGroupModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
MultiAdminVerifyApprovalGroupInlineOwner The owner of the approval group. The only valid owner is currently the cluster.
swagger:model multi_admin_verify_approval_group_inline_owner
*/
type MultiAdminVerifyApprovalGroupInlineOwner struct {

	// links
	Links *models.MultiAdminVerifyApprovalGroupInlineOwnerInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a POST or PATCH method.
	//
	// Example: svm1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this multi admin verify approval group inline owner
func (o *MultiAdminVerifyApprovalGroupInlineOwner) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MultiAdminVerifyApprovalGroupInlineOwner) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this multi admin verify approval group inline owner based on the context it is used
func (o *MultiAdminVerifyApprovalGroupInlineOwner) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MultiAdminVerifyApprovalGroupInlineOwner) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *MultiAdminVerifyApprovalGroupInlineOwner) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"owner"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *MultiAdminVerifyApprovalGroupInlineOwner) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *MultiAdminVerifyApprovalGroupInlineOwner) UnmarshalBinary(b []byte) error {
	var res MultiAdminVerifyApprovalGroupInlineOwner
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
MultiAdminVerifyApprovalGroupInlineOwnerInlineLinks multi admin verify approval group inline owner inline links
swagger:model multi_admin_verify_approval_group_inline_owner_inline__links
*/
type MultiAdminVerifyApprovalGroupInlineOwnerInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this multi admin verify approval group inline owner inline links
func (o *MultiAdminVerifyApprovalGroupInlineOwnerInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MultiAdminVerifyApprovalGroupInlineOwnerInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this multi admin verify approval group inline owner inline links based on the context it is used
func (o *MultiAdminVerifyApprovalGroupInlineOwnerInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MultiAdminVerifyApprovalGroupInlineOwnerInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *MultiAdminVerifyApprovalGroupInlineOwnerInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *MultiAdminVerifyApprovalGroupInlineOwnerInlineLinks) UnmarshalBinary(b []byte) error {
	var res MultiAdminVerifyApprovalGroupInlineOwnerInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
