// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// MultiAdminVerifyConfigModifyReader is a Reader for the MultiAdminVerifyConfigModify structure.
type MultiAdminVerifyConfigModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *MultiAdminVerifyConfigModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewMultiAdminVerifyConfigModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewMultiAdminVerifyConfigModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewMultiAdminVerifyConfigModifyOK creates a MultiAdminVerifyConfigModifyOK with default headers values
func NewMultiAdminVerifyConfigModifyOK() *MultiAdminVerifyConfigModifyOK {
	return &MultiAdminVerifyConfigModifyOK{}
}

/*
MultiAdminVerifyConfigModifyOK describes a response with status code 200, with default header values.

OK
*/
type MultiAdminVerifyConfigModifyOK struct {
}

// IsSuccess returns true when this multi admin verify config modify o k response has a 2xx status code
func (o *MultiAdminVerifyConfigModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this multi admin verify config modify o k response has a 3xx status code
func (o *MultiAdminVerifyConfigModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this multi admin verify config modify o k response has a 4xx status code
func (o *MultiAdminVerifyConfigModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this multi admin verify config modify o k response has a 5xx status code
func (o *MultiAdminVerifyConfigModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this multi admin verify config modify o k response a status code equal to that given
func (o *MultiAdminVerifyConfigModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the multi admin verify config modify o k response
func (o *MultiAdminVerifyConfigModifyOK) Code() int {
	return 200
}

func (o *MultiAdminVerifyConfigModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /security/multi-admin-verify][%d] multiAdminVerifyConfigModifyOK", 200)
}

func (o *MultiAdminVerifyConfigModifyOK) String() string {
	return fmt.Sprintf("[PATCH /security/multi-admin-verify][%d] multiAdminVerifyConfigModifyOK", 200)
}

func (o *MultiAdminVerifyConfigModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewMultiAdminVerifyConfigModifyDefault creates a MultiAdminVerifyConfigModifyDefault with default headers values
func NewMultiAdminVerifyConfigModifyDefault(code int) *MultiAdminVerifyConfigModifyDefault {
	return &MultiAdminVerifyConfigModifyDefault{
		_statusCode: code,
	}
}

/*
	MultiAdminVerifyConfigModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262309 | The feature must be enabled first. |
| 262311 | Value must be greater than zero. |
| 262312 | Number of required approvers must be less than the total number of unique approvers in the approval-groups. |
| 262313 | Number of unique approvers in the approval-groups must be greater than the number of required approvers. |
| 262314 | One or more approval groups added do not exist. |
| 262315 | Approval-groups must be specified when enabling this feature. |
| 262316 | Value must be in the range two minutes to two weeks. |
| 262318 | multi-admin-verify requires an effective cluster version of ONTAP 9.11.1 or later. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type MultiAdminVerifyConfigModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this multi admin verify config modify default response has a 2xx status code
func (o *MultiAdminVerifyConfigModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this multi admin verify config modify default response has a 3xx status code
func (o *MultiAdminVerifyConfigModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this multi admin verify config modify default response has a 4xx status code
func (o *MultiAdminVerifyConfigModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this multi admin verify config modify default response has a 5xx status code
func (o *MultiAdminVerifyConfigModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this multi admin verify config modify default response a status code equal to that given
func (o *MultiAdminVerifyConfigModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the multi admin verify config modify default response
func (o *MultiAdminVerifyConfigModifyDefault) Code() int {
	return o._statusCode
}

func (o *MultiAdminVerifyConfigModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/multi-admin-verify][%d] multi_admin_verify_config_modify default %s", o._statusCode, payload)
}

func (o *MultiAdminVerifyConfigModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/multi-admin-verify][%d] multi_admin_verify_config_modify default %s", o._statusCode, payload)
}

func (o *MultiAdminVerifyConfigModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *MultiAdminVerifyConfigModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
