// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewMultiAdminVerifyRequestCreateParams creates a new MultiAdminVerifyRequestCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewMultiAdminVerifyRequestCreateParams() *MultiAdminVerifyRequestCreateParams {
	return &MultiAdminVerifyRequestCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewMultiAdminVerifyRequestCreateParamsWithTimeout creates a new MultiAdminVerifyRequestCreateParams object
// with the ability to set a timeout on a request.
func NewMultiAdminVerifyRequestCreateParamsWithTimeout(timeout time.Duration) *MultiAdminVerifyRequestCreateParams {
	return &MultiAdminVerifyRequestCreateParams{
		timeout: timeout,
	}
}

// NewMultiAdminVerifyRequestCreateParamsWithContext creates a new MultiAdminVerifyRequestCreateParams object
// with the ability to set a context for a request.
func NewMultiAdminVerifyRequestCreateParamsWithContext(ctx context.Context) *MultiAdminVerifyRequestCreateParams {
	return &MultiAdminVerifyRequestCreateParams{
		Context: ctx,
	}
}

// NewMultiAdminVerifyRequestCreateParamsWithHTTPClient creates a new MultiAdminVerifyRequestCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewMultiAdminVerifyRequestCreateParamsWithHTTPClient(client *http.Client) *MultiAdminVerifyRequestCreateParams {
	return &MultiAdminVerifyRequestCreateParams{
		HTTPClient: client,
	}
}

/*
MultiAdminVerifyRequestCreateParams contains all the parameters to send to the API endpoint

	for the multi admin verify request create operation.

	Typically these are written to a http.Request.
*/
type MultiAdminVerifyRequestCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.MultiAdminVerifyRequest

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the multi admin verify request create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *MultiAdminVerifyRequestCreateParams) WithDefaults() *MultiAdminVerifyRequestCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the multi admin verify request create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *MultiAdminVerifyRequestCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := MultiAdminVerifyRequestCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the multi admin verify request create params
func (o *MultiAdminVerifyRequestCreateParams) WithTimeout(timeout time.Duration) *MultiAdminVerifyRequestCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the multi admin verify request create params
func (o *MultiAdminVerifyRequestCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the multi admin verify request create params
func (o *MultiAdminVerifyRequestCreateParams) WithContext(ctx context.Context) *MultiAdminVerifyRequestCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the multi admin verify request create params
func (o *MultiAdminVerifyRequestCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the multi admin verify request create params
func (o *MultiAdminVerifyRequestCreateParams) WithHTTPClient(client *http.Client) *MultiAdminVerifyRequestCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the multi admin verify request create params
func (o *MultiAdminVerifyRequestCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the multi admin verify request create params
func (o *MultiAdminVerifyRequestCreateParams) WithInfo(info *models.MultiAdminVerifyRequest) *MultiAdminVerifyRequestCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the multi admin verify request create params
func (o *MultiAdminVerifyRequestCreateParams) SetInfo(info *models.MultiAdminVerifyRequest) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the multi admin verify request create params
func (o *MultiAdminVerifyRequestCreateParams) WithReturnRecords(returnRecords *bool) *MultiAdminVerifyRequestCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the multi admin verify request create params
func (o *MultiAdminVerifyRequestCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *MultiAdminVerifyRequestCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
