// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// MultiAdminVerifyRequestDeleteCollectionReader is a Reader for the MultiAdminVerifyRequestDeleteCollection structure.
type MultiAdminVerifyRequestDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *MultiAdminVerifyRequestDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewMultiAdminVerifyRequestDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewMultiAdminVerifyRequestDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewMultiAdminVerifyRequestDeleteCollectionOK creates a MultiAdminVerifyRequestDeleteCollectionOK with default headers values
func NewMultiAdminVerifyRequestDeleteCollectionOK() *MultiAdminVerifyRequestDeleteCollectionOK {
	return &MultiAdminVerifyRequestDeleteCollectionOK{}
}

/*
MultiAdminVerifyRequestDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type MultiAdminVerifyRequestDeleteCollectionOK struct {
}

// IsSuccess returns true when this multi admin verify request delete collection o k response has a 2xx status code
func (o *MultiAdminVerifyRequestDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this multi admin verify request delete collection o k response has a 3xx status code
func (o *MultiAdminVerifyRequestDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this multi admin verify request delete collection o k response has a 4xx status code
func (o *MultiAdminVerifyRequestDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this multi admin verify request delete collection o k response has a 5xx status code
func (o *MultiAdminVerifyRequestDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this multi admin verify request delete collection o k response a status code equal to that given
func (o *MultiAdminVerifyRequestDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the multi admin verify request delete collection o k response
func (o *MultiAdminVerifyRequestDeleteCollectionOK) Code() int {
	return 200
}

func (o *MultiAdminVerifyRequestDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /security/multi-admin-verify/requests][%d] multiAdminVerifyRequestDeleteCollectionOK", 200)
}

func (o *MultiAdminVerifyRequestDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /security/multi-admin-verify/requests][%d] multiAdminVerifyRequestDeleteCollectionOK", 200)
}

func (o *MultiAdminVerifyRequestDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewMultiAdminVerifyRequestDeleteCollectionDefault creates a MultiAdminVerifyRequestDeleteCollectionDefault with default headers values
func NewMultiAdminVerifyRequestDeleteCollectionDefault(code int) *MultiAdminVerifyRequestDeleteCollectionDefault {
	return &MultiAdminVerifyRequestDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	MultiAdminVerifyRequestDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262336 | User not authorized to delete the request. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type MultiAdminVerifyRequestDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this multi admin verify request delete collection default response has a 2xx status code
func (o *MultiAdminVerifyRequestDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this multi admin verify request delete collection default response has a 3xx status code
func (o *MultiAdminVerifyRequestDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this multi admin verify request delete collection default response has a 4xx status code
func (o *MultiAdminVerifyRequestDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this multi admin verify request delete collection default response has a 5xx status code
func (o *MultiAdminVerifyRequestDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this multi admin verify request delete collection default response a status code equal to that given
func (o *MultiAdminVerifyRequestDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the multi admin verify request delete collection default response
func (o *MultiAdminVerifyRequestDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *MultiAdminVerifyRequestDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/multi-admin-verify/requests][%d] multi_admin_verify_request_delete_collection default %s", o._statusCode, payload)
}

func (o *MultiAdminVerifyRequestDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/multi-admin-verify/requests][%d] multi_admin_verify_request_delete_collection default %s", o._statusCode, payload)
}

func (o *MultiAdminVerifyRequestDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *MultiAdminVerifyRequestDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
MultiAdminVerifyRequestDeleteCollectionBody multi admin verify request delete collection body
swagger:model MultiAdminVerifyRequestDeleteCollectionBody
*/
type MultiAdminVerifyRequestDeleteCollectionBody struct {

	// multi admin verify request response inline records
	MultiAdminVerifyRequestResponseInlineRecords []*models.MultiAdminVerifyRequest `json:"records,omitempty"`
}

// Validate validates this multi admin verify request delete collection body
func (o *MultiAdminVerifyRequestDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateMultiAdminVerifyRequestResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MultiAdminVerifyRequestDeleteCollectionBody) validateMultiAdminVerifyRequestResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.MultiAdminVerifyRequestResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.MultiAdminVerifyRequestResponseInlineRecords); i++ {
		if swag.IsZero(o.MultiAdminVerifyRequestResponseInlineRecords[i]) { // not required
			continue
		}

		if o.MultiAdminVerifyRequestResponseInlineRecords[i] != nil {
			if err := o.MultiAdminVerifyRequestResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this multi admin verify request delete collection body based on the context it is used
func (o *MultiAdminVerifyRequestDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateMultiAdminVerifyRequestResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MultiAdminVerifyRequestDeleteCollectionBody) contextValidateMultiAdminVerifyRequestResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.MultiAdminVerifyRequestResponseInlineRecords); i++ {

		if o.MultiAdminVerifyRequestResponseInlineRecords[i] != nil {
			if err := o.MultiAdminVerifyRequestResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *MultiAdminVerifyRequestDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *MultiAdminVerifyRequestDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res MultiAdminVerifyRequestDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
