// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// MultiAdminVerifyRequestDeleteReader is a Reader for the MultiAdminVerifyRequestDelete structure.
type MultiAdminVerifyRequestDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *MultiAdminVerifyRequestDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewMultiAdminVerifyRequestDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewMultiAdminVerifyRequestDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewMultiAdminVerifyRequestDeleteOK creates a MultiAdminVerifyRequestDeleteOK with default headers values
func NewMultiAdminVerifyRequestDeleteOK() *MultiAdminVerifyRequestDeleteOK {
	return &MultiAdminVerifyRequestDeleteOK{}
}

/*
MultiAdminVerifyRequestDeleteOK describes a response with status code 200, with default header values.

OK
*/
type MultiAdminVerifyRequestDeleteOK struct {
}

// IsSuccess returns true when this multi admin verify request delete o k response has a 2xx status code
func (o *MultiAdminVerifyRequestDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this multi admin verify request delete o k response has a 3xx status code
func (o *MultiAdminVerifyRequestDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this multi admin verify request delete o k response has a 4xx status code
func (o *MultiAdminVerifyRequestDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this multi admin verify request delete o k response has a 5xx status code
func (o *MultiAdminVerifyRequestDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this multi admin verify request delete o k response a status code equal to that given
func (o *MultiAdminVerifyRequestDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the multi admin verify request delete o k response
func (o *MultiAdminVerifyRequestDeleteOK) Code() int {
	return 200
}

func (o *MultiAdminVerifyRequestDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /security/multi-admin-verify/requests/{index}][%d] multiAdminVerifyRequestDeleteOK", 200)
}

func (o *MultiAdminVerifyRequestDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /security/multi-admin-verify/requests/{index}][%d] multiAdminVerifyRequestDeleteOK", 200)
}

func (o *MultiAdminVerifyRequestDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewMultiAdminVerifyRequestDeleteDefault creates a MultiAdminVerifyRequestDeleteDefault with default headers values
func NewMultiAdminVerifyRequestDeleteDefault(code int) *MultiAdminVerifyRequestDeleteDefault {
	return &MultiAdminVerifyRequestDeleteDefault{
		_statusCode: code,
	}
}

/*
	MultiAdminVerifyRequestDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262336 | User not authorized to delete the request. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type MultiAdminVerifyRequestDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this multi admin verify request delete default response has a 2xx status code
func (o *MultiAdminVerifyRequestDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this multi admin verify request delete default response has a 3xx status code
func (o *MultiAdminVerifyRequestDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this multi admin verify request delete default response has a 4xx status code
func (o *MultiAdminVerifyRequestDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this multi admin verify request delete default response has a 5xx status code
func (o *MultiAdminVerifyRequestDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this multi admin verify request delete default response a status code equal to that given
func (o *MultiAdminVerifyRequestDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the multi admin verify request delete default response
func (o *MultiAdminVerifyRequestDeleteDefault) Code() int {
	return o._statusCode
}

func (o *MultiAdminVerifyRequestDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/multi-admin-verify/requests/{index}][%d] multi_admin_verify_request_delete default %s", o._statusCode, payload)
}

func (o *MultiAdminVerifyRequestDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/multi-admin-verify/requests/{index}][%d] multi_admin_verify_request_delete default %s", o._statusCode, payload)
}

func (o *MultiAdminVerifyRequestDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *MultiAdminVerifyRequestDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
