// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// MultiAdminVerifyRequestModifyCollectionReader is a Reader for the MultiAdminVerifyRequestModifyCollection structure.
type MultiAdminVerifyRequestModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *MultiAdminVerifyRequestModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewMultiAdminVerifyRequestModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewMultiAdminVerifyRequestModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewMultiAdminVerifyRequestModifyCollectionOK creates a MultiAdminVerifyRequestModifyCollectionOK with default headers values
func NewMultiAdminVerifyRequestModifyCollectionOK() *MultiAdminVerifyRequestModifyCollectionOK {
	return &MultiAdminVerifyRequestModifyCollectionOK{}
}

/*
MultiAdminVerifyRequestModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type MultiAdminVerifyRequestModifyCollectionOK struct {
}

// IsSuccess returns true when this multi admin verify request modify collection o k response has a 2xx status code
func (o *MultiAdminVerifyRequestModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this multi admin verify request modify collection o k response has a 3xx status code
func (o *MultiAdminVerifyRequestModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this multi admin verify request modify collection o k response has a 4xx status code
func (o *MultiAdminVerifyRequestModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this multi admin verify request modify collection o k response has a 5xx status code
func (o *MultiAdminVerifyRequestModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this multi admin verify request modify collection o k response a status code equal to that given
func (o *MultiAdminVerifyRequestModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the multi admin verify request modify collection o k response
func (o *MultiAdminVerifyRequestModifyCollectionOK) Code() int {
	return 200
}

func (o *MultiAdminVerifyRequestModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /security/multi-admin-verify/requests][%d] multiAdminVerifyRequestModifyCollectionOK", 200)
}

func (o *MultiAdminVerifyRequestModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /security/multi-admin-verify/requests][%d] multiAdminVerifyRequestModifyCollectionOK", 200)
}

func (o *MultiAdminVerifyRequestModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewMultiAdminVerifyRequestModifyCollectionDefault creates a MultiAdminVerifyRequestModifyCollectionDefault with default headers values
func NewMultiAdminVerifyRequestModifyCollectionDefault(code int) *MultiAdminVerifyRequestModifyCollectionDefault {
	return &MultiAdminVerifyRequestModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	MultiAdminVerifyRequestModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262309 | The feature must be enabled first. |
| 262329 | Invalid state. State can be modified to approved, vetoed, or executed. |
| 262337 | User not eligible to approve the request. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type MultiAdminVerifyRequestModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this multi admin verify request modify collection default response has a 2xx status code
func (o *MultiAdminVerifyRequestModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this multi admin verify request modify collection default response has a 3xx status code
func (o *MultiAdminVerifyRequestModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this multi admin verify request modify collection default response has a 4xx status code
func (o *MultiAdminVerifyRequestModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this multi admin verify request modify collection default response has a 5xx status code
func (o *MultiAdminVerifyRequestModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this multi admin verify request modify collection default response a status code equal to that given
func (o *MultiAdminVerifyRequestModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the multi admin verify request modify collection default response
func (o *MultiAdminVerifyRequestModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *MultiAdminVerifyRequestModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/multi-admin-verify/requests][%d] multi_admin_verify_request_modify_collection default %s", o._statusCode, payload)
}

func (o *MultiAdminVerifyRequestModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/multi-admin-verify/requests][%d] multi_admin_verify_request_modify_collection default %s", o._statusCode, payload)
}

func (o *MultiAdminVerifyRequestModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *MultiAdminVerifyRequestModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
MultiAdminVerifyRequestModifyCollectionBody multi admin verify request modify collection body
swagger:model MultiAdminVerifyRequestModifyCollectionBody
*/
type MultiAdminVerifyRequestModifyCollectionBody struct {

	// approve expiry time
	// Read Only: true
	// Format: date-time
	ApproveExpiryTime *strfmt.DateTime `json:"approve_expiry_time,omitempty"`

	// approve time
	// Read Only: true
	// Format: date-time
	ApproveTime *strfmt.DateTime `json:"approve_time,omitempty"`

	// Optional user-provided comment that is sent to the approval-group email indicating why the request was made.
	Comment *string `json:"comment,omitempty"`

	// create time
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// Specifies that the operation is executed automatically on final approval.
	ExecuteOnApproval *bool `json:"execute_on_approval,omitempty"`

	// execution expiry time
	// Read Only: true
	// Format: date-time
	ExecutionExpiryTime *strfmt.DateTime `json:"execution_expiry_time,omitempty"`

	// Unique index that represents a request.
	// Read Only: true
	Index *int64 `json:"index,omitempty"`

	// The users that have approved the request.
	// Read Only: true
	MultiAdminVerifyRequestInlineApprovedUsers []*string `json:"approved_users,omitempty"`

	// List of users that can execute the operation once approved. If not set, any authorized user can perform the operation.
	MultiAdminVerifyRequestInlinePermittedUsers []*string `json:"permitted_users,omitempty"`

	// The users that are able to approve the request.
	// Read Only: true
	MultiAdminVerifyRequestInlinePotentialApprovers []*string `json:"potential_approvers,omitempty"`

	// multi admin verify request response inline records
	MultiAdminVerifyRequestResponseInlineRecords []*models.MultiAdminVerifyRequest `json:"records,omitempty"`

	// The command to execute.
	Operation *string `json:"operation,omitempty"`

	// owner
	Owner *models.MultiAdminVerifyRequestInlineOwner `json:"owner,omitempty"`

	// The number of approvers remaining that are required to approve.
	// Read Only: true
	PendingApprovers *int64 `json:"pending_approvers,omitempty"`

	// Identifies the specific entry upon which the user wants to operate.
	Query *string `json:"query,omitempty"`

	// The number of required approvers, excluding the user that made the request.
	// Read Only: true
	RequiredApprovers *int64 `json:"required_approvers,omitempty"`

	// The state of the request. PATCH supports approved and vetoed. The state only changes after setting to approved once no more approvers are required.
	// Enum: ["approved","vetoed","pending","expired","executed"]
	State *string `json:"state,omitempty"`

	// The user that created the request. Automatically set by ONTAP.
	// Read Only: true
	UserRequested *string `json:"user_requested,omitempty"`

	// The user that vetoed the request.
	// Read Only: true
	UserVetoed *string `json:"user_vetoed,omitempty"`
}

// Validate validates this multi admin verify request modify collection body
func (o *MultiAdminVerifyRequestModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateApproveExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateApproveTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExecutionExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMultiAdminVerifyRequestResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOwner(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MultiAdminVerifyRequestModifyCollectionBody) validateApproveExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(o.ApproveExpiryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"approve_expiry_time", "body", "date-time", o.ApproveExpiryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *MultiAdminVerifyRequestModifyCollectionBody) validateApproveTime(formats strfmt.Registry) error {
	if swag.IsZero(o.ApproveTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"approve_time", "body", "date-time", o.ApproveTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *MultiAdminVerifyRequestModifyCollectionBody) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *MultiAdminVerifyRequestModifyCollectionBody) validateExecutionExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(o.ExecutionExpiryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"execution_expiry_time", "body", "date-time", o.ExecutionExpiryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *MultiAdminVerifyRequestModifyCollectionBody) validateMultiAdminVerifyRequestResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.MultiAdminVerifyRequestResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.MultiAdminVerifyRequestResponseInlineRecords); i++ {
		if swag.IsZero(o.MultiAdminVerifyRequestResponseInlineRecords[i]) { // not required
			continue
		}

		if o.MultiAdminVerifyRequestResponseInlineRecords[i] != nil {
			if err := o.MultiAdminVerifyRequestResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *MultiAdminVerifyRequestModifyCollectionBody) validateOwner(formats strfmt.Registry) error {
	if swag.IsZero(o.Owner) { // not required
		return nil
	}

	if o.Owner != nil {
		if err := o.Owner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner")
			}
			return err
		}
	}

	return nil
}

var multiAdminVerifyRequestModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["approved","vetoed","pending","expired","executed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		multiAdminVerifyRequestModifyCollectionBodyTypeStatePropEnum = append(multiAdminVerifyRequestModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// MultiAdminVerifyRequestModifyCollectionBody
	// MultiAdminVerifyRequestModifyCollectionBody
	// state
	// State
	// approved
	// END DEBUGGING
	// MultiAdminVerifyRequestModifyCollectionBodyStateApproved captures enum value "approved"
	MultiAdminVerifyRequestModifyCollectionBodyStateApproved string = "approved"

	// BEGIN DEBUGGING
	// MultiAdminVerifyRequestModifyCollectionBody
	// MultiAdminVerifyRequestModifyCollectionBody
	// state
	// State
	// vetoed
	// END DEBUGGING
	// MultiAdminVerifyRequestModifyCollectionBodyStateVetoed captures enum value "vetoed"
	MultiAdminVerifyRequestModifyCollectionBodyStateVetoed string = "vetoed"

	// BEGIN DEBUGGING
	// MultiAdminVerifyRequestModifyCollectionBody
	// MultiAdminVerifyRequestModifyCollectionBody
	// state
	// State
	// pending
	// END DEBUGGING
	// MultiAdminVerifyRequestModifyCollectionBodyStatePending captures enum value "pending"
	MultiAdminVerifyRequestModifyCollectionBodyStatePending string = "pending"

	// BEGIN DEBUGGING
	// MultiAdminVerifyRequestModifyCollectionBody
	// MultiAdminVerifyRequestModifyCollectionBody
	// state
	// State
	// expired
	// END DEBUGGING
	// MultiAdminVerifyRequestModifyCollectionBodyStateExpired captures enum value "expired"
	MultiAdminVerifyRequestModifyCollectionBodyStateExpired string = "expired"

	// BEGIN DEBUGGING
	// MultiAdminVerifyRequestModifyCollectionBody
	// MultiAdminVerifyRequestModifyCollectionBody
	// state
	// State
	// executed
	// END DEBUGGING
	// MultiAdminVerifyRequestModifyCollectionBodyStateExecuted captures enum value "executed"
	MultiAdminVerifyRequestModifyCollectionBodyStateExecuted string = "executed"
)

// prop value enum
func (o *MultiAdminVerifyRequestModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, multiAdminVerifyRequestModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *MultiAdminVerifyRequestModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this multi admin verify request modify collection body based on the context it is used
func (o *MultiAdminVerifyRequestModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateApproveExpiryTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateApproveTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExecutionExpiryTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIndex(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMultiAdminVerifyRequestInlineApprovedUsers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMultiAdminVerifyRequestInlinePotentialApprovers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMultiAdminVerifyRequestResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePendingApprovers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRequiredApprovers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUserRequested(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUserVetoed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MultiAdminVerifyRequestModifyCollectionBody) contextValidateApproveExpiryTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"approve_expiry_time", "body", o.ApproveExpiryTime); err != nil {
		return err
	}

	return nil
}

func (o *MultiAdminVerifyRequestModifyCollectionBody) contextValidateApproveTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"approve_time", "body", o.ApproveTime); err != nil {
		return err
	}

	return nil
}

func (o *MultiAdminVerifyRequestModifyCollectionBody) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *MultiAdminVerifyRequestModifyCollectionBody) contextValidateExecutionExpiryTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"execution_expiry_time", "body", o.ExecutionExpiryTime); err != nil {
		return err
	}

	return nil
}

func (o *MultiAdminVerifyRequestModifyCollectionBody) contextValidateIndex(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"index", "body", o.Index); err != nil {
		return err
	}

	return nil
}

func (o *MultiAdminVerifyRequestModifyCollectionBody) contextValidateMultiAdminVerifyRequestInlineApprovedUsers(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"approved_users", "body", []*string(o.MultiAdminVerifyRequestInlineApprovedUsers)); err != nil {
		return err
	}

	return nil
}

func (o *MultiAdminVerifyRequestModifyCollectionBody) contextValidateMultiAdminVerifyRequestInlinePotentialApprovers(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"potential_approvers", "body", []*string(o.MultiAdminVerifyRequestInlinePotentialApprovers)); err != nil {
		return err
	}

	return nil
}

func (o *MultiAdminVerifyRequestModifyCollectionBody) contextValidateMultiAdminVerifyRequestResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.MultiAdminVerifyRequestResponseInlineRecords); i++ {

		if o.MultiAdminVerifyRequestResponseInlineRecords[i] != nil {
			if err := o.MultiAdminVerifyRequestResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *MultiAdminVerifyRequestModifyCollectionBody) contextValidateOwner(ctx context.Context, formats strfmt.Registry) error {

	if o.Owner != nil {
		if err := o.Owner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner")
			}
			return err
		}
	}

	return nil
}

func (o *MultiAdminVerifyRequestModifyCollectionBody) contextValidatePendingApprovers(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"pending_approvers", "body", o.PendingApprovers); err != nil {
		return err
	}

	return nil
}

func (o *MultiAdminVerifyRequestModifyCollectionBody) contextValidateRequiredApprovers(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"required_approvers", "body", o.RequiredApprovers); err != nil {
		return err
	}

	return nil
}

func (o *MultiAdminVerifyRequestModifyCollectionBody) contextValidateUserRequested(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"user_requested", "body", o.UserRequested); err != nil {
		return err
	}

	return nil
}

func (o *MultiAdminVerifyRequestModifyCollectionBody) contextValidateUserVetoed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"user_vetoed", "body", o.UserVetoed); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *MultiAdminVerifyRequestModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *MultiAdminVerifyRequestModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res MultiAdminVerifyRequestModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
MultiAdminVerifyRequestInlineOwner The owner of the request. This can identify the cluster or an SVM.
swagger:model multi_admin_verify_request_inline_owner
*/
type MultiAdminVerifyRequestInlineOwner struct {

	// links
	Links *models.MultiAdminVerifyRequestInlineOwnerInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this multi admin verify request inline owner
func (o *MultiAdminVerifyRequestInlineOwner) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MultiAdminVerifyRequestInlineOwner) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this multi admin verify request inline owner based on the context it is used
func (o *MultiAdminVerifyRequestInlineOwner) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MultiAdminVerifyRequestInlineOwner) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *MultiAdminVerifyRequestInlineOwner) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *MultiAdminVerifyRequestInlineOwner) UnmarshalBinary(b []byte) error {
	var res MultiAdminVerifyRequestInlineOwner
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
MultiAdminVerifyRequestInlineOwnerInlineLinks multi admin verify request inline owner inline links
swagger:model multi_admin_verify_request_inline_owner_inline__links
*/
type MultiAdminVerifyRequestInlineOwnerInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this multi admin verify request inline owner inline links
func (o *MultiAdminVerifyRequestInlineOwnerInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MultiAdminVerifyRequestInlineOwnerInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this multi admin verify request inline owner inline links based on the context it is used
func (o *MultiAdminVerifyRequestInlineOwnerInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MultiAdminVerifyRequestInlineOwnerInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *MultiAdminVerifyRequestInlineOwnerInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *MultiAdminVerifyRequestInlineOwnerInlineLinks) UnmarshalBinary(b []byte) error {
	var res MultiAdminVerifyRequestInlineOwnerInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
