// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// MultiAdminVerifyRequestModifyReader is a Reader for the MultiAdminVerifyRequestModify structure.
type MultiAdminVerifyRequestModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *MultiAdminVerifyRequestModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewMultiAdminVerifyRequestModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewMultiAdminVerifyRequestModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewMultiAdminVerifyRequestModifyOK creates a MultiAdminVerifyRequestModifyOK with default headers values
func NewMultiAdminVerifyRequestModifyOK() *MultiAdminVerifyRequestModifyOK {
	return &MultiAdminVerifyRequestModifyOK{}
}

/*
MultiAdminVerifyRequestModifyOK describes a response with status code 200, with default header values.

OK
*/
type MultiAdminVerifyRequestModifyOK struct {
}

// IsSuccess returns true when this multi admin verify request modify o k response has a 2xx status code
func (o *MultiAdminVerifyRequestModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this multi admin verify request modify o k response has a 3xx status code
func (o *MultiAdminVerifyRequestModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this multi admin verify request modify o k response has a 4xx status code
func (o *MultiAdminVerifyRequestModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this multi admin verify request modify o k response has a 5xx status code
func (o *MultiAdminVerifyRequestModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this multi admin verify request modify o k response a status code equal to that given
func (o *MultiAdminVerifyRequestModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the multi admin verify request modify o k response
func (o *MultiAdminVerifyRequestModifyOK) Code() int {
	return 200
}

func (o *MultiAdminVerifyRequestModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /security/multi-admin-verify/requests/{index}][%d] multiAdminVerifyRequestModifyOK", 200)
}

func (o *MultiAdminVerifyRequestModifyOK) String() string {
	return fmt.Sprintf("[PATCH /security/multi-admin-verify/requests/{index}][%d] multiAdminVerifyRequestModifyOK", 200)
}

func (o *MultiAdminVerifyRequestModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewMultiAdminVerifyRequestModifyDefault creates a MultiAdminVerifyRequestModifyDefault with default headers values
func NewMultiAdminVerifyRequestModifyDefault(code int) *MultiAdminVerifyRequestModifyDefault {
	return &MultiAdminVerifyRequestModifyDefault{
		_statusCode: code,
	}
}

/*
	MultiAdminVerifyRequestModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262309 | The feature must be enabled first. |
| 262329 | Invalid state. State can be modified to approved, vetoed, or executed. |
| 262337 | User not eligible to approve the request. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type MultiAdminVerifyRequestModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this multi admin verify request modify default response has a 2xx status code
func (o *MultiAdminVerifyRequestModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this multi admin verify request modify default response has a 3xx status code
func (o *MultiAdminVerifyRequestModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this multi admin verify request modify default response has a 4xx status code
func (o *MultiAdminVerifyRequestModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this multi admin verify request modify default response has a 5xx status code
func (o *MultiAdminVerifyRequestModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this multi admin verify request modify default response a status code equal to that given
func (o *MultiAdminVerifyRequestModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the multi admin verify request modify default response
func (o *MultiAdminVerifyRequestModifyDefault) Code() int {
	return o._statusCode
}

func (o *MultiAdminVerifyRequestModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/multi-admin-verify/requests/{index}][%d] multi_admin_verify_request_modify default %s", o._statusCode, payload)
}

func (o *MultiAdminVerifyRequestModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/multi-admin-verify/requests/{index}][%d] multi_admin_verify_request_modify default %s", o._statusCode, payload)
}

func (o *MultiAdminVerifyRequestModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *MultiAdminVerifyRequestModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
