// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// MultiAdminVerifyRuleCreateReader is a Reader for the MultiAdminVerifyRuleCreate structure.
type MultiAdminVerifyRuleCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *MultiAdminVerifyRuleCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewMultiAdminVerifyRuleCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewMultiAdminVerifyRuleCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewMultiAdminVerifyRuleCreateCreated creates a MultiAdminVerifyRuleCreateCreated with default headers values
func NewMultiAdminVerifyRuleCreateCreated() *MultiAdminVerifyRuleCreateCreated {
	return &MultiAdminVerifyRuleCreateCreated{}
}

/*
MultiAdminVerifyRuleCreateCreated describes a response with status code 201, with default header values.

Created
*/
type MultiAdminVerifyRuleCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.MultiAdminVerifyRuleResponse
}

// IsSuccess returns true when this multi admin verify rule create created response has a 2xx status code
func (o *MultiAdminVerifyRuleCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this multi admin verify rule create created response has a 3xx status code
func (o *MultiAdminVerifyRuleCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this multi admin verify rule create created response has a 4xx status code
func (o *MultiAdminVerifyRuleCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this multi admin verify rule create created response has a 5xx status code
func (o *MultiAdminVerifyRuleCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this multi admin verify rule create created response a status code equal to that given
func (o *MultiAdminVerifyRuleCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the multi admin verify rule create created response
func (o *MultiAdminVerifyRuleCreateCreated) Code() int {
	return 201
}

func (o *MultiAdminVerifyRuleCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/multi-admin-verify/rules][%d] multiAdminVerifyRuleCreateCreated %s", 201, payload)
}

func (o *MultiAdminVerifyRuleCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/multi-admin-verify/rules][%d] multiAdminVerifyRuleCreateCreated %s", 201, payload)
}

func (o *MultiAdminVerifyRuleCreateCreated) GetPayload() *models.MultiAdminVerifyRuleResponse {
	return o.Payload
}

func (o *MultiAdminVerifyRuleCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.MultiAdminVerifyRuleResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewMultiAdminVerifyRuleCreateDefault creates a MultiAdminVerifyRuleCreateDefault with default headers values
func NewMultiAdminVerifyRuleCreateDefault(code int) *MultiAdminVerifyRuleCreateDefault {
	return &MultiAdminVerifyRuleCreateDefault{
		_statusCode: code,
	}
}

/*
	MultiAdminVerifyRuleCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262148 | The specified command is not recognized. |
| 262308 | The specified command is not supported by this feature. |
| 262309 | The feature must be enabled first. |
| 262311 | Value must be greater than zero. |
| 262312 | Number of required approvers must be less than the total number of unique approvers in the approval-groups. |
| 262313 | Number of unique approvers in the approval-groups must be greater than the number of required approvers. |
| 262314 | Some approval-groups were not found. |
| 262316 | Value must be in the range two minutes to two weeks. |
| 262326 | Failed to parse query. |
| 262335 | The query string must be contained in either the "operation" or "query" parameters but not in both. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type MultiAdminVerifyRuleCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this multi admin verify rule create default response has a 2xx status code
func (o *MultiAdminVerifyRuleCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this multi admin verify rule create default response has a 3xx status code
func (o *MultiAdminVerifyRuleCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this multi admin verify rule create default response has a 4xx status code
func (o *MultiAdminVerifyRuleCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this multi admin verify rule create default response has a 5xx status code
func (o *MultiAdminVerifyRuleCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this multi admin verify rule create default response a status code equal to that given
func (o *MultiAdminVerifyRuleCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the multi admin verify rule create default response
func (o *MultiAdminVerifyRuleCreateDefault) Code() int {
	return o._statusCode
}

func (o *MultiAdminVerifyRuleCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/multi-admin-verify/rules][%d] multi_admin_verify_rule_create default %s", o._statusCode, payload)
}

func (o *MultiAdminVerifyRuleCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/multi-admin-verify/rules][%d] multi_admin_verify_rule_create default %s", o._statusCode, payload)
}

func (o *MultiAdminVerifyRuleCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *MultiAdminVerifyRuleCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
