// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// MultiAdminVerifyRuleDeleteCollectionReader is a Reader for the MultiAdminVerifyRuleDeleteCollection structure.
type MultiAdminVerifyRuleDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *MultiAdminVerifyRuleDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewMultiAdminVerifyRuleDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewMultiAdminVerifyRuleDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewMultiAdminVerifyRuleDeleteCollectionOK creates a MultiAdminVerifyRuleDeleteCollectionOK with default headers values
func NewMultiAdminVerifyRuleDeleteCollectionOK() *MultiAdminVerifyRuleDeleteCollectionOK {
	return &MultiAdminVerifyRuleDeleteCollectionOK{}
}

/*
MultiAdminVerifyRuleDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type MultiAdminVerifyRuleDeleteCollectionOK struct {
}

// IsSuccess returns true when this multi admin verify rule delete collection o k response has a 2xx status code
func (o *MultiAdminVerifyRuleDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this multi admin verify rule delete collection o k response has a 3xx status code
func (o *MultiAdminVerifyRuleDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this multi admin verify rule delete collection o k response has a 4xx status code
func (o *MultiAdminVerifyRuleDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this multi admin verify rule delete collection o k response has a 5xx status code
func (o *MultiAdminVerifyRuleDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this multi admin verify rule delete collection o k response a status code equal to that given
func (o *MultiAdminVerifyRuleDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the multi admin verify rule delete collection o k response
func (o *MultiAdminVerifyRuleDeleteCollectionOK) Code() int {
	return 200
}

func (o *MultiAdminVerifyRuleDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /security/multi-admin-verify/rules][%d] multiAdminVerifyRuleDeleteCollectionOK", 200)
}

func (o *MultiAdminVerifyRuleDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /security/multi-admin-verify/rules][%d] multiAdminVerifyRuleDeleteCollectionOK", 200)
}

func (o *MultiAdminVerifyRuleDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewMultiAdminVerifyRuleDeleteCollectionDefault creates a MultiAdminVerifyRuleDeleteCollectionDefault with default headers values
func NewMultiAdminVerifyRuleDeleteCollectionDefault(code int) *MultiAdminVerifyRuleDeleteCollectionDefault {
	return &MultiAdminVerifyRuleDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	MultiAdminVerifyRuleDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262310 | System rules cannot be deleted or have their query modified. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type MultiAdminVerifyRuleDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this multi admin verify rule delete collection default response has a 2xx status code
func (o *MultiAdminVerifyRuleDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this multi admin verify rule delete collection default response has a 3xx status code
func (o *MultiAdminVerifyRuleDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this multi admin verify rule delete collection default response has a 4xx status code
func (o *MultiAdminVerifyRuleDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this multi admin verify rule delete collection default response has a 5xx status code
func (o *MultiAdminVerifyRuleDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this multi admin verify rule delete collection default response a status code equal to that given
func (o *MultiAdminVerifyRuleDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the multi admin verify rule delete collection default response
func (o *MultiAdminVerifyRuleDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *MultiAdminVerifyRuleDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/multi-admin-verify/rules][%d] multi_admin_verify_rule_delete_collection default %s", o._statusCode, payload)
}

func (o *MultiAdminVerifyRuleDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/multi-admin-verify/rules][%d] multi_admin_verify_rule_delete_collection default %s", o._statusCode, payload)
}

func (o *MultiAdminVerifyRuleDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *MultiAdminVerifyRuleDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
MultiAdminVerifyRuleDeleteCollectionBody multi admin verify rule delete collection body
swagger:model MultiAdminVerifyRuleDeleteCollectionBody
*/
type MultiAdminVerifyRuleDeleteCollectionBody struct {

	// multi admin verify rule response inline records
	MultiAdminVerifyRuleResponseInlineRecords []*models.MultiAdminVerifyRule `json:"records,omitempty"`
}

// Validate validates this multi admin verify rule delete collection body
func (o *MultiAdminVerifyRuleDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateMultiAdminVerifyRuleResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MultiAdminVerifyRuleDeleteCollectionBody) validateMultiAdminVerifyRuleResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.MultiAdminVerifyRuleResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.MultiAdminVerifyRuleResponseInlineRecords); i++ {
		if swag.IsZero(o.MultiAdminVerifyRuleResponseInlineRecords[i]) { // not required
			continue
		}

		if o.MultiAdminVerifyRuleResponseInlineRecords[i] != nil {
			if err := o.MultiAdminVerifyRuleResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this multi admin verify rule delete collection body based on the context it is used
func (o *MultiAdminVerifyRuleDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateMultiAdminVerifyRuleResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MultiAdminVerifyRuleDeleteCollectionBody) contextValidateMultiAdminVerifyRuleResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.MultiAdminVerifyRuleResponseInlineRecords); i++ {

		if o.MultiAdminVerifyRuleResponseInlineRecords[i] != nil {
			if err := o.MultiAdminVerifyRuleResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *MultiAdminVerifyRuleDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *MultiAdminVerifyRuleDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res MultiAdminVerifyRuleDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
