// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// MultiAdminVerifyRuleModifyCollectionReader is a Reader for the MultiAdminVerifyRuleModifyCollection structure.
type MultiAdminVerifyRuleModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *MultiAdminVerifyRuleModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewMultiAdminVerifyRuleModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewMultiAdminVerifyRuleModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewMultiAdminVerifyRuleModifyCollectionOK creates a MultiAdminVerifyRuleModifyCollectionOK with default headers values
func NewMultiAdminVerifyRuleModifyCollectionOK() *MultiAdminVerifyRuleModifyCollectionOK {
	return &MultiAdminVerifyRuleModifyCollectionOK{}
}

/*
MultiAdminVerifyRuleModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type MultiAdminVerifyRuleModifyCollectionOK struct {
}

// IsSuccess returns true when this multi admin verify rule modify collection o k response has a 2xx status code
func (o *MultiAdminVerifyRuleModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this multi admin verify rule modify collection o k response has a 3xx status code
func (o *MultiAdminVerifyRuleModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this multi admin verify rule modify collection o k response has a 4xx status code
func (o *MultiAdminVerifyRuleModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this multi admin verify rule modify collection o k response has a 5xx status code
func (o *MultiAdminVerifyRuleModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this multi admin verify rule modify collection o k response a status code equal to that given
func (o *MultiAdminVerifyRuleModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the multi admin verify rule modify collection o k response
func (o *MultiAdminVerifyRuleModifyCollectionOK) Code() int {
	return 200
}

func (o *MultiAdminVerifyRuleModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /security/multi-admin-verify/rules][%d] multiAdminVerifyRuleModifyCollectionOK", 200)
}

func (o *MultiAdminVerifyRuleModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /security/multi-admin-verify/rules][%d] multiAdminVerifyRuleModifyCollectionOK", 200)
}

func (o *MultiAdminVerifyRuleModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewMultiAdminVerifyRuleModifyCollectionDefault creates a MultiAdminVerifyRuleModifyCollectionDefault with default headers values
func NewMultiAdminVerifyRuleModifyCollectionDefault(code int) *MultiAdminVerifyRuleModifyCollectionDefault {
	return &MultiAdminVerifyRuleModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	MultiAdminVerifyRuleModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262310 | System rules cannot be deleted or have their query modified. |
| 262311 | Value must be greater than zero. |
| 262312 | Number of required approvers must be less than the total number of unique approvers in the approval-groups. |
| 262313 | Number of unique approvers in the approval-groups must be greater than the number of required approvers. |
| 262316 | Value must be in the range two minutes to two weeks. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type MultiAdminVerifyRuleModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this multi admin verify rule modify collection default response has a 2xx status code
func (o *MultiAdminVerifyRuleModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this multi admin verify rule modify collection default response has a 3xx status code
func (o *MultiAdminVerifyRuleModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this multi admin verify rule modify collection default response has a 4xx status code
func (o *MultiAdminVerifyRuleModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this multi admin verify rule modify collection default response has a 5xx status code
func (o *MultiAdminVerifyRuleModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this multi admin verify rule modify collection default response a status code equal to that given
func (o *MultiAdminVerifyRuleModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the multi admin verify rule modify collection default response
func (o *MultiAdminVerifyRuleModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *MultiAdminVerifyRuleModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/multi-admin-verify/rules][%d] multi_admin_verify_rule_modify_collection default %s", o._statusCode, payload)
}

func (o *MultiAdminVerifyRuleModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/multi-admin-verify/rules][%d] multi_admin_verify_rule_modify_collection default %s", o._statusCode, payload)
}

func (o *MultiAdminVerifyRuleModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *MultiAdminVerifyRuleModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
MultiAdminVerifyRuleModifyCollectionBody multi admin verify rule modify collection body
swagger:model MultiAdminVerifyRuleModifyCollectionBody
*/
type MultiAdminVerifyRuleModifyCollectionBody struct {

	// Time for requests to be approved, in ISO-8601 duration format. If not set, the global setting is used.
	ApprovalExpiry *string `json:"approval_expiry,omitempty"`

	// When true, ONTAP automatically creates a request for any failed operation where there is no matching pending request.
	AutoRequestCreate *bool `json:"auto_request_create,omitempty"`

	// create time
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// Time for requests to be executed once approved, in ISO-8601 duration format. If not set, the global setting is used.
	ExecutionExpiry *string `json:"execution_expiry,omitempty"`

	// List of approval groups that are allowed to approve requests for rules that don't have approval groups.
	MultiAdminVerifyRuleInlineApprovalGroups []*models.MultiAdminVerifyRuleInlineApprovalGroupsInlineArrayItem `json:"approval_groups,omitempty"`

	// multi admin verify rule response inline records
	MultiAdminVerifyRuleResponseInlineRecords []*models.MultiAdminVerifyRule `json:"records,omitempty"`

	// Command that requires one or more approvals.
	Operation *string `json:"operation,omitempty"`

	// owner
	Owner *models.MultiAdminVerifyRuleInlineOwner `json:"owner,omitempty"`

	// When specified, this property limits the entries that require approvals to those that match the specified query.
	Query *string `json:"query,omitempty"`

	// The number of required approvers, excluding the user that made the request.
	RequiredApprovers *int64 `json:"required_approvers,omitempty"`

	// Specifies whether the rule is system-defined or user-defined.
	// Read Only: true
	SystemDefined *bool `json:"system_defined,omitempty"`
}

// Validate validates this multi admin verify rule modify collection body
func (o *MultiAdminVerifyRuleModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMultiAdminVerifyRuleInlineApprovalGroups(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMultiAdminVerifyRuleResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOwner(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MultiAdminVerifyRuleModifyCollectionBody) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *MultiAdminVerifyRuleModifyCollectionBody) validateMultiAdminVerifyRuleInlineApprovalGroups(formats strfmt.Registry) error {
	if swag.IsZero(o.MultiAdminVerifyRuleInlineApprovalGroups) { // not required
		return nil
	}

	for i := 0; i < len(o.MultiAdminVerifyRuleInlineApprovalGroups); i++ {
		if swag.IsZero(o.MultiAdminVerifyRuleInlineApprovalGroups[i]) { // not required
			continue
		}

		if o.MultiAdminVerifyRuleInlineApprovalGroups[i] != nil {
			if err := o.MultiAdminVerifyRuleInlineApprovalGroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "approval_groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *MultiAdminVerifyRuleModifyCollectionBody) validateMultiAdminVerifyRuleResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.MultiAdminVerifyRuleResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.MultiAdminVerifyRuleResponseInlineRecords); i++ {
		if swag.IsZero(o.MultiAdminVerifyRuleResponseInlineRecords[i]) { // not required
			continue
		}

		if o.MultiAdminVerifyRuleResponseInlineRecords[i] != nil {
			if err := o.MultiAdminVerifyRuleResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *MultiAdminVerifyRuleModifyCollectionBody) validateOwner(formats strfmt.Registry) error {
	if swag.IsZero(o.Owner) { // not required
		return nil
	}

	if o.Owner != nil {
		if err := o.Owner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this multi admin verify rule modify collection body based on the context it is used
func (o *MultiAdminVerifyRuleModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMultiAdminVerifyRuleInlineApprovalGroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMultiAdminVerifyRuleResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSystemDefined(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MultiAdminVerifyRuleModifyCollectionBody) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *MultiAdminVerifyRuleModifyCollectionBody) contextValidateMultiAdminVerifyRuleInlineApprovalGroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.MultiAdminVerifyRuleInlineApprovalGroups); i++ {

		if o.MultiAdminVerifyRuleInlineApprovalGroups[i] != nil {
			if err := o.MultiAdminVerifyRuleInlineApprovalGroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "approval_groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *MultiAdminVerifyRuleModifyCollectionBody) contextValidateMultiAdminVerifyRuleResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.MultiAdminVerifyRuleResponseInlineRecords); i++ {

		if o.MultiAdminVerifyRuleResponseInlineRecords[i] != nil {
			if err := o.MultiAdminVerifyRuleResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *MultiAdminVerifyRuleModifyCollectionBody) contextValidateOwner(ctx context.Context, formats strfmt.Registry) error {

	if o.Owner != nil {
		if err := o.Owner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner")
			}
			return err
		}
	}

	return nil
}

func (o *MultiAdminVerifyRuleModifyCollectionBody) contextValidateSystemDefined(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"system_defined", "body", o.SystemDefined); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *MultiAdminVerifyRuleModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *MultiAdminVerifyRuleModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res MultiAdminVerifyRuleModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
MultiAdminVerifyRuleInlineApprovalGroupsInlineArrayItem multi admin verify rule inline approval groups inline array item
swagger:model multi_admin_verify_rule_inline_approval_groups_inline_array_item
*/
type MultiAdminVerifyRuleInlineApprovalGroupsInlineArrayItem struct {

	// Name of the approval group.
	Name *string `json:"name,omitempty"`
}

// Validate validates this multi admin verify rule inline approval groups inline array item
func (o *MultiAdminVerifyRuleInlineApprovalGroupsInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this multi admin verify rule inline approval groups inline array item based on context it is used
func (o *MultiAdminVerifyRuleInlineApprovalGroupsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *MultiAdminVerifyRuleInlineApprovalGroupsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *MultiAdminVerifyRuleInlineApprovalGroupsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res MultiAdminVerifyRuleInlineApprovalGroupsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
MultiAdminVerifyRuleInlineOwner The owner of the rule. The only valid owner is currently the cluster.
swagger:model multi_admin_verify_rule_inline_owner
*/
type MultiAdminVerifyRuleInlineOwner struct {

	// links
	Links *models.MultiAdminVerifyRuleInlineOwnerInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a POST or PATCH method.
	//
	// Example: svm1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this multi admin verify rule inline owner
func (o *MultiAdminVerifyRuleInlineOwner) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MultiAdminVerifyRuleInlineOwner) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this multi admin verify rule inline owner based on the context it is used
func (o *MultiAdminVerifyRuleInlineOwner) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MultiAdminVerifyRuleInlineOwner) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *MultiAdminVerifyRuleInlineOwner) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"owner"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *MultiAdminVerifyRuleInlineOwner) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *MultiAdminVerifyRuleInlineOwner) UnmarshalBinary(b []byte) error {
	var res MultiAdminVerifyRuleInlineOwner
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
MultiAdminVerifyRuleInlineOwnerInlineLinks multi admin verify rule inline owner inline links
swagger:model multi_admin_verify_rule_inline_owner_inline__links
*/
type MultiAdminVerifyRuleInlineOwnerInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this multi admin verify rule inline owner inline links
func (o *MultiAdminVerifyRuleInlineOwnerInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MultiAdminVerifyRuleInlineOwnerInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this multi admin verify rule inline owner inline links based on the context it is used
func (o *MultiAdminVerifyRuleInlineOwnerInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *MultiAdminVerifyRuleInlineOwnerInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *MultiAdminVerifyRuleInlineOwnerInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *MultiAdminVerifyRuleInlineOwnerInlineLinks) UnmarshalBinary(b []byte) error {
	var res MultiAdminVerifyRuleInlineOwnerInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
